/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsStatisticsUtils {
    public static final GroupDescriptor GROUP = GroupDescriptor.create("IDE Settings", 100.0);

    @Nullable
    public static Object getApplicationProvider(@NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getApplicationProvider"));
        }
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getApplicationComponentByName(providerName));
    }

    public static Set<UsageDescriptor> getUsages(@NotNull IdeSettingsDescriptor descriptor, @NotNull Object componentInstance) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsages"));
        }
        if (componentInstance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsages"));
        }
        HashSet descriptors = new HashSet();
        String providerName = descriptor.myProviderName;
        List<String> propertyNames = descriptor.getPropertyNames();
        if (providerName != null && propertyNames.size() > 0) {
            for (String propertyName : propertyNames) {
                Object propertyValue = IdeSettingsStatisticsUtils.getPropertyValue(componentInstance, propertyName);
                if (propertyValue == null) continue;
                descriptors.add(new UsageDescriptor(IdeSettingsStatisticsUtils.getUsageDescriptorKey(providerName, propertyName, propertyValue.toString()), 1));
            }
        }
        return descriptors;
    }

    @Nullable
    private static Object getPropertyValue(Object componentInstance, String propertyName) {
        Class<?> componentInstanceClass = componentInstance.getClass();
        Object propertyValue = null;
        try {
            Field field = componentInstanceClass.getDeclaredField(propertyName);
            propertyValue = field.get(componentInstance);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (IllegalAccessException ignored) {
            // empty catch block
        }
        if (propertyValue == null) {
            Method method = IdeSettingsStatisticsUtils.getMethod(componentInstanceClass, "get" + StringUtil.capitalize((String)propertyName));
            if (method == null) {
                method = IdeSettingsStatisticsUtils.getMethod(componentInstanceClass, "is" + StringUtil.capitalize((String)propertyName));
            }
            if (method != null) {
                try {
                    propertyValue = method.invoke(componentInstance, new Object[0]);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        return propertyValue;
    }

    @Nullable
    private static Method getMethod(@NotNull Class componentInstanceClass, @NotNull String name) {
        if (componentInstanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getMethod"));
        }
        try {
            return componentInstanceClass.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static String getUsageDescriptorKey(@NotNull String providerName, @NotNull String name, @NotNull String value) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getUsageDescriptorKey"));
        }
        String shortName = StringUtil.getShortName((String)providerName);
        return shortName + "#" + name + "(" + value + ")";
    }

    @Nullable
    public static Object getProjectProvider(@Nullable Project project, @NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getProjectProvider"));
        }
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getProjectComponentByName(project, providerName));
    }

    @Nullable
    private static Object getProviderInstance(Object componentInstance) {
        if (componentInstance instanceof PersistentStateComponent) {
            return ((PersistentStateComponent)componentInstance).getState();
        }
        return componentInstance;
    }

    @Nullable
    private static Object getApplicationComponentByName(@NotNull String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsUtils", "getApplicationComponentByName"));
        }
        return ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)providerName);
    }

    @Nullable
    private static Object getProjectComponentByName(@Nullable Project project, String providerName) {
        if (project != null) {
            return project.getPicoContainer().getComponentInstance((Object)providerName);
        }
        return null;
    }
}

