/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsConnectionService
extends SettingsConnectionService {
    private static final String PERMISSION_ATTR_NAME = "permitted";
    private static final String DISABLED = "disabled";

    public StatisticsConnectionService() {
        this(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsSettingsUrl(), ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsServiceUrl());
    }

    public StatisticsConnectionService(@NotNull String settingsUrl, @Nullable String defaultServiceUrl) {
        if (settingsUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/internal/statistic/connect/StatisticsConnectionService", "<init>"));
        }
        super(settingsUrl, defaultServiceUrl);
    }

    @NotNull
    public String[] getAttributeNames() {
        String[] stringArray = (String[])ArrayUtil.append((Object[])super.getAttributeNames(), (Object)PERMISSION_ATTR_NAME);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/connect/StatisticsConnectionService", "getAttributeNames"));
        }
        return stringArray;
    }

    public Boolean isTransmissionPermitted() {
        String permitted = this.getSettingValue(PERMISSION_ATTR_NAME);
        return permitted == null ? true : Boolean.parseBoolean(permitted);
    }

    @NotNull
    public Set<String> getDisabledGroups() {
        String disabledGroupsString = this.getSettingValue(DISABLED);
        if (disabledGroupsString == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/connect/StatisticsConnectionService", "getDisabledGroups"));
            }
            return set;
        }
        List disabledGroupsList = StringUtil.split((String)disabledGroupsString, (String)",");
        Set set = ContainerUtil.map2Set((Collection)disabledGroupsList, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.trim();
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/connect/StatisticsConnectionService", "getDisabledGroups"));
        }
        return set;
    }
}

