/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.RangeMarkerWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import org.jetbrains.annotations.NotNull;

public class FoldingRegionWindow
extends RangeMarkerWindow
implements FoldRegion {
    private final EditorWindow myEditorWindow;
    private final FoldRegionImpl myHostRegion;

    public FoldingRegionWindow(@NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow, @NotNull FoldRegionImpl hostRegion, int startShift, int endShift) {
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        if (editorWindow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        if (hostRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        super(documentWindow, hostRegion, startShift, endShift);
        this.myEditorWindow = editorWindow;
        this.myHostRegion = hostRegion;
    }

    public boolean isExpanded() {
        return this.myHostRegion.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.myHostRegion.setExpanded(expanded);
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myHostRegion.getPlaceholderText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/FoldingRegionWindow", "getPlaceholderText"));
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditorWindow;
    }

    public FoldingGroup getGroup() {
        return this.myHostRegion.getGroup();
    }

    public boolean shouldNeverExpand() {
        return false;
    }

    @Override
    public FoldRegionImpl getDelegate() {
        return this.myHostRegion;
    }
}

