/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SmartTreeStructure
extends AbstractTreeStructure {
    protected final TreeModel myModel;
    protected final Project myProject;
    private TreeElementWrapper myRootElementWrapper;

    public SmartTreeStructure(@NotNull Project project, @NotNull TreeModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "<init>"));
        }
        this.myModel = model;
        this.myProject = project;
    }

    public void commit() {
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)element;
        if (abstractTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/smartTree/SmartTreeStructure", "createDescriptor"));
        }
        return abstractTreeNode;
    }

    public Object[] getChildElements(Object element) {
        return ((AbstractTreeNode)element).getChildren().toArray();
    }

    public Object getParentElement(Object element) {
        return ((AbstractTreeNode)element).getParent();
    }

    public Object getRootElement() {
        if (this.myRootElementWrapper == null) {
            this.myRootElementWrapper = this.createTree();
        }
        return this.myRootElementWrapper;
    }

    protected TreeElementWrapper createTree() {
        return new TreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
    }

    public boolean isAlwaysLeaf(Object element) {
        return ((AbstractTreeNode)element).isAlwaysLeaf();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    public void rebuildTree() {
        ((CachingChildrenTreeNode)((Object)this.getRootElement())).rebuildChildren();
    }
}

