/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeEditorPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ScopeConfigurable
extends NamedConfigurable<NamedScope> {
    private NamedScope myScope;
    private ScopeEditorPanel myPanel;
    private String myPackageSet;
    private final JCheckBox mySharedCheckbox;
    private boolean myShareScope = false;
    private final Project myProject;
    private Icon myIcon;

    public ScopeConfigurable(NamedScope scope, boolean shareScope, Project project, Runnable updateTree) {
        super(true, updateTree);
        this.myScope = scope;
        this.myShareScope = shareScope;
        this.myProject = project;
        this.mySharedCheckbox = new JCheckBox(IdeBundle.message((String)"share.scope.checkbox.title", (Object[])new Object[0]), shareScope);
        this.myPanel = new ScopeEditorPanel(project, this.getHolder());
        this.myIcon = this.getHolder(this.myShareScope).getIcon();
        this.mySharedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeConfigurable.this.myIcon = ScopeConfigurable.this.getHolder().getIcon();
                ScopeConfigurable.this.myPanel.setHolder(ScopeConfigurable.this.getHolder());
            }
        });
    }

    public void setDisplayName(String name) {
        if (Comparing.strEqual((String)this.myScope.getName(), (String)name)) {
            return;
        }
        PackageSet packageSet = this.myScope.getValue();
        this.myScope = new NamedScope(name, packageSet != null ? packageSet.createCopy() : null);
    }

    public NamedScope getEditableObject() {
        return new NamedScope(this.myScope.getName(), this.myPanel.getCurrentScope());
    }

    public String getBannerSlogan() {
        return IdeBundle.message((String)"scope.banner.text", (Object[])new Object[]{this.myScope.getName()});
    }

    public String getDisplayName() {
        return this.myScope.getName();
    }

    public NamedScopesHolder getHolder() {
        return this.getHolder(this.mySharedCheckbox.isSelected());
    }

    private NamedScopesHolder getHolder(boolean local) {
        return local ? DependencyValidationManager.getInstance((Project)this.myProject) : NamedScopeManager.getInstance((Project)this.myProject);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "project.scopes";
    }

    public JComponent createOptionsPanel() {
        JPanel wholePanel = new JPanel(new BorderLayout());
        wholePanel.add((Component)this.myPanel.getPanel(), "Center");
        wholePanel.add((Component)this.mySharedCheckbox, "South");
        return wholePanel;
    }

    public boolean isModified() {
        if (this.mySharedCheckbox.isSelected() != this.myShareScope) {
            return true;
        }
        PackageSet currentScope = this.myPanel.getCurrentScope();
        return !Comparing.strEqual((String)this.myPackageSet, (String)(currentScope != null ? currentScope.getText() : null));
    }

    public void apply() throws ConfigurationException {
        try {
            this.myPanel.apply();
            PackageSet packageSet = this.myPanel.getCurrentScope();
            this.myScope = new NamedScope(this.myScope.getName(), packageSet);
            this.myPackageSet = packageSet != null ? packageSet.getText() : null;
            this.myShareScope = this.mySharedCheckbox.isSelected();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void reset() {
        this.mySharedCheckbox.setSelected(this.myShareScope);
        this.myPanel.reset(this.myScope.getValue(), null);
        PackageSet packageSet = this.myScope.getValue();
        this.myPackageSet = packageSet != null ? packageSet.getText() : null;
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.cancelCurrentProgress();
            this.myPanel.clearCaches();
            this.myPanel = null;
        }
    }

    public void cancelCurrentProgress() {
        if (this.myPanel != null) {
            this.myPanel.cancelCurrentProgress();
        }
    }

    public NamedScope getScope() {
        return this.myScope;
    }

    public void restoreCanceledProgress() {
        if (this.myPanel != null) {
            this.myPanel.restoreCanceledProgress();
        }
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }
}

