/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.IgnoringComboBox;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.PlatformUtils;
import com.intellij.util.TreeItem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    private boolean mySuggestSearchInLibs;
    private boolean myPrevSearchFiles;
    private NamedScopesHolder.ScopeListener myScopeListener;
    private NamedScopeManager myNamedScopeManager;
    private DependencyValidationManager myValidationManager;

    public ScopeChooserCombo() {
        super((JComboBox)new IgnoringComboBox(){

            @Override
            protected boolean isIgnored(Object item) {
                return item instanceof ScopeSeparator;
            }
        });
    }

    public ScopeChooserCombo(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project, String preselect) {
        this.init(project, false, true, preselect);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.mySuggestSearchInLibs = suggestSearchInLibs;
        this.myPrevSearchFiles = prevSearchWholeFiles;
        this.myProject = project;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                SearchScope selectedScope = ScopeChooserCombo.this.getSelectedScope();
                ScopeChooserCombo.this.rebuildModel();
                if (selectedScope != null) {
                    ScopeChooserCombo.this.selectScope(selectedScope.getDisplayName());
                }
            }
        };
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.addActionListener(this.createScopeChooserListener());
        JComboBox combo = this.getComboBox();
        combo.setRenderer(new ScopeDescriptionWithDelimiterRenderer());
        this.rebuildModel();
        this.selectScope(preselect);
    }

    public void dispose() {
        super.dispose();
        if (this.myValidationManager != null) {
            this.myValidationManager.removeScopeListener(this.myScopeListener);
            this.myValidationManager = null;
        }
        if (this.myNamedScopeManager != null) {
            this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
            this.myNamedScopeManager = null;
        }
        this.myScopeListener = null;
    }

    private void selectScope(String preselect) {
        if (preselect != null) {
            JComboBox combo = this.getComboBox();
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ScopeDescriptor descriptor = (ScopeDescriptor)model.getElementAt(i);
                if (!preselect.equals(descriptor.getDisplay())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private ActionListener createScopeChooserListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = ScopeChooserCombo.this.getSelectedScopeName();
                EditScopesDialog dlg = EditScopesDialog.showDialog(ScopeChooserCombo.this.myProject, selection);
                if (dlg.isOK()) {
                    ScopeChooserCombo.this.rebuildModel();
                    NamedScope namedScope = dlg.getSelectedScope();
                    if (namedScope != null) {
                        ScopeChooserCombo.this.selectScope(namedScope.getName());
                    }
                }
            }
        };
    }

    private void rebuildModel() {
        this.getComboBox().setModel(this.createModel());
    }

    private DefaultComboBoxModel createModel() {
        NamedScopesHolder[] holders;
        DefaultComboBoxModel<ScopeDescriptor> model = new DefaultComboBoxModel<ScopeDescriptor>();
        this.createPredefinedScopeDescriptors(model);
        model.addElement(new ScopeSeparator("VCS Scopes"));
        List<NamedScope> changeLists = ChangeListsScopesProvider.getInstance(this.myProject).getCustomScopes();
        for (NamedScope changeListScope : changeLists) {
            GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)changeListScope);
            model.addElement(new ScopeDescriptor((SearchScope)scope));
        }
        ArrayList<ScopeDescriptor> customScopes = new ArrayList<ScopeDescriptor>();
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                GlobalSearchScope searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)scope);
                customScopes.add(new ScopeDescriptor((SearchScope)searchScope));
            }
        }
        if (!customScopes.isEmpty()) {
            model.addElement(new ScopeSeparator("Custom Scopes"));
            for (ScopeDescriptor scope : customScopes) {
                model.addElement(scope);
            }
        }
        return model;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    private void createPredefinedScopeDescriptors(DefaultComboBoxModel model) {
        DataContext context = DataManager.getInstance().getDataContext();
        for (SearchScope scope : ScopeChooserCombo.getPredefinedScopes(this.myProject, context, this.mySuggestSearchInLibs, this.myPrevSearchFiles, true, true)) {
            model.addElement(new ScopeDescriptor(scope));
        }
        for (ScopeDescriptorProvider provider : (ScopeDescriptorProvider[])Extensions.getExtensions(ScopeDescriptorProvider.EP_NAME)) {
            for (ScopeDescriptor scopeDescriptor : provider.getScopeDescriptors(this.myProject)) {
                model.addElement(scopeDescriptor);
            }
        }
    }

    public static List<SearchScope> getPredefinedScopes(@NotNull Project project, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView) {
        VirtualFile[] files;
        FavoritesManager favoritesManager;
        UsageView selectedUsageView;
        PsiElement parent;
        int end;
        PsiElement endElement;
        int start;
        PsiElement startElement;
        SelectionModel selectionModel;
        PsiFile psiFile;
        FileEditorManager fileEditorManager;
        Editor selectedTextEditor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo", "getPredefinedScopes"));
        }
        ArrayList<SearchScope> result = new ArrayList<SearchScope>();
        result.add((SearchScope)GlobalSearchScope.projectScope((Project)project));
        if (suggestSearchInLibs) {
            result.add((SearchScope)GlobalSearchScope.allScope((Project)project));
        }
        if (!PlatformUtils.isCidr() && ModuleUtil.isSupportedRootType((Project)project, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            result.add((SearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            result.add((SearchScope)GlobalSearchScopesCore.projectTestScope((Project)project));
        }
        result.add((SearchScope)GlobalSearchScopes.openFilesScope((Project)project));
        if (dataContext != null) {
            PsiElement dataContextElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (dataContextElement == null) {
                dataContextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            if (dataContextElement != null) {
                if (!PlatformUtils.isCidr()) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dataContextElement);
                    if (module == null) {
                        module = (Module)LangDataKeys.MODULE.getData(dataContext);
                    }
                    if (module != null) {
                        result.add((SearchScope)module.getModuleScope());
                    }
                }
                if (dataContextElement.getContainingFile() != null) {
                    result.add((SearchScope)new LocalSearchScope(dataContextElement, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
                }
            }
        }
        if (currentSelection && (selectedTextEditor = (fileEditorManager = FileEditorManager.getInstance((Project)project)).getSelectedTextEditor()) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedTextEditor.getDocument())) != null && (selectionModel = selectedTextEditor.getSelectionModel()).hasSelection() && (startElement = psiFile.findElementAt(start = selectionModel.getSelectionStart())) != null && (endElement = psiFile.findElementAt(end = selectionModel.getSelectionEnd())) != null && (parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement)) != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            PsiElement[] children = parent.getChildren();
            TextRange selection = new TextRange(start, end);
            for (PsiElement child : children) {
                if (child instanceof PsiWhiteSpace || child.getContainingFile() == null || !selection.contains(child.getTextOffset())) continue;
                elements.add(child);
            }
            if (!elements.isEmpty()) {
                LocalSearchScope local = new LocalSearchScope(PsiUtilCore.toPsiElementArray(elements), IdeBundle.message((String)"scope.selection", (Object[])new Object[0]));
                result.add((SearchScope)local);
            }
        }
        if (usageView && (selectedUsageView = UsageViewManager.getInstance((Project)project).getSelectedUsageView()) != null && !selectedUsageView.isSearchInProgress()) {
            Set usages = selectedUsageView.getUsages();
            ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
            if (prevSearchFiles) {
                final HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
                for (Usage usage : usages) {
                    VirtualFile file;
                    PsiFile psiFile2;
                    PsiElement psiElement;
                    if (!(usage instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage).getElement()) == null || !psiElement.isValid() || (psiFile2 = psiElement.getContainingFile()) == null || (file = psiFile2.getVirtualFile()) == null) continue;
                    files2.add(file);
                }
                if (!files2.isEmpty()) {
                    GlobalSearchScope prev = new GlobalSearchScope(project){

                        public String getDisplayName() {
                            return IdeBundle.message((String)"scope.files.in.previous.search.result", (Object[])new Object[0]);
                        }

                        public boolean contains(@NotNull VirtualFile file) {
                            if (file == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$4", "contains"));
                            }
                            return files2.contains(file);
                        }

                        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                            if (file1 == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$4", "compare"));
                            }
                            if (file2 == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$4", "compare"));
                            }
                            return 0;
                        }

                        public boolean isSearchInModuleContent(@NotNull Module aModule) {
                            if (aModule == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$4", "isSearchInModuleContent"));
                            }
                            return true;
                        }

                        public boolean isSearchInLibraries() {
                            return true;
                        }
                    };
                    result.add((SearchScope)prev);
                }
            } else {
                for (Usage usage : usages) {
                    PsiElement element;
                    if (!(usage instanceof PsiElementUsage) || (element = ((PsiElementUsage)usage).getElement()) == null || !element.isValid() || element.getContainingFile() == null) continue;
                    results.add(element);
                }
                if (!results.isEmpty()) {
                    result.add((SearchScope)new LocalSearchScope(PsiUtilCore.toPsiElementArray(results), IdeBundle.message((String)"scope.previous.search.results", (Object[])new Object[0])));
                }
            }
        }
        if ((favoritesManager = FavoritesManager.getInstance(project)) != null) {
            for (final String favorite : favoritesManager.getAvailableFavoritesListNames()) {
                List<TreeItem<Pair<AbstractUrl, String>>> rootUrls = favoritesManager.getFavoritesListRootUrls(favorite);
                if (rootUrls.isEmpty()) continue;
                result.add((SearchScope)new GlobalSearchScope(project){

                    public String getDisplayName() {
                        return "Favorite '" + favorite + "'";
                    }

                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$5", "contains"));
                        }
                        return favoritesManager.contains(favorite, file);
                    }

                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        if (file1 == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$5", "compare"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$5", "compare"));
                        }
                        return 0;
                    }

                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$5", "isSearchInModuleContent"));
                        }
                        return true;
                    }

                    public boolean isSearchInLibraries() {
                        return true;
                    }
                });
            }
        }
        if (dataContext != null && (files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null) {
            List<VirtualFile> openFiles = Arrays.asList(files);
            result.add((SearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.filesScope((Project)project, openFiles)){

                public String getDisplayName() {
                    return "Selected Files";
                }
            });
        }
        return result;
    }

    @Nullable
    public SearchScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getDisplay();
    }

    private static class ScopeDescriptionWithDelimiterRenderer
    extends ListCellRendererWrapper<ScopeDescriptor> {
        private ScopeDescriptionWithDelimiterRenderer() {
        }

        public void customize(JList list, ScopeDescriptor value, int index, boolean selected, boolean hasFocus) {
            this.setText(value.getDisplay());
            if (value instanceof ScopeSeparator) {
                this.setSeparator();
            }
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        private final String myText;

        public ScopeSeparator(String text) {
            super(null);
            this.myText = text;
        }

        @Override
        public String getDisplay() {
            return this.myText;
        }
    }
}

