/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class NamePathComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.NamePathComponent");
    private JTextField myTfName = new JTextField();
    private JTextField myTfPath;
    private boolean myIsNameChangedByUser = false;
    private boolean myIsPathChangedByUser = false;
    private boolean myIsPathNameSyncEnabled = true;
    private boolean myIsNamePathSyncEnabled = true;
    private boolean myIsSyncEnabled = true;
    private FieldPanel myPathPanel;
    private JLabel myNameLabel;
    private JLabel myPathLabel;
    private boolean myForceSync;

    public NamePathComponent(String nameLabelText, String pathLabelText, char nameMnemonic, char locationMnemonic, String pathChooserTitle, String pathChooserDescription) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, hideIgnored, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored, boolean bold) {
        super(new GridBagLayout());
        this.myTfName.setDocument(new NameFieldDocument());
        this.myTfName.setPreferredSize(new Dimension(200, this.myTfName.getPreferredSize().height));
        this.myTfPath = new JTextField();
        this.myTfPath.setDocument(new PathFieldDocument());
        this.myTfPath.setPreferredSize(new Dimension(200, this.myTfPath.getPreferredSize().height));
        this.myNameLabel = new JLabel(nameLabelText);
        if (bold) {
            this.myNameLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        this.myNameLabel.setLabelFor(this.myTfName);
        Insets insets = new Insets(0, 0, 5, 4);
        this.add((Component)this.myNameLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.myTfName, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        FileChooserDescriptor chooserDescriptor = (FileChooserDescriptor)BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR.clone();
        chooserDescriptor.setHideIgnored(hideIgnored);
        BrowseFilesListener browseButtonActionListener = new BrowseFilesListener(this.myTfPath, pathChooserTitle, pathChooserDescription, chooserDescriptor){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                NamePathComponent.this.myIsPathChangedByUser = true;
            }
        };
        this.myPathPanel = new FieldPanel(this.myTfPath, null, null, (ActionListener)browseButtonActionListener, null);
        this.myPathLabel = new JLabel(pathLabelText);
        this.myPathLabel.setLabelFor(this.myTfPath);
        if (bold) {
            this.myPathLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        insets = new Insets(0, 0, 5, 4);
        this.add((Component)this.myPathLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.myPathPanel, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
    }

    public static NamePathComponent initNamePathComponent(WizardContext context) {
        NamePathComponent component = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String baseDir = context.getProjectFileDirectory();
        String projectName = context.getProjectName();
        String initialProjectName = projectName != null ? projectName : ProjectWizardUtil.findNonExistingFileName(baseDir, "untitled", "");
        component.setPath(projectName == null ? baseDir + File.separator + initialProjectName : baseDir);
        component.setNameValue(initialProjectName);
        component.getNameComponent().select(0, initialProjectName.length());
        return component;
    }

    private String getProjectFilePath(boolean isDefault) {
        if (isDefault) {
            return this.getPath() + "/" + this.getNameValue() + ".ipr";
        }
        return this.getPath() + "/" + ".idea";
    }

    public boolean validateNameAndPath(WizardContext context, boolean defaultFormat) throws ConfigurationException {
        String name = this.getNameValue();
        if (name.length() == 0) {
            ApplicationInfo info = (ApplicationInfo)ApplicationManager.getApplication().getComponent(ApplicationInfo.class);
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{info.getVersionName(), context.getPresentationName()}));
        }
        String projectFileDirectory = this.getPath();
        if (projectFileDirectory.length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{context.getPresentationName()}));
        }
        boolean shouldPromptCreation = this.isPathChangedByUser();
        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{context.getPresentationName()}), projectFileDirectory, shouldPromptCreation)) {
            return false;
        }
        File file = new File(projectFileDirectory);
        if (file.exists() && !file.canWrite()) {
            throw new ConfigurationException(String.format("Directory '%s' is not writable!\nPlease choose another project location.", projectFileDirectory));
        }
        boolean shouldContinue = true;
        File projectFile = new File(this.getProjectFilePath(defaultFormat));
        if (projectFile.exists()) {
            int answer = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{projectFile.getAbsolutePath(), context.getPresentationName()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            shouldContinue = answer == 0;
        }
        return shouldContinue;
    }

    public String getNameValue() {
        return this.myTfName.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameValue(String name) {
        boolean isNameChangedByUser = this.myIsNameChangedByUser;
        this.setNamePathSyncEnabled(false);
        try {
            this.myTfName.setText(name);
        }
        finally {
            this.myIsNameChangedByUser = isNameChangedByUser;
            this.setNamePathSyncEnabled(true);
        }
    }

    public String getPath() {
        return this.myTfPath.getText().trim().replace(File.separatorChar, '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        boolean isPathChangedByUser = this.myIsPathChangedByUser;
        this.setPathNameSyncEnabled(false);
        try {
            this.myTfPath.setText(path);
        }
        finally {
            this.myIsPathChangedByUser = isPathChangedByUser;
            this.setPathNameSyncEnabled(true);
        }
    }

    public JTextField getNameComponent() {
        return this.myTfName;
    }

    @NotNull
    public JLabel getPathLabel() {
        JLabel jLabel = this.myPathLabel;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/NamePathComponent", "getPathLabel"));
        }
        return jLabel;
    }

    public JTextField getPathComponent() {
        return this.myTfPath;
    }

    @NotNull
    public FieldPanel getPathPanel() {
        FieldPanel fieldPanel = this.myPathPanel;
        if (fieldPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/NamePathComponent", "getPathPanel"));
        }
        return fieldPanel;
    }

    public void setPathComponentVisible(boolean visible) {
        this.myPathPanel.setVisible(visible);
    }

    public void setNameComponentVisible(boolean visible) {
        this.myTfName.setVisible(visible);
        this.myNameLabel.setVisible(visible);
    }

    public boolean isNameChangedByUser() {
        return this.myIsNameChangedByUser;
    }

    public boolean isPathChangedByUser() {
        return this.myIsPathChangedByUser;
    }

    public boolean isSyncEnabled() {
        return this.myIsSyncEnabled;
    }

    public void setSyncEnabled(boolean isSyncEnabled) {
        this.myIsSyncEnabled = isSyncEnabled;
    }

    private boolean isPathNameSyncEnabled() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.myIsPathNameSyncEnabled;
    }

    private void setPathNameSyncEnabled(boolean isPathNameSyncEnabled) {
        this.myIsPathNameSyncEnabled = isPathNameSyncEnabled;
    }

    private boolean isNamePathSyncEnabled() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.myIsNamePathSyncEnabled;
    }

    private void setNamePathSyncEnabled(boolean isNamePathSyncEnabled) {
        this.myIsNamePathSyncEnabled = isNamePathSyncEnabled;
    }

    public void syncNameToPath(boolean b) {
        this.myForceSync = b;
        if (b) {
            ((PathFieldDocument)this.myTfPath.getDocument()).syncPathAndName();
        }
    }

    public void addChangeListener(final Runnable callback) {
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                callback.run();
            }
        };
        this.myTfName.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myTfPath.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    private class PathFieldDocument
    extends PlainDocument {
        public PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent event) {
                    NamePathComponent.this.myIsPathChangedByUser = true;
                    PathFieldDocument.this.syncPathAndName();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncPathAndName() {
            if (NamePathComponent.this.isPathNameSyncEnabled() && (NamePathComponent.this.myForceSync || !NamePathComponent.this.myIsNameChangedByUser)) {
                try {
                    NamePathComponent.this.setNamePathSyncEnabled(false);
                    String path = this.getText(0, this.getLength());
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0 && lastSeparatorIndex + 1 < path.length()) {
                        NamePathComponent.this.setNameValue(path.substring(lastSeparatorIndex + 1));
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.setNamePathSyncEnabled(true);
                }
            }
        }
    }

    private class NameFieldDocument
    extends PlainDocument {
        public NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent event) {
                    NamePathComponent.this.myIsNameChangedByUser = true;
                    NameFieldDocument.this.syncNameAndPath();
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean ok = true;
            for (int idx = 0; idx < str.length() && ok; ++idx) {
                char ch = str.charAt(idx);
                ok = ch != File.separatorChar && ch != '\\' && ch != '/' && ch != '|' && ch != ':';
            }
            if (ok) {
                super.insertString(offs, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncNameAndPath() {
            if (NamePathComponent.this.isNamePathSyncEnabled() && (NamePathComponent.this.myForceSync || !NamePathComponent.this.myIsPathChangedByUser)) {
                try {
                    NamePathComponent.this.setPathNameSyncEnabled(false);
                    String name = this.getText(0, this.getLength());
                    String path = NamePathComponent.this.myTfPath.getText().trim();
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0) {
                        NamePathComponent.this.setPath(path.substring(0, lastSeparatorIndex + 1) + name);
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.setPathNameSyncEnabled(true);
                }
            }
        }
    }
}

