/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSymbolNavigationContributor
implements ChooseByNameContributorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.DefaultSymbolNavigationContributor");

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        HashSet set = new HashSet();
        cache.getAllMethodNames(set);
        cache.getAllFieldNames(set);
        cache.getAllClassNames(set);
        String[] stringArray = ArrayUtil.toStringArray((Collection)set);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : cache.getMethodsByName(name, scope)) {
            if (psiMethod.isConstructor() || !DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod) || DefaultSymbolNavigationContributor.hasSuperMethod(psiMethod, scope)) continue;
            result.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache.getFieldsByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache.getClassesByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result.add(psiMethod);
        }
        PsiMember[] array = result.toArray(new PsiMember[result.size()]);
        Arrays.sort(array, MyComparator.INSTANCE);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "getItemsByName"));
        }
        return array;
    }

    private static boolean isOpenable(PsiMember member) {
        return member.getContainingFile().getVirtualFile() != null;
    }

    private static boolean hasSuperMethod(PsiMethod method, GlobalSearchScope scope) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        for (PsiMethod candidate : containingClass.findMethodsByName(method.getName(), true)) {
            if (candidate.getContainingClass() == containingClass || !PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)candidate) || !PsiSuperMethodImplUtil.isSuperMethodSmart(method, candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "processNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "processNames"));
        }
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        cache.processAllClassNames(processor, scope, filter);
        cache.processAllFieldNames(processor, scope, filter);
        cache.processAllMethodNames(processor, scope, filter);
    }

    @Override
    public void processElementsWithName(@NotNull String name, final @NotNull Processor<NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        boolean success;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "processElementsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "processElementsWithName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor", "processElementsWithName"));
        }
        GlobalSearchScope scope = parameters.getSearchScope();
        IdFilter filter = parameters.getIdFilter();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        THashSet collectedMethods = new THashSet();
        boolean bl = success = cache.processFieldsWithName(name, (Processor)new Processor<PsiField>(){

            public boolean process(PsiField field) {
                if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)field)) {
                    return processor.process((Object)field);
                }
                return true;
            }
        }, scope, filter) && cache.processClassesWithName(name, (Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass aClass) {
                if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)aClass)) {
                    return processor.process((Object)aClass);
                }
                return true;
            }
        }, scope, filter) && cache.processMethodsWithName(name, (Processor)new Processor<PsiMethod>((Set)collectedMethods){
            final /* synthetic */ Set val$collectedMethods;
            {
                this.val$collectedMethods = set;
            }

            public boolean process(PsiMethod method) {
                if (!method.isConstructor() && DefaultSymbolNavigationContributor.isOpenable((PsiMember)method)) {
                    this.val$collectedMethods.add(method);
                }
                return true;
            }
        }, scope, filter);
        if (success) {
            Iterator iterator = collectedMethods.iterator();
            while (iterator.hasNext()) {
                PsiMethod method = (PsiMethod)iterator.next();
                if (!DefaultSymbolNavigationContributor.hasSuperMethod(method, scope) && !processor.process((Object)method)) {
                    return;
                }
                ProgressManager.checkCanceled();
                iterator.remove();
            }
        }
    }

    private static class MyComparator
    implements Comparator<PsiModifierListOwner> {
        public static final MyComparator INSTANCE = new MyComparator();
        private final DefaultPsiElementCellRenderer myRenderer = new DefaultPsiElementCellRenderer();

        private MyComparator() {
        }

        @Override
        public int compare(PsiModifierListOwner element1, PsiModifierListOwner element2) {
            String text2;
            String text1;
            int kind2;
            int level2;
            if (element1 == element2) {
                return 0;
            }
            PsiModifierList modifierList1 = element1.getModifierList();
            PsiModifierList modifierList2 = element2.getModifierList();
            int level1 = modifierList1 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList1);
            int n = level2 = modifierList2 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList2);
            if (level1 != level2) {
                return level2 - level1;
            }
            int kind1 = MyComparator.getElementTypeLevel((PsiElement)element1);
            if (kind1 != (kind2 = MyComparator.getElementTypeLevel((PsiElement)element2))) {
                return kind1 - kind2;
            }
            if (element1 instanceof PsiMethod) {
                LOG.assertTrue(element2 instanceof PsiMethod);
                PsiParameter[] parms1 = ((PsiMethod)element1).getParameterList().getParameters();
                PsiParameter[] parms2 = ((PsiMethod)element2).getParameterList().getParameters();
                if (parms1.length != parms2.length) {
                    return parms1.length - parms2.length;
                }
            }
            if (!(text1 = this.myRenderer.getElementText((PsiElement)element1)).equals(text2 = this.myRenderer.getElementText((PsiElement)element2))) {
                return text1.compareTo(text2);
            }
            String containerText1 = this.myRenderer.getContainerText((PsiElement)element1, text1);
            String containerText2 = this.myRenderer.getContainerText((PsiElement)element2, text2);
            if (containerText1 == null) {
                containerText1 = "";
            }
            if (containerText2 == null) {
                containerText2 = "";
            }
            return containerText1.compareTo(containerText2);
        }

        private static int getElementTypeLevel(PsiElement element) {
            if (element instanceof PsiMethod) {
                return 1;
            }
            if (element instanceof PsiField) {
                return 2;
            }
            if (element instanceof PsiClass) {
                return 3;
            }
            LOG.error((Object)element);
            return 0;
        }
    }
}

