/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final ChooseByNameContributor[] myContributors;
    private final ConcurrentHashMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap;
    private volatile IdFilter myIdFilter;
    private volatile boolean myIdFilterForLibraries;

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull ChooseByNameContributor[] contributors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "<init>"));
        }
        if (contributors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "<init>"));
        }
        this.myContributorToItsSymbolsMap = new ConcurrentHashMap();
        this.myProject = project;
        this.myContributors = contributors;
    }

    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == "non-prefix matches:") {
                    Object previousElement = index > 0 ? list.getModel().getElementAt(index - 1) : null;
                    return ChooseByNameBase.renderNonPrefixSeparatorComponent(1.getBackgroundColor(previousElement));
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public boolean sameNamesForProjectAndLibraries() {
        return !ChooseByNameBase.ourLoadNamesEachTime;
    }

    @Override
    public void processNames(final Processor<String> nameProcessor, final boolean checkBoxState) {
        long start = System.currentTimeMillis();
        List<ChooseByNameContributor> liveContribs = this.filterDumb(this.myContributors);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(ChooseByNameContributor contributor) {
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        final TIntHashSet filter = new TIntHashSet(1000);
                        ContributorsBasedGotoByModel.this.myContributorToItsSymbolsMap.put((Object)contributor, (Object)filter);
                        if (contributor instanceof ChooseByNameContributorEx) {
                            ((ChooseByNameContributorEx)contributor).processNames(new Processor<String>(){

                                public boolean process(String s) {
                                    if (nameProcessor.process((Object)s)) {
                                        filter.add(s.hashCode());
                                    }
                                    return true;
                                }
                            }, FindSymbolParameters.searchScopeFor(ContributorsBasedGotoByModel.this.myProject, checkBoxState), ContributorsBasedGotoByModel.this.getIdFilter(checkBoxState));
                        } else {
                            String[] names;
                            for (String element : names = contributor.getNames(ContributorsBasedGotoByModel.this.myProject, checkBoxState)) {
                                if (!nameProcessor.process((Object)element)) continue;
                                filter.add(element.hashCode());
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException ex) {
                }
                catch (IndexNotReadyException ex) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(liveContribs, indicator, true, processor)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start) + "ms;");
        }
    }

    IdFilter getIdFilter(boolean withLibraries) {
        IdFilter idFilter = this.myIdFilter;
        if (idFilter == null || this.myIdFilterForLibraries != withLibraries) {
            this.myIdFilter = idFilter = IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
            this.myIdFilterForLibraries = withLibraries;
        }
        return idFilter;
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        THashSet allNames = ContainerUtil.newTroveSet();
        this.processNames((Processor<String>)new CommonProcessors.CollectProcessor(Collections.synchronizedCollection(allNames)), checkBoxState);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)allNames);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getNames"));
        }
        return stringArray;
    }

    private List<ChooseByNameContributor> filterDumb(ChooseByNameContributor[] contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return Arrays.asList(contributors);
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.length);
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    @NotNull
    public Object[] getElementsByName(final String name, final FindSymbolParameters parameters, final @NotNull ProgressIndicator canceled) {
        if (canceled == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        long elementByNameStarted = System.currentTimeMillis();
        final List items = Collections.synchronizedList(new ArrayList());
        Processor<ChooseByNameContributor> processor = new Processor<ChooseByNameContributor>(){

            public boolean process(ChooseByNameContributor contributor) {
                if (ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                    return true;
                }
                TIntHashSet filter = (TIntHashSet)ContributorsBasedGotoByModel.this.myContributorToItsSymbolsMap.get((Object)contributor);
                if (filter != null && !filter.contains(name.hashCode())) {
                    return true;
                }
                try {
                    boolean searchInLibraries = parameters.getSearchScope().isSearchInLibraries();
                    long contributorStarted = System.currentTimeMillis();
                    if (contributor instanceof ChooseByNameContributorEx) {
                        ((ChooseByNameContributorEx)contributor).processElementsWithName(name, new Processor<NavigationItem>(){

                            public boolean process(NavigationItem item) {
                                canceled.checkCanceled();
                                if (ContributorsBasedGotoByModel.this.acceptItem(item)) {
                                    items.add(item);
                                }
                                return true;
                            }
                        }, parameters);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                        }
                    } else {
                        NavigationItem[] itemsByName;
                        for (NavigationItem item : itemsByName = contributor.getItemsByName(name, parameters.getLocalPatternName(), ContributorsBasedGotoByModel.this.myProject, searchInLibraries)) {
                            canceled.checkCanceled();
                            if (item == null) {
                                PluginId pluginId = PluginManager.getPluginByClassName(contributor.getClass().getName());
                                if (pluginId != null) {
                                    LOG.error((Throwable)new PluginException("null item from contributor " + contributor + " for name " + name, pluginId));
                                    continue;
                                }
                                LOG.error("null item from contributor " + contributor + " for name " + name);
                                continue;
                            }
                            if (!ContributorsBasedGotoByModel.this.acceptItem(item)) continue;
                            items.add(item);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                        }
                    }
                }
                catch (ProcessCanceledException ex) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.filterDumb(this.myContributors), canceled, true, processor)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        return objectArray;
    }

    @NotNull
    public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
        Object[] objectArray = this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "getElementsByName"));
        }
        return objectArray;
    }

    public String getElementName(Object element) {
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors;
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "removeModelSpecificMarkup"));
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel", "removeModelSpecificMarkup"));
        }
        return string;
    }
}

