/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseByNameLanguageFilter
extends ChooseByNameFilter<Language> {
    public ChooseByNameLanguageFilter(@NotNull ChooseByNamePopup popup, @NotNull FilteringGotoByModel<Language> languageFilteringGotoByModel, @NotNull ChooseByNameFilterConfiguration<Language> languageChooseByNameFilterConfiguration, @NotNull Project project) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "<init>"));
        }
        if (languageFilteringGotoByModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "<init>"));
        }
        if (languageChooseByNameFilterConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "<init>"));
        }
        super(popup, languageFilteringGotoByModel, languageChooseByNameFilterConfiguration, project);
    }

    @Override
    protected String textForFilterValue(@NotNull Language value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "textForFilterValue"));
        }
        return value.getDisplayName();
    }

    @Override
    @Nullable
    protected Icon iconForFilterValue(@NotNull Language value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "iconForFilterValue"));
        }
        LanguageFileType fileType = value.getAssociatedFileType();
        return fileType != null ? fileType.getIcon() : null;
    }

    @Override
    @NotNull
    protected Collection<Language> getAllFilterValues() {
        Collection registeredLanguages = Language.getRegisteredLanguages();
        ArrayList<Language> accepted = new ArrayList<Language>();
        for (Language language : registeredLanguages) {
            if (language == Language.ANY || language instanceof DependentLanguage) continue;
            accepted.add(language);
        }
        Collections.sort(accepted, LanguageUtil.LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = accepted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameLanguageFilter", "getAllFilterValues"));
        }
        return arrayList;
    }
}

