/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil");

    private FrameworkSupportUtil() {
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleType moduleType, @NotNull FacetsProvider facetsProvider) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        return FrameworkSupportUtil.getProviders(moduleType, null, facetsProvider);
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        return FrameworkSupportUtil.getProviders(ModuleType.get((Module)module), module, facetsProvider);
    }

    private static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleType moduleType, @Nullable Module module, @NotNull FacetsProvider facetsProvider) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        List<FrameworkSupportInModuleProvider> allProviders = FrameworkSupportUtil.getAllProviders();
        ArrayList<FrameworkSupportInModuleProvider> result = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider provider : allProviders) {
            if (!provider.isEnabledForModuleType(moduleType) || module != null && !provider.canAddSupport(module, facetsProvider)) continue;
            result.add(provider);
        }
        return result;
    }

    public static List<FrameworkSupportInModuleProvider> getAllProviders() {
        ArrayList<FrameworkSupportInModuleProvider> allTypes = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportProvider frameworkSupportProvider : (FrameworkSupportProvider[])FrameworkSupportProvider.EXTENSION_POINT.getExtensions()) {
            allTypes.add(new OldFrameworkSupportProviderWrapper(frameworkSupportProvider));
        }
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            allTypes.add(frameworkTypeEx.createProvider());
        }
        return allTypes;
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "getProviders"));
        }
        ArrayList<FrameworkSupportInModuleProvider> result = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider type : FrameworkSupportUtil.getAllProviders()) {
            if (!type.isEnabledForModuleBuilder(builder)) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean hasProviders(Module module, @NotNull FacetsProvider facetsProvider) {
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "hasProviders"));
        }
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(module, facetsProvider);
        for (FrameworkSupportInModuleProvider provider : providers) {
            if (provider.getFrameworkType().getUnderlyingFrameworkTypeId() != null) continue;
            return true;
        }
        return false;
    }

    public static Comparator<FrameworkSupportInModuleProvider> getFrameworkSupportProvidersComparator(List<FrameworkSupportInModuleProvider> types) {
        DFSTBuilder builder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new ProvidersGraph(types))));
        if (!builder.isAcyclic()) {
            Pair pair = builder.getCircularDependency();
            LOG.error("Circular dependency between types '" + ((FrameworkSupportInModuleProvider)pair.getFirst()).getFrameworkType().getId() + "' and '" + ((FrameworkSupportInModuleProvider)pair.getSecond()).getFrameworkType().getId() + "' was found.");
        }
        return builder.comparator();
    }

    public static FrameworkSupportInModuleProvider findProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "findProvider"));
        }
        return FrameworkSupportUtil.findProvider(id, FrameworkSupportUtil.getAllProviders());
    }

    @Nullable
    public static FrameworkSupportInModuleProvider findProvider(@NotNull String id, List<FrameworkSupportInModuleProvider> providers) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportUtil", "findProvider"));
        }
        for (FrameworkSupportInModuleProvider provider : providers) {
            String frameworkId = provider.getFrameworkType().getId();
            if (!id.equals(frameworkId) && !id.equals("facet:" + frameworkId)) continue;
            return provider;
        }
        LOG.info("Cannot find framework support provider '" + id + "'");
        return null;
    }

    private static class ProvidersGraph
    implements GraphGenerator.SemiGraph<FrameworkSupportInModuleProvider> {
        private final List<FrameworkSupportInModuleProvider> myFrameworkSupportProviders;

        public ProvidersGraph(List<FrameworkSupportInModuleProvider> frameworkSupportProviders) {
            this.myFrameworkSupportProviders = new ArrayList<FrameworkSupportInModuleProvider>(frameworkSupportProviders);
        }

        public Collection<FrameworkSupportInModuleProvider> getNodes() {
            return this.myFrameworkSupportProviders;
        }

        public Iterator<FrameworkSupportInModuleProvider> getIn(FrameworkSupportInModuleProvider provider) {
            FrameworkSupportInModuleProvider underlyingProvider;
            ArrayList<FrameworkSupportInModuleProvider> dependencies = new ArrayList<FrameworkSupportInModuleProvider>();
            String underlyingId = provider.getFrameworkType().getUnderlyingFrameworkTypeId();
            if (underlyingId != null && (underlyingProvider = FrameworkSupportUtil.findProvider(underlyingId, this.myFrameworkSupportProviders)) != null) {
                dependencies.add(underlyingProvider);
            }
            for (FrameworkSupportInModuleProvider.FrameworkDependency frameworkId : provider.getDependenciesFrameworkIds()) {
                FrameworkSupportInModuleProvider dep = FrameworkSupportUtil.findProvider(frameworkId.getFrameworkId(), this.myFrameworkSupportProviders);
                if (dep == null) continue;
                dependencies.add(dep);
            }
            if (provider instanceof OldFrameworkSupportProviderWrapper) {
                String[] ids;
                for (String id : ids = ((OldFrameworkSupportProviderWrapper)provider).getProvider().getPrecedingFrameworkProviderIds()) {
                    FrameworkSupportInModuleProvider dependency = FrameworkSupportUtil.findProvider(id, this.myFrameworkSupportProviders);
                    if (dependency == null) continue;
                    dependencies.add(dependency);
                }
            }
            return dependencies.iterator();
        }
    }
}

