/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserDialog;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeClassChooserFactoryImpl
extends TreeClassChooserFactory {
    private final Project myProject;

    public TreeClassChooserFactoryImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public TreeClassChooser createWithInnerClassesScopeChooser(String title, GlobalSearchScope scope, ClassFilter classFilter, PsiClass initialClass) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = TreeJavaClassChooserDialog.withInnerClasses(title, this.myProject, scope, classFilter, initialClass);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createWithInnerClassesScopeChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createNoInnerClassesScopeChooser(String title, GlobalSearchScope scope, ClassFilter classFilter, PsiClass initialClass) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, initialClass);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createNoInnerClassesScopeChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title, PsiClass initialClass) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject, initialClass);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createProjectScopeChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createProjectScopeChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createAllProjectScopeChooser(String title) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject, GlobalSearchScope.allScope((Project)this.myProject), null, null);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createAllProjectScopeChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, boolean acceptsSelf, boolean acceptInner, Condition<? super PsiClass> additionalCondition) {
        TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl classFilter = new TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl(base, acceptsSelf, acceptInner, additionalCondition);
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, base, null, false);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createInheritanceClassChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass) {
        TreeClassChooser treeClassChooser = this.createInheritanceClassChooser(title, scope, base, initialClass, null);
        if (treeClassChooser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createInheritanceClassChooser"));
        }
        return treeClassChooser;
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass, ClassFilter classFilter) {
        TreeJavaClassChooserDialog treeJavaClassChooserDialog = new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, base, initialClass, false);
        if (treeJavaClassChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createInheritanceClassChooser"));
        }
        return treeJavaClassChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, PsiFile initialFile, FileType fileType, TreeFileChooser.PsiFileFilter filter) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, false, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, false);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        TreeFileChooserDialog treeFileChooserDialog = new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, showLibraryContents);
        if (treeFileChooserDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeClassChooserFactoryImpl", "createFileChooser"));
        }
        return treeFileChooserDialog;
    }
}

