/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementsChooser<T>
extends JPanel
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    private JBTable myTable = null;
    private MyTableModel myTableModel = null;
    private boolean myColorUnmarkedElements = true;
    private final List<ElementsMarkListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<T, ElementProperties> myElementToPropertiesMap = new HashMap<T, ElementProperties>();
    private final Map<T, Boolean> myDisabledMap = new HashMap<T, Boolean>();
    private int[] mySavedSelection = null;

    public ElementsChooser(boolean elementsCanBeMarked) {
        this(null, false, elementsCanBeMarked);
    }

    public ElementsChooser(List<T> elements, boolean marked) {
        this(elements, marked, true);
    }

    private ElementsChooser(@Nullable List<T> elements, boolean marked, boolean elementsCanBeMarked) {
        super(new BorderLayout());
        this.myTableModel = new MyTableModel(elementsCanBeMarked);
        this.myTable = new Table((TableModel)this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setTableHeader(null);
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        pane.setPreferredSize(new Dimension(100, 155));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        if (elementsCanBeMarked) {
            TableColumn checkMarkColumn = columnModel.getColumn(this.myTableModel.CHECK_MARK_COLUM_INDEX);
            TableUtil.setupCheckboxColumn((TableColumn)checkMarkColumn);
            checkMarkColumn.setCellRenderer(new CheckMarkColumnCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        }
        columnModel.getColumn(this.myTableModel.ELEMENT_COLUMN_INDEX).setCellRenderer(new MyElementColumnCellRenderer());
        this.add((Component)pane, "Center");
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ElementsChooser.this.myTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    currentlyMarked = ElementsChooser.this.myTableModel.isElementMarked(selectedRow);
                    if (!currentlyMarked) break;
                }
                ElementsChooser.this.myTableModel.setMarked(selectedRows, !currentlyMarked);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        SpeedSearchBase<JBTable> speedSearch = new SpeedSearchBase<JBTable>(this.myTable){

            @Override
            public int getSelectedIndex() {
                return ElementsChooser.this.myTable.getSelectedRow();
            }

            @Override
            protected int convertIndexToModel(int viewIndex) {
                return ElementsChooser.this.myTable.convertRowIndexToModel(viewIndex);
            }

            @Override
            public Object[] getAllElements() {
                int count = ElementsChooser.this.myTableModel.getRowCount();
                Object[] elements = new Object[count];
                for (int idx = 0; idx < count; ++idx) {
                    elements[idx] = ElementsChooser.this.myTableModel.getElementAt(idx);
                }
                return elements;
            }

            @Override
            public String getElementText(Object element) {
                return ElementsChooser.this.getItemText(element);
            }

            @Override
            public void selectElement(Object element, String selectedText) {
                int count = ElementsChooser.this.myTableModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ElementsChooser.this.myTableModel.getElementAt(row))) continue;
                    int viewRow = ElementsChooser.this.myTable.convertRowIndexToView(row);
                    ElementsChooser.this.myTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ElementsChooser.this.myTable);
                    break;
                }
            }
        };
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setElements(elements, marked);
        ElementsChooser.installActions((JTable)this.myTable);
    }

    private static void installActions(JTable table) {
        InputMap inputMap = table.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "selectFirstRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "selectLastRowExtendSelection");
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser", "getEmptyText"));
        }
        return statusText;
    }

    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        ExpandableItemsHandler expandableItemsHandler = this.myTable.getExpandableItemsHandler();
        if (expandableItemsHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser", "getExpandableItemsHandler"));
        }
        return expandableItemsHandler;
    }

    public void setExpandableItemsEnabled(boolean enabled) {
        this.myTable.setExpandableItemsEnabled(enabled);
    }

    public void setSingleSelectionMode() {
        this.myTable.setSelectionMode(0);
    }

    public void refresh() {
        this.myTableModel.fireTableDataChanged();
    }

    public void refresh(T element) {
        int row = this.myTableModel.getElementRow(element);
        if (row >= 0) {
            this.myTableModel.fireTableRowsUpdated(row, row);
        }
    }

    public void saveSelection() {
        this.mySavedSelection = this.myTable.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.mySavedSelection != null) {
            TableUtil.selectRows((JTable)this.myTable, (int[])this.mySavedSelection);
            this.mySavedSelection = null;
        }
    }

    public boolean isColorUnmarkedElements() {
        return this.myColorUnmarkedElements;
    }

    public void setColorUnmarkedElements(boolean colorUnmarkedElements) {
        this.myColorUnmarkedElements = colorUnmarkedElements;
    }

    public void addElementsMarkListener(ElementsMarkListener<T> listener) {
        this.myListeners.add(listener);
    }

    public void removeElementsMarkListener(ElementsMarkListener<T> listener) {
        this.myListeners.remove(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.myTable.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.myTable.getSelectionModel().removeListSelectionListener(listener);
    }

    public void addElement(T element, boolean isMarked) {
        this.addElement(element, isMarked, element instanceof ElementProperties ? (ElementProperties)element : null);
    }

    public boolean isElementMarked(T element) {
        int elementRow = this.myTableModel.getElementRow(element);
        return this.myTableModel.isElementMarked(elementRow);
    }

    public void setElementMarked(T element, boolean marked) {
        int elementRow = this.myTableModel.getElementRow(element);
        this.myTableModel.setMarked(elementRow, marked);
    }

    public void removeElement(T element) {
        int elementRow = this.myTableModel.getElementRow(element);
        if (elementRow < 0) {
            return;
        }
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(elementRow);
        this.myTableModel.removeElement(element);
        this.myElementToPropertiesMap.remove(element);
        if (wasSelected) {
            int rowCount = this.myTableModel.getRowCount();
            if (rowCount > 0) {
                this.selectRow(elementRow % rowCount);
            } else {
                this.myTable.getSelectionModel().clearSelection();
            }
        }
        this.myTable.requestFocus();
    }

    public void removeAllElements() {
        this.myTableModel.removeAllElements();
        this.myTable.getSelectionModel().clearSelection();
    }

    private void selectRow(int row) {
        this.myTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
    }

    public void moveElement(T element, int newRow) {
        int elementRow = this.myTableModel.getElementRow(element);
        if (elementRow < 0 || elementRow == newRow || newRow < 0 || newRow >= this.myTableModel.getRowCount()) {
            return;
        }
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(elementRow);
        this.myTableModel.changeElementRow(element, newRow);
        if (wasSelected) {
            this.selectRow(newRow);
        }
    }

    public void addElement(T element, boolean isMarked, ElementProperties elementProperties) {
        this.myTableModel.addElement(element, isMarked);
        this.myElementToPropertiesMap.put(element, elementProperties);
        this.selectRow(this.myTableModel.getRowCount() - 1);
        this.myTable.requestFocus();
    }

    public void setElementProperties(T element, ElementProperties properties) {
        this.myElementToPropertiesMap.put(element, properties);
    }

    public void setElements(List<T> elements, boolean marked) {
        this.myTableModel.clear();
        this.myTableModel.addElements(elements, marked);
    }

    @Nullable
    public T getSelectedElement() {
        int selectedRow = this.getSelectedElementRow();
        return selectedRow < 0 ? null : (T)this.myTableModel.getElementAt(selectedRow);
    }

    public int getSelectedElementRow() {
        return this.myTable.getSelectedRow();
    }

    @NotNull
    public List<T> getSelectedElements() {
        int[] selectedRows;
        ArrayList elements = new ArrayList();
        for (int selectedRow : selectedRows = this.myTable.getSelectedRows()) {
            if (selectedRow < 0) continue;
            elements.add(this.myTableModel.getElementAt(selectedRow));
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser", "getSelectedElements"));
        }
        return arrayList;
    }

    public void selectElements(Collection<? extends T> elements) {
        if (elements.isEmpty()) {
            this.myTable.clearSelection();
            return;
        }
        int[] rows = this.getElementsRows(elements);
        TableUtil.selectRows((JTable)this.myTable, (int[])rows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        this.myTable.requestFocus();
    }

    private int[] getElementsRows(Collection<? extends T> elements) {
        int[] rows = new int[elements.size()];
        int index = 0;
        for (T element : elements) {
            rows[index++] = this.myTable.convertRowIndexToView(this.myTableModel.getElementRow(element));
        }
        return rows;
    }

    public void markElements(Collection<T> elements) {
        this.myTableModel.setMarked(this.getElementsRows(elements), true);
    }

    @NotNull
    public List<T> getMarkedElements() {
        int count = this.myTableModel.getRowCount();
        ArrayList elements = new ArrayList();
        for (int idx = 0; idx < count; ++idx) {
            Object element = this.myTableModel.getElementAt(idx);
            if (!this.myTableModel.isElementMarked(idx)) continue;
            elements.add(element);
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ElementsChooser", "getMarkedElements"));
        }
        return arrayList;
    }

    public void sort(Comparator<T> comparator) {
        this.myTableModel.sort(comparator);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.myTable;
    }

    public void invertSelection() {
        int count = this.getElementCount();
        for (int i = 0; i < count; ++i) {
            T type;
            this.setElementMarked(type, !this.isElementMarked(type = this.getElementAt(i)));
        }
    }

    public void setAllElementsMarked(boolean marked) {
        int[] rows = new int[this.myTableModel.getRowCount()];
        for (int idx = 0; idx < rows.length; ++idx) {
            rows[idx] = idx;
        }
        this.myTableModel.setMarked(rows, marked);
    }

    private void notifyElementMarked(T element, boolean isMarked) {
        for (ElementsMarkListener<T> listener : this.myListeners) {
            listener.elementMarkChanged(element, isMarked);
        }
    }

    public void clear() {
        this.myTableModel.clear();
        this.myElementToPropertiesMap.clear();
    }

    public int getElementCount() {
        return this.myTableModel.getRowCount();
    }

    public T getElementAt(int row) {
        return this.myTableModel.getElementAt(row);
    }

    public void disableElement(T element) {
        this.myDisabledMap.put(element, Boolean.TRUE);
    }

    protected String getItemText(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/ElementsChooser", "getItemText"));
        }
        return value.toString();
    }

    @Nullable
    protected Icon getItemIcon(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/ElementsChooser", "getItemIcon"));
        }
        return null;
    }

    private class CheckMarkColumnCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;

        public CheckMarkColumnCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setEnabled(ElementsChooser.this.isEnabled());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            return component;
        }
    }

    private class MyElementColumnCellRenderer
    extends DefaultTableCellRenderer {
        private MyElementColumnCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            Color color = UIUtil.getTableFocusCellBackground();
            Object t = value;
            try {
                UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(t != null ? ElementsChooser.this.getItemText(t) : "");
                if (component instanceof JLabel) {
                    ((JLabel)component).setBorder(noFocusBorder);
                }
            }
            finally {
                UIManager.put("Table.focusCellBackground", color);
            }
            MyTableModel model = (MyTableModel)table.getModel();
            component.setEnabled(ElementsChooser.this.isEnabled() && (!ElementsChooser.this.myColorUnmarkedElements || model.isElementMarked(row)));
            ElementProperties properties = (ElementProperties)ElementsChooser.this.myElementToPropertiesMap.get(t);
            if (component instanceof JLabel) {
                Icon icon = properties != null ? properties.getIcon() : (t != null ? ElementsChooser.this.getItemIcon(t) : null);
                JLabel label = (JLabel)component;
                label.setIcon(icon);
                label.setDisabledIcon(icon);
            }
            component.setForeground(properties != null && properties.getColor() != null ? properties.getColor() : (isSelected ? table.getSelectionForeground() : table.getForeground()));
            return component;
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final List<T> myElements = new ArrayList();
        private final Map<T, Boolean> myMarkedMap = new HashMap();
        public final int CHECK_MARK_COLUM_INDEX;
        public final int ELEMENT_COLUMN_INDEX;
        private final boolean myElementsCanBeMarked;

        public MyTableModel(boolean elementsCanBeMarked) {
            this.myElementsCanBeMarked = elementsCanBeMarked;
            if (elementsCanBeMarked) {
                this.CHECK_MARK_COLUM_INDEX = 0;
                this.ELEMENT_COLUMN_INDEX = 1;
            } else {
                this.CHECK_MARK_COLUM_INDEX = -1;
                this.ELEMENT_COLUMN_INDEX = 0;
            }
        }

        public void sort(Comparator<T> comparator) {
            Collections.sort(this.myElements, comparator);
            this.fireTableDataChanged();
        }

        public T getElementAt(int index) {
            return this.myElements.get(index);
        }

        public boolean isElementMarked(int index) {
            Object element = this.myElements.get(index);
            Boolean isMarked = this.myMarkedMap.get(element);
            return isMarked;
        }

        private void addElement(T element, boolean isMarked) {
            this.myElements.add(element);
            this.myMarkedMap.put(element, isMarked ? Boolean.TRUE : Boolean.FALSE);
            int row = this.myElements.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        private void addElements(@Nullable List<T> elements, boolean isMarked) {
            if (elements == null || elements.isEmpty()) {
                return;
            }
            for (Object element : elements) {
                this.myElements.add(element);
                this.myMarkedMap.put(element, isMarked ? Boolean.TRUE : Boolean.FALSE);
            }
            this.fireTableRowsInserted(this.myElements.size() - elements.size(), this.myElements.size() - 1);
        }

        public void removeElement(T element) {
            boolean reallyRemoved = this.myElements.remove(element);
            if (reallyRemoved) {
                this.myMarkedMap.remove(element);
                this.fireTableDataChanged();
            }
        }

        public void changeElementRow(T element, int row) {
            boolean reallyRemoved = this.myElements.remove(element);
            if (reallyRemoved) {
                this.myElements.add(row, element);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(T element) {
            return this.myElements.indexOf(element);
        }

        public void removeAllElements() {
            this.myElements.clear();
            this.fireTableDataChanged();
        }

        public void removeRows(int[] rows) {
            ArrayList toRemove = new ArrayList();
            for (int row : rows) {
                Object element = this.myElements.get(row);
                toRemove.add(element);
                this.myMarkedMap.remove(element);
            }
            this.myElements.removeAll(toRemove);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myElements.size();
        }

        @Override
        public int getColumnCount() {
            return this.myElementsCanBeMarked ? 2 : 1;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object element = this.myElements.get(rowIndex);
            if (columnIndex == this.ELEMENT_COLUMN_INDEX) {
                return element;
            }
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return this.myMarkedMap.get(element);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                this.setMarked(rowIndex, (boolean)((Boolean)aValue));
            }
        }

        private void setMarked(int rowIndex, boolean marked) {
            Object element = this.myElements.get(rowIndex);
            Boolean newValue = marked ? Boolean.TRUE : Boolean.FALSE;
            Boolean prevValue = this.myMarkedMap.put(element, newValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
            if (!newValue.equals(prevValue)) {
                ElementsChooser.this.notifyElementMarked(element, marked);
            }
        }

        private void setMarked(int[] rows, boolean marked) {
            if (rows == null || rows.length == 0) {
                return;
            }
            int firstRow = Integer.MAX_VALUE;
            int lastRow = Integer.MIN_VALUE;
            Boolean newValue = marked ? Boolean.TRUE : Boolean.FALSE;
            for (int row : rows) {
                Object element = this.myElements.get(row);
                Boolean prevValue = this.myMarkedMap.put(element, newValue);
                if (!newValue.equals(prevValue)) {
                    ElementsChooser.this.notifyElementMarked(element, newValue);
                }
                firstRow = Math.min(firstRow, row);
                lastRow = Math.max(lastRow, row);
            }
            this.fireTableRowsUpdated(firstRow, lastRow);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!ElementsChooser.this.isEnabled() || columnIndex != this.CHECK_MARK_COLUM_INDEX) {
                return false;
            }
            Object o = this.getValueAt(rowIndex, this.ELEMENT_COLUMN_INDEX);
            return ElementsChooser.this.myDisabledMap.get(o) == null;
        }

        public void clear() {
            this.myElements.clear();
            this.myMarkedMap.clear();
            this.fireTableDataChanged();
        }
    }

    public static interface ElementProperties {
        @Nullable
        public Icon getIcon();

        @Nullable
        public Color getColor();
    }

    public static interface ElementsMarkListener<T> {
        public void elementMarkChanged(T var1, boolean var2);
    }
}

