/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class FilterDialog
extends DialogWrapper {
    private final TodoFilter myFilter;
    private final int myFilterIndex;
    private final List<TodoPattern> myPatterns;
    private final List<TodoFilter> myFilters;
    private final JTextField myNameField;
    private final Table myTable;

    public FilterDialog(Component parent, TodoFilter filter, int filterIndex, List<TodoFilter> filters, List<TodoPattern> patterns) {
        super(parent, true);
        this.myFilter = filter;
        this.myFilterIndex = filterIndex;
        this.myPatterns = patterns;
        this.myFilters = filters;
        this.myNameField = new JTextField(filter.getName());
        MyModel model = new MyModel();
        this.myTable = new Table((TableModel)model);
        this.init();
    }

    protected void doOKAction() {
        this.myFilter.setName(this.myNameField.getText().trim());
        if (this.myFilter.getName().length() == 0) {
            Messages.showMessageDialog((Component)this.myTable, (String)IdeBundle.message((String)"error.filter.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        for (int i = 0; i < this.myFilters.size(); ++i) {
            TodoFilter filter = this.myFilters.get(i);
            if (this.myFilterIndex == i || !this.myFilter.getName().equals(filter.getName())) continue;
            Messages.showMessageDialog((Component)this.myTable, (String)IdeBundle.message((String)"error.filter.with.the.same.name.already.exists", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (this.myFilter.isEmpty()) {
            Messages.showMessageDialog((Component)this.myTable, (String)IdeBundle.message((String)"error.filter.should.contain.at.least.one.pattern", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/configurable/FilterDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.idesettings.todo.editfilter");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(IdeBundle.message((String)"label.todo.filter.name", (Object[])new Object[0]));
        panel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        panel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel patternsPanel = new JPanel(new GridBagLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.todo.filter.patterns", (Object[])new Object[0]), (boolean)false);
        patternsPanel.setBorder((Border)border);
        this.myTable.getSelectionModel().setSelectionMode(0);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        scrollPane.setPreferredSize(new Dimension(550, this.myTable.getRowHeight() * 10));
        patternsPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        panel.add((Component)patternsPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private final class MyModel
    extends AbstractTableModel {
        private final String[] ourColumnNames = new String[]{" ", IdeBundle.message((String)"column.todo.filter.pattern", (Object[])new Object[0])};
        private final Class[] ourColumnClasses = new Class[]{Boolean.class, String.class};

        private MyModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.ourColumnNames[column];
        }

        public Class getColumnClass(int column) {
            return this.ourColumnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FilterDialog.this.myPatterns.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            TodoPattern pattern = (TodoPattern)FilterDialog.this.myPatterns.get(row);
            switch (column) {
                case 0: {
                    return FilterDialog.this.myFilter.contains(pattern) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return pattern.getPatternString();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    TodoPattern pattern = (TodoPattern)FilterDialog.this.myPatterns.get(row);
                    if (((Boolean)value).booleanValue()) {
                        FilterDialog.this.myFilter.addTodoPattern(pattern);
                        break;
                    }
                    FilterDialog.this.myFilter.removeTodoPattern(pattern);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }
    }
}

