/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.ScopeBasedTodosPanel;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import javax.swing.JComboBox;

public class ScopeBasedTodosTreeStructure
extends TodoTreeStructure {
    private final JComboBox myScopes;

    public ScopeBasedTodosTreeStructure(Project project, JComboBox scopes) {
        super(project);
        this.myScopes = scopes;
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        PackageSet value;
        if (!psiFile.isValid()) {
            return false;
        }
        boolean isAffected = false;
        ScopeBasedTodosPanel.ScopeWrapper scope = (ScopeBasedTodosPanel.ScopeWrapper)this.myScopes.getSelectedItem();
        if (scope != null && (value = scope.getNamedScope().getValue()) != null) {
            isAffected = value.contains(psiFile, NamedScopesHolder.getHolder((Project)this.myProject, (String)scope.getName(), (NamedScopesHolder)DependencyValidationManager.getInstance((Project)this.myProject)));
        }
        return isAffected && (this.myTodoFilter != null && this.myTodoFilter.accept(this.mySearchHelper, psiFile) || this.myTodoFilter == null && this.mySearchHelper.getTodoItemsCount(psiFile) > 0);
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }
}

