/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeModelWrapper
implements StructureViewModel,
ProvidingTreeModel {
    private final StructureViewModel myModel;
    private final TreeActionsOwner myStructureView;

    public TreeModelWrapper(@NotNull StructureViewModel model, @NotNull TreeActionsOwner structureView) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "<init>"));
        }
        if (structureView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "<init>"));
        }
        this.myModel = model;
        this.myStructureView = structureView;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewTreeElement structureViewTreeElement = this.myModel.getRoot();
        if (structureViewTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getRoot"));
        }
        return structureViewTreeElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getGroupers());
        Grouper[] grouperArray = filtered.toArray(new Grouper[filtered.size()]);
        if (grouperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getGroupers"));
        }
        return grouperArray;
    }

    @NotNull
    private <T extends TreeAction> List<T> filterActive(@NotNull T[] actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "filterActive"));
        }
        ArrayList<T> filtered = new ArrayList<T>();
        for (T action : actions) {
            if (!this.isFiltered((TreeAction)action)) continue;
            filtered.add(action);
        }
        ArrayList<T> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "filterActive"));
        }
        return arrayList;
    }

    @NotNull
    private List<NodeProvider> filterProviders(@NotNull Collection<NodeProvider> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "filterProviders"));
        }
        ArrayList<NodeProvider> filtered = new ArrayList<NodeProvider>();
        for (NodeProvider action : actions) {
            if (!this.isFiltered((TreeAction)action)) continue;
            filtered.add(action);
        }
        ArrayList<NodeProvider> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "filterProviders"));
        }
        return arrayList;
    }

    private boolean isFiltered(@NotNull TreeAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "isFiltered"));
        }
        return action instanceof Sorter && !((Sorter)action).isVisible() || this.myStructureView.isActionActive(action.getName());
    }

    @NotNull
    public Sorter[] getSorters() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getSorters());
        Sorter[] sorterArray = filtered.toArray(new Sorter[filtered.size()]);
        if (sorterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getSorters"));
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getFilters());
        Filter[] filterArray = filtered.toArray(new Filter[filtered.size()]);
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getFilters"));
        }
        return filterArray;
    }

    public Object getCurrentEditorElement() {
        return this.myModel.getCurrentEditorElement();
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        if (this.myModel instanceof ProvidingTreeModel) {
            List<NodeProvider> list = this.filterProviders(((ProvidingTreeModel)this.myModel).getNodeProviders());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getNodeProviders"));
            }
            return list;
        }
        List<NodeProvider> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "getNodeProviders"));
        }
        return list;
    }

    public static boolean isActive(@NotNull TreeAction action, @NotNull TreeActionsOwner actionsOwner) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "isActive"));
        }
        if (actionsOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "isActive"));
        }
        if (TreeModelWrapper.shouldRevert(action)) {
            return !actionsOwner.isActionActive(action.getName());
        }
        return action instanceof Sorter && !((Sorter)action).isVisible() || actionsOwner.isActionActive(action.getName());
    }

    public static boolean shouldRevert(@NotNull TreeAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "shouldRevert"));
        }
        return action instanceof Filter && ((Filter)action).isReverted();
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "addEditorPositionListener"));
        }
        this.myModel.addEditorPositionListener(listener);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "removeEditorPositionListener"));
        }
        this.myModel.removeEditorPositionListener(listener);
    }

    public void dispose() {
        this.myModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "addModelListener"));
        }
        this.myModel.addModelListener(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "removeModelListener"));
        }
        this.myModel.removeModelListener(modelListener);
    }

    public StructureViewModel getModel() {
        return this.myModel;
    }

    public boolean isEnabled(@NotNull NodeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/structureView/newStructureView/TreeModelWrapper", "isEnabled"));
        }
        return this.myStructureView.isActionActive(provider.getName());
    }
}

