/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchpadFileSystem;
import com.intellij.ide.scratch.ScratchpadManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ScratchpadManagerImpl
extends ScratchpadManager
implements Disposable {
    private final Project myProject;
    private final Map<String, Integer> myExtensionsCounterMap;
    private Language myLatestLanguage;

    public ScratchpadManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scratch/ScratchpadManagerImpl", "<init>"));
        }
        this.myExtensionsCounterMap = ContainerUtil.newHashMap();
        this.myProject = project;
    }

    @Override
    @NotNull
    public VirtualFile createScratchFile(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scratch/ScratchpadManagerImpl", "createScratchFile"));
        }
        this.myLatestLanguage = language;
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                String name = ScratchpadManagerImpl.this.generateFileName(language);
                return ScratchpadFileSystem.getScratchFileSystem().addFile(name, language, ScratchpadManagerImpl.calculatePrefix(ScratchpadManagerImpl.this.myProject));
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "createScratchFile"));
        }
        return virtualFile;
    }

    @NotNull
    private static String calculatePrefix(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scratch/ScratchpadManagerImpl", "calculatePrefix"));
        }
        String string = project.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "calculatePrefix"));
        }
        return string;
    }

    @Override
    public Language getLatestLanguage() {
        return this.myLatestLanguage;
    }

    @NotNull
    private String generateFileName(@NotNull Language language) {
        int n;
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scratch/ScratchpadManagerImpl", "generateFileName"));
        }
        LanguageFileType associatedFileType = language.getAssociatedFileType();
        String ext = associatedFileType != null ? associatedFileType.getDefaultExtension() : "unknown";
        Integer prev = this.myExtensionsCounterMap.get(ext);
        if (prev == null) {
            n = 1;
        } else {
            prev = prev + 1;
            n = prev;
        }
        int updated = n;
        this.myExtensionsCounterMap.put(ext, updated);
        String index = updated == 1 ? "" : updated + ".";
        String string = "scratch." + index + ext;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "generateFileName"));
        }
        return string;
    }

    public void dispose() {
        ScratchpadFileSystem.getScratchFileSystem().removeByPrefix(ScratchpadManagerImpl.calculatePrefix(this.myProject));
    }
}

