/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchpadManager;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class CreateScratchFileAction
extends AnAction
implements DumbAware {
    public static final int MAX_VISIBLE_SIZE = 20;

    public CreateScratchFileAction() {
        super("Create Scratch File...", "New Scratch File", null);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && Registry.is((String)"ide.scratch.enabled"));
    }

    public void actionPerformed(AnActionEvent e) {
        int defaultOption;
        String previousName;
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<Language> languages = CreateScratchFileAction.getLanguages();
        if (languages.isEmpty()) {
            return;
        }
        BaseListPopupStep<Language> step = new BaseListPopupStep<Language>("Specify the language", languages){

            @NotNull
            public String getTextFor(Language value) {
                String string = value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/CreateScratchFileAction$1", "getTextFor"));
                }
                return string;
            }

            public String getIndexedString(Language value) {
                return value.getDisplayName();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Language selectedValue, boolean finalChoice) {
                CreateScratchFileAction.doAction(project, selectedValue);
                return null;
            }

            public Icon getIconFor(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }
        };
        Language previous = ScratchpadManager.getInstance(project).getLatestLanguage();
        String string = previousName = previous != null ? previous.getDisplayName() : "Plain text";
        if (previousName != null && (defaultOption = ContainerUtil.indexOf(languages, (Condition)new Condition<Language>(){

            public boolean value(Language module) {
                return module.getDisplayName().equals(previousName);
            }
        })) >= 0) {
            step.setDefaultOptionIndex(defaultOption);
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        int nameLen = 0;
        for (Language language : languages) {
            nameLen = Math.max(nameLen, language.getDisplayName().length());
        }
        if (languages.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getMinimumSize();
            size.height *= 20;
            popup.setSize(size);
        }
        popup.showCenteredInCurrentWindow(project);
    }

    public static void doAction(@NotNull Project project, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scratch/CreateScratchFileAction", "doAction"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/scratch/CreateScratchFileAction", "doAction"));
        }
        VirtualFile file = ScratchpadManager.getInstance(project).createScratchFile(language);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    @NotNull
    private static List<Language> getLanguages() {
        TreeSet result = ContainerUtil.newTreeSet((Comparator)new Comparator<Language>(){

            @Override
            public int compare(Language l1, Language l2) {
                return l1.getDisplayName().compareTo(l2.getDisplayName());
            }
        });
        for (Language lang : Language.getRegisteredLanguages()) {
            if (!StringUtil.isEmpty((String)lang.getDisplayName())) {
                result.add(lang);
            }
            for (Language dialect : lang.getDialects()) {
                result.add(dialect);
            }
        }
        List list = ContainerUtil.filter((Collection)result, (Condition)new Condition<Language>(){

            public boolean value(Language lang) {
                if (lang instanceof DependentLanguage || lang instanceof InjectableLanguage) {
                    return false;
                }
                LanguageFileType type = lang.getAssociatedFileType();
                if (type == null) {
                    return false;
                }
                String name = lang.getDisplayName();
                if (StringUtil.startsWith((CharSequence)name, (CharSequence)"<") || StringUtil.startsWith((CharSequence)name, (CharSequence)"[") || StringUtil.isEmpty((String)name)) {
                    return false;
                }
                return !StringUtil.isEmpty((String)type.getDefaultExtension());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/CreateScratchFileAction", "getLanguages"));
        }
        return list;
    }
}

