/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.scopeView.ScopePaneSelectInTarget;
import com.intellij.ide.scopeView.ScopeTreeViewPanel;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScopeViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Scope";
    private final ProjectView myProjectView;
    private ScopeTreeViewPanel myViewPanel;
    private final DependencyValidationManager myDependencyValidationManager;
    private final NamedScopeManager myNamedScopeManager;
    private final NamedScopesHolder.ScopeListener myScopeListener;

    public ScopeViewPane(Project project, ProjectView projectView, DependencyValidationManager dependencyValidationManager, NamedScopeManager namedScopeManager) {
        super(project);
        this.myProjectView = projectView;
        this.myDependencyValidationManager = dependencyValidationManager;
        this.myNamedScopeManager = namedScopeManager;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){
            Alarm refreshProjectViewAlarm = new Alarm();

            public void scopesChanged() {
                this.refreshProjectViewAlarm.cancelAllRequests();
                this.refreshProjectViewAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (ScopeViewPane.this.myProject.isDisposed()) {
                            return;
                        }
                        String subId = ScopeViewPane.this.getSubId();
                        String id = ScopeViewPane.this.myProjectView.getCurrentViewId();
                        ScopeViewPane.this.myProjectView.removeProjectPane(ScopeViewPane.this);
                        ScopeViewPane.this.myProjectView.addProjectPane(ScopeViewPane.this);
                        if (id != null) {
                            if (Comparing.strEqual((String)id, (String)ScopeViewPane.this.getId())) {
                                ScopeViewPane.this.myProjectView.changeView(id, subId);
                            } else {
                                ScopeViewPane.this.myProjectView.changeView(id);
                            }
                        }
                    }
                }, 10);
            }
        };
        this.myDependencyValidationManager.addScopeListener(this.myScopeListener);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"scope.view.title", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Ide.LocalScope;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getId"));
        }
        return ID;
    }

    @Override
    public JComponent createComponent() {
        if (this.myViewPanel == null) {
            this.myViewPanel = new ScopeTreeViewPanel(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myViewPanel);
            this.myViewPanel.initListeners();
            this.myTree = this.myViewPanel.getTree();
            CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ScopeViewPopupMenu", "ScopeViewPopup");
            this.enableDnD();
        }
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        return this.myViewPanel.getPanel();
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        this.myDependencyValidationManager.removeScopeListener(this.myScopeListener);
        this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        NamedScope[] scopes = this.getShownScopes();
        String[] ids = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            NamedScope scope = scopes[i];
            ids[i] = scope.getName();
        }
        if (ids == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getSubIds"));
        }
        return ids;
    }

    private NamedScope[] getShownScopes() {
        Object[] scopes = this.myDependencyValidationManager.getScopes();
        scopes = (NamedScope[])ArrayUtil.mergeArrays((Object[])scopes, (Object[])this.myNamedScopeManager.getScopes());
        scopes = NonProjectFilesScope.removeFromList((NamedScope[])scopes);
        scopes = (NamedScope[])ArrayUtil.remove((Object[])scopes, (Object)CustomScopesProviderEx.getAllScope());
        return scopes;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scopeView/ScopeViewPane", "getPresentableSubIdName"));
        }
        String string = subId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getPresentableSubIdName"));
        }
        return string;
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.add(ActionManager.getInstance().getAction("ScopeView.EditScopes"));
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject){

            @Override
            protected String getId() {
                return ScopeViewPane.this.getId();
            }
        }).setAsSecondary(true);
    }

    @Override
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        this.saveExpandedPaths();
        this.myViewPanel.selectScope(NamedScopesHolder.getScope((Project)this.myProject, (String)this.getSubId()));
        this.restoreExpandedPaths();
        return new ActionCallback.Done();
    }

    @Override
    public void select(Object element, VirtualFile file, boolean requestFocus) {
        PsiDirectory psiFile;
        if (file == null) {
            return;
        }
        Object object = psiFile = file.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(file) : PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return;
        }
        if (!(element instanceof PsiElement)) {
            return;
        }
        NamedScope[] allScopes = this.getShownScopes();
        for (int i = 0; i < allScopes.length; ++i) {
            NamedScope scope = allScopes[i];
            String name = scope.getName();
            if (!name.equals(this.getSubId())) continue;
            allScopes[i] = allScopes[0];
            allScopes[0] = scope;
            break;
        }
        for (NamedScope scope : allScopes) {
            String name = scope.getName();
            PackageSet packageSet = scope.getValue();
            if (packageSet != null && (this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myNamedScopeManager, requestFocus) || this.changeView(packageSet, (PsiElement)element, (PsiFileSystemItem)psiFile, name, (NamedScopesHolder)this.myDependencyValidationManager, requestFocus))) break;
        }
    }

    private boolean changeView(PackageSet packageSet, PsiElement element, PsiFileSystemItem psiFileSystemItem, String name, NamedScopesHolder holder, boolean requestFocus) {
        if (packageSet instanceof PackageSetBase && ((PackageSetBase)packageSet).contains(psiFileSystemItem.getVirtualFile(), this.myProject, holder) || psiFileSystemItem instanceof PsiFile && packageSet.contains((PsiFile)psiFileSystemItem, holder)) {
            if (!name.equals(this.getSubId())) {
                this.myProjectView.changeView(this.getId(), name);
            }
            this.myViewPanel.selectNode(element, psiFileSystemItem, requestFocus);
            return true;
        }
        return false;
    }

    @Override
    public int getWeight() {
        return 3;
    }

    @Override
    public void installComparator() {
        this.myViewPanel.setSortByType();
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ScopePaneSelectInTarget(this.myProject);
    }

    @Override
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        if (node instanceof PackageDependenciesNode) {
            return ((PackageDependenciesNode)node).getPsiElement();
        }
        return super.exhumeElementFromNode(node);
    }

    @Override
    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        return this.myViewPanel != null ? this.myViewPanel.getData(dataId) : null;
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/scopeView/ScopeViewPane", "getReady"));
        }
        ActionCallback callback = this.myViewPanel.getActionCallback();
        Object object = this.myViewPanel == null ? new ActionCallback.Rejected() : (callback != null ? callback : new ActionCallback.Done());
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeViewPane", "getReady"));
        }
        return object;
    }
}

