/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NamedLibraryElementNode
extends ProjectViewNode<NamedLibraryElement>
implements NavigatableWithText {
    public NamedLibraryElementNode(Project project, NamedLibraryElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        LibraryGroupNode.addLibraryChildren(((NamedLibraryElement)this.getValue()).getOrderEntry(), children, this.getProject(), this);
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode", "getChildren"));
        }
        return arrayList;
    }

    public String getTestPresentation() {
        return "Library: " + ((NamedLibraryElement)this.getValue()).getName();
    }

    private static Icon getJdkIcon(JdkOrderEntry entry) {
        Sdk sdk = entry.getJdk();
        if (sdk == null) {
            return AllIcons.General.Jdk;
        }
        SdkType sdkType = (SdkType)sdk.getSdkType();
        return sdkType.getIcon();
    }

    public String getName() {
        return ((NamedLibraryElement)this.getValue()).getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/NamedLibraryElementNode", "contains"));
        }
        return NamedLibraryElementNode.orderEntryContainsFile(((NamedLibraryElement)this.getValue()).getOrderEntry(), file);
    }

    private static boolean orderEntryContainsFile(LibraryOrSdkOrderEntry orderEntry, VirtualFile file) {
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            if (!NamedLibraryElementNode.containsFileInOrderType(orderEntry, rootType, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFileInOrderType(LibraryOrSdkOrderEntry orderEntry, OrderRootType orderType, VirtualFile file) {
        VirtualFile[] files;
        if (!orderEntry.isValid()) {
            return false;
        }
        for (VirtualFile virtualFile : files = orderEntry.getRootFiles(orderType)) {
            boolean ancestor = VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false);
            if (!ancestor) continue;
            return true;
        }
        return false;
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText(((NamedLibraryElement)this.getValue()).getName());
        LibraryOrSdkOrderEntry orderEntry = ((NamedLibraryElement)this.getValue()).getOrderEntry();
        Icon closedIcon = orderEntry instanceof JdkOrderEntry ? NamedLibraryElementNode.getJdkIcon((JdkOrderEntry)orderEntry) : AllIcons.Nodes.PpLibFolder;
        presentation.setIcon(closedIcon);
        if (orderEntry instanceof JdkOrderEntry) {
            String path;
            JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
            Sdk projectJdk = jdkOrderEntry.getJdk();
            if (projectJdk != null && (path = projectJdk.getHomePath()) != null) {
                presentation.setLocationString(FileUtil.toSystemDependentName((String)path));
            }
            presentation.setTooltip(null);
        } else {
            presentation.setTooltip(StringUtil.capitalize((String)IdeBundle.message((String)"node.projectview.library", (Object[])new Object[]{((LibraryOrderEntry)orderEntry).getLibraryLevel()})));
        }
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings((OrderEntry)((NamedLibraryElement)this.getValue()).getOrderEntry());
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenLibraryOrSdkSettings((OrderEntry)((NamedLibraryElement)this.getValue()).getOrderEntry());
    }

    public String getNavigateActionText(boolean focusEditor) {
        return "Open Library Settings";
    }
}

