/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project, Value value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected abstract void updateImpl(PresentationData var1);

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
            }
            return arrayList;
        }
        boolean valid = psiElement.isValid();
        if (!LOG.assertTrue(valid)) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
            }
            return list;
        }
        Collection<AbstractTreeNode> children = this.getChildrenImpl();
        Collection<Object> collection = children != null ? children : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
        }
        return collection;
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        VirtualFile file = this.getVirtualFileForValue();
        if (file == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.getProject()).getStatus(file);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilBase.getVirtualFile((PsiElement)psiElement);
    }

    public void update(final PresentationData data) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!AbstractPsiBasedNode.this.validate()) {
                    return;
                }
                PsiElement value = AbstractPsiBasedNode.this.extractPsiFromValue();
                LOG.assertTrue(value.isValid());
                int flags = AbstractPsiBasedNode.this.getIconableFlags();
                try {
                    Icon icon = value.getIcon(flags);
                    data.setIcon(icon);
                }
                catch (IndexNotReadyException ignored) {
                    // empty catch block
                }
                data.setPresentableText(AbstractPsiBasedNode.this.myName);
                try {
                    if (AbstractPsiBasedNode.this.isDeprecated()) {
                        data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
                    }
                }
                catch (IndexNotReadyException ignored) {
                    // empty catch block
                }
                AbstractPsiBasedNode.this.updateImpl(data);
                for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)AbstractPsiBasedNode.this.myProject)) {
                    decorator.decorate(AbstractPsiBasedNode.this, data);
                }
                Iconable.LastComputedIcon.put((UserDataHolder)value, (Icon)data.getIcon(false), (int)flags);
            }
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "contains"));
        }
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return valueFile != null && file.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(requestFocus);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }
}

