/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "ProjectPane";

    public ProjectViewPane(Project project) {
        super(project);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewPane", "getId"));
        }
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    @Override
    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new ProjectViewTreeUpdater(treeBuilder);
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            @Override
            protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
                return new ProjectViewProjectNode(project, settings);
            }
        };
    }

    @Override
    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return ProjectViewPane.this.getTitle() + " " + super.toString();
            }

            public void setFont(Font font) {
                if (Registry.is((String)"bigger.font.in.project.view")) {
                    font = font.deriveFont((float)font.getSize() + 1.0f);
                }
                super.setFont(font);
            }

            @Override
            public DefaultMutableTreeNode getSelectedNode() {
                return ProjectViewPane.this.getSelectedNode();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewPane", "getComponentName"));
        }
        return ID;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    private final class ProjectViewTreeUpdater
    extends AbstractTreeUpdater {
        private ProjectViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(Object element) {
            if (element instanceof PsiDirectory && !ProjectViewPane.this.myProject.isDisposed()) {
                boolean addedOk;
                PsiDirectory dirToUpdateFrom;
                PsiDirectory dir = (PsiDirectory)element;
                ProjectTreeStructure treeStructure = (ProjectTreeStructure)ProjectViewPane.this.myTreeStructure;
                if (!treeStructure.isFlattenPackages() && treeStructure.isHideEmptyMiddlePackages()) {
                    for (dirToUpdateFrom = dir; dirToUpdateFrom != null && ProjectViewDirectoryHelper.getInstance(ProjectViewPane.this.myProject).isEmptyMiddleDirectory(dirToUpdateFrom, true); dirToUpdateFrom = dirToUpdateFrom.getParentDirectory()) {
                    }
                }
                while (!(addedOk = super.addSubtreeToUpdateByElement(dirToUpdateFrom == null ? ProjectViewPane.this.myTreeStructure.getRootElement() : dirToUpdateFrom)) && dirToUpdateFrom != null) {
                    dirToUpdateFrom = dirToUpdateFrom.getParentDirectory();
                }
                return addedOk;
            }
            return super.addSubtreeToUpdateByElement(element);
        }
    }
}

