/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CollapseAllToolbarAction;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectView", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ProjectViewImpl
extends ProjectView
implements PersistentStateComponent<Element>,
Disposable,
QuickActionProvider,
BusyObject {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.impl.ProjectViewImpl");
    private static final Key<String> ID_KEY = Key.create((String)"pane-id");
    private static final Key<String> SUB_ID_KEY = Key.create((String)"pane-sub-id");
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean isInitialized;
    private boolean myExtensionsLoaded = false;
    private final Project myProject;
    private final Map<String, Boolean> myFlattenPackages = new THashMap();
    private static final boolean ourFlattenPackagesDefaults = false;
    private final Map<String, Boolean> myShowMembers = new THashMap();
    private static final boolean ourShowMembersDefaults = false;
    private final Map<String, Boolean> mySortByType = new THashMap();
    private static final boolean ourSortByTypeDefaults = false;
    private final Map<String, Boolean> myShowModules = new THashMap();
    private static final boolean ourShowModulesDefaults = true;
    private final Map<String, Boolean> myShowLibraryContents = new THashMap();
    private static final boolean ourShowLibraryContentsDefaults = true;
    private final Map<String, Boolean> myHideEmptyPackages = new THashMap();
    private static final boolean ourHideEmptyPackagesDefaults = true;
    private final Map<String, Boolean> myAbbreviatePackageNames = new THashMap();
    private static final boolean ourAbbreviatePackagesDefaults = false;
    private final Map<String, Boolean> myAutoscrollToSource = new THashMap();
    private final Map<String, Boolean> myAutoscrollFromSource = new THashMap();
    private static final boolean ourAutoscrollFromSourceDefaults = false;
    private static final boolean ourShowStructureDefaults = false;
    private String myCurrentViewId;
    private String myCurrentViewSubId;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    private final IdeView myIdeView = new MyIdeView();
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private SimpleToolWindowPanel myPanel;
    private final Map<String, AbstractProjectViewPane> myId2Pane = new LinkedHashMap<String, AbstractProjectViewPane>();
    private final Collection<AbstractProjectViewPane> myUninitializedPanes = new THashSet();
    static final DataKey<ProjectViewImpl> DATA_KEY = DataKey.create((String)"com.intellij.ide.projectView.impl.ProjectViewImpl");
    private DefaultActionGroup myActionGroup;
    private String mySavedPaneId = "ProjectPane";
    private String mySavedPaneSubId;
    @NonNls
    private static final String ELEMENT_NAVIGATOR = "navigator";
    @NonNls
    private static final String ELEMENT_PANES = "panes";
    @NonNls
    private static final String ELEMENT_PANE = "pane";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_VIEW = "currentView";
    @NonNls
    private static final String ATTRIBUTE_CURRENT_SUBVIEW = "currentSubView";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flattenPackages";
    @NonNls
    private static final String ELEMENT_SHOW_MEMBERS = "showMembers";
    @NonNls
    private static final String ELEMENT_SHOW_MODULES = "showModules";
    @NonNls
    private static final String ELEMENT_SHOW_LIBRARY_CONTENTS = "showLibraryContents";
    @NonNls
    private static final String ELEMENT_HIDE_EMPTY_PACKAGES = "hideEmptyPackages";
    @NonNls
    private static final String ELEMENT_ABBREVIATE_PACKAGE_NAMES = "abbreviatePackageNames";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "autoscrollToSource";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_FROM_SOURCE = "autoscrollFromSource";
    @NonNls
    private static final String ELEMENT_SORT_BY_TYPE = "sortByType";
    @NonNls
    private static final String ELEMENT_FOLDERS_ALWAYS_ON_TOP = "foldersAlwaysOnTop";
    private static final String ATTRIBUTE_ID = "id";
    private JPanel myViewContentPanel;
    private static final Comparator<AbstractProjectViewPane> PANE_WEIGHT_COMPARATOR = new Comparator<AbstractProjectViewPane>(){

        @Override
        public int compare(AbstractProjectViewPane o1, AbstractProjectViewPane o2) {
            return o1.getWeight() - o2.getWeight();
        }
    };
    private final FileEditorManager myFileEditorManager;
    private final MyPanel myDataProvider;
    private final SplitterProportionsData splitterProportions = new SplitterProportionsDataImpl();
    private final MessageBusConnection myConnection;
    private final Map<String, Element> myUninitializedPaneState = new HashMap<String, Element>();
    private final Map<String, SelectInTarget> mySelectInTargets = new LinkedHashMap<String, SelectInTarget>();
    private ContentManager myContentManager;
    private boolean myFoldersAlwaysOnTop = true;

    public ProjectViewImpl(Project project, FileEditorManager fileEditorManager, final ToolWindowManagerEx toolWindowManager) {
        this.myProject = project;
        this.constructUi();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myFileEditorManager = fileEditorManager;
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectViewImpl.this.refresh();
            }
        });
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myDataProvider = new MyPanel();
        this.myDataProvider.add((Component)this.myPanel, "Center");
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myPanel){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                PsiElement[] psiElementArray = viewPane == null ? PsiElement.EMPTY_ARRAY : viewPane.getSelectedPSIElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$3", "getSelectedElements"));
                }
                return psiElementArray;
            }
        };
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ProjectViewImpl.this.isAutoscrollToSource(ProjectViewImpl.this.myCurrentViewId);
            }

            protected void setAutoScrollMode(boolean state) {
                ProjectViewImpl.this.setAutoscrollToSource(state, ProjectViewImpl.this.myCurrentViewId);
            }
        };
        toolWindowManager.addToolWindowManagerListener(new ToolWindowManagerAdapter(){
            private boolean toolWindowVisible;

            @Override
            public void stateChanged() {
                ToolWindow window = toolWindowManager.getToolWindow(ToolWindowId.PROJECT_VIEW);
                if (window == null) {
                    return;
                }
                if (window.isVisible() && !this.toolWindowVisible) {
                    AbstractProjectViewPane currentProjectViewPane;
                    String id = ProjectViewImpl.this.getCurrentViewId();
                    if (ProjectViewImpl.this.isAutoscrollToSource(id) && (currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane()) != null) {
                        ProjectViewImpl.this.myAutoScrollToSourceHandler.onMouseClicked((Component)currentProjectViewPane.getTree());
                    }
                    if (ProjectViewImpl.this.isAutoscrollFromSource(id)) {
                        ProjectViewImpl.this.myAutoScrollFromSourceHandler.setAutoScrollEnabled(true);
                    }
                }
                this.toolWindowVisible = window.isVisible();
            }
        });
    }

    private void constructUi() {
        this.myViewContentPanel = new JPanel();
        this.myPanel = new SimpleToolWindowPanel(true).setProvideQuickActions(false);
        this.myPanel.setContent((JComponent)this.myViewContentPanel);
    }

    public String getName() {
        return "Project";
    }

    public List<AnAction> getActions(boolean originalProvider) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        DefaultActionGroup views = new DefaultActionGroup("Change View", true);
        boolean lastWasHeader = false;
        boolean lastHeaderHadKids = false;
        for (int i = 0; i < this.myContentManager.getContentCount(); ++i) {
            Content each = this.myContentManager.getContent(i);
            if (each == null) continue;
            if (each.getUserData(SUB_ID_KEY) == null) {
                Content next;
                if (lastHeaderHadKids) {
                    views.add((AnAction)new Separator());
                } else if (i + 1 < this.myContentManager.getContentCount() && (next = this.myContentManager.getContent(i + 1)) != null && next.getUserData(SUB_ID_KEY) != null) {
                    views.add((AnAction)new Separator());
                }
            } else {
                lastHeaderHadKids = true;
            }
            lastWasHeader = each.getUserData(SUB_ID_KEY) == null;
            views.add((AnAction)new ChangeViewAction((String)each.getUserData(ID_KEY), (String)each.getUserData(SUB_ID_KEY)));
        }
        result.add((AnAction)views);
        result.add((AnAction)new Separator());
        ArrayList<AnAction> secondary = new ArrayList<AnAction>();
        if (this.myActionGroup != null) {
            AnAction[] kids;
            for (AnAction each : kids = this.myActionGroup.getChildren(null)) {
                if (this.myActionGroup.isPrimary(each)) {
                    result.add(each);
                    continue;
                }
                secondary.add(each);
            }
        }
        result.add((AnAction)new Separator());
        result.addAll(secondary);
        return result;
    }

    public boolean isCycleRoot() {
        return false;
    }

    @Override
    public synchronized void addProjectPane(AbstractProjectViewPane pane) {
        this.myUninitializedPanes.add(pane);
        SelectInTarget selectInTarget = pane.createSelectInTarget();
        if (selectInTarget != null) {
            this.mySelectInTargets.put(pane.getId(), selectInTarget);
        }
        if (this.isInitialized) {
            this.doAddUninitializedPanes();
        }
    }

    @Override
    public synchronized void removeProjectPane(AbstractProjectViewPane pane) {
        this.myUninitializedPanes.remove(pane);
        String idToRemove = pane.getId();
        if (!this.myId2Pane.containsKey(idToRemove)) {
            return;
        }
        pane.removeTreeChangeListener();
        for (int i = this.myContentManager.getContentCount() - 1; i >= 0; --i) {
            String id;
            Content content = this.myContentManager.getContent(i);
            String string = id = content != null ? (String)content.getUserData(ID_KEY) : null;
            if (id == null || !id.equals(idToRemove)) continue;
            this.myContentManager.removeContent(content, true);
        }
        this.myId2Pane.remove(idToRemove);
        this.mySelectInTargets.remove(idToRemove);
        this.viewSelectionChanged();
    }

    private synchronized void doAddUninitializedPanes() {
        for (AbstractProjectViewPane pane : this.myUninitializedPanes) {
            this.doAddPane(pane);
        }
        Content[] contents = this.myContentManager.getContents();
        for (int i = 1; i < contents.length; ++i) {
            Content content = contents[i];
            Content prev = contents[i - 1];
            if (StringUtil.equals((CharSequence)((CharSequence)content.getUserData(ID_KEY)), (CharSequence)((CharSequence)prev.getUserData(ID_KEY))) || prev.getUserData(SUB_ID_KEY) == null || content.getSeparator() != null) continue;
            content.setSeparator("");
        }
        String selectID = null;
        String selectSubID = null;
        for (Content content : contents) {
            String id = (String)content.getUserData(ID_KEY);
            String subId = (String)content.getUserData(SUB_ID_KEY);
            if (id == null || !id.equals(this.mySavedPaneId) || !StringUtil.equals((CharSequence)subId, (CharSequence)this.mySavedPaneSubId)) continue;
            selectID = id;
            selectSubID = subId;
            break;
        }
        if (selectID == null && contents.length > 0) {
            Content content = contents[0];
            selectID = (String)content.getUserData(ID_KEY);
            selectSubID = (String)content.getUserData(SUB_ID_KEY);
        }
        if (selectID != null) {
            this.changeView(selectID, selectSubID);
            this.mySavedPaneId = null;
            this.mySavedPaneSubId = null;
        }
        this.myUninitializedPanes.clear();
    }

    private void doAddPane(AbstractProjectViewPane newPane) {
        String[] stringArray;
        int index;
        ContentManager manager = this.myContentManager;
        for (index = 0; index < manager.getContentCount(); ++index) {
            Content content = manager.getContent(index);
            String id = (String)content.getUserData(ID_KEY);
            AbstractProjectViewPane pane = this.myId2Pane.get(id);
            int comp = PANE_WEIGHT_COMPARATOR.compare(pane, newPane);
            if (comp == 0) {
                System.out.println("here");
            }
            LOG.assertTrue(comp != 0);
            if (comp > 0) break;
        }
        String id = newPane.getId();
        this.myId2Pane.put(id, newPane);
        String[] subIds = newPane.getSubIds();
        if (subIds.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = subIds;
        }
        subIds = stringArray;
        boolean first = true;
        for (String subId : subIds) {
            String title = subId != null ? newPane.getPresentableSubIdName(subId) : newPane.getTitle();
            Content content = this.myContentManager.getFactory().createContent(this.getComponent(), title, false);
            content.setTabName(title);
            content.putUserData(ID_KEY, (Object)id);
            content.putUserData(SUB_ID_KEY, (Object)subId);
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            content.setIcon(newPane.getIcon());
            content.setPopupIcon(subId != null ? AllIcons.General.Bullet : newPane.getIcon());
            content.setPreferredFocusedComponent((Computable)new Computable<JComponent>(){

                public JComponent compute() {
                    AbstractProjectViewPane current = ProjectViewImpl.this.getCurrentProjectViewPane();
                    return current != null ? current.getComponentToFocus() : null;
                }
            });
            content.setBusyObject((BusyObject)this);
            if (first && subId != null) {
                content.setSeparator(newPane.getTitle());
            }
            manager.addContent(content, index++);
            first = false;
        }
        Disposer.register((Disposable)this, (Disposable)newPane);
    }

    private void showPane(AbstractProjectViewPane newPane) {
        VirtualFile virtualFile;
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        PsiElement selectedPsiElement = null;
        if (currentPane != null) {
            PsiElement[] elements;
            if (currentPane != newPane) {
                currentPane.saveExpandedPaths();
            }
            if ((elements = currentPane.getSelectedPSIElements()).length > 0) {
                selectedPsiElement = elements[0];
            }
        }
        this.myViewContentPanel.removeAll();
        JComponent component = newPane.createComponent();
        UIUtil.removeScrollBorder((Component)component);
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)component, "Center");
        this.myCurrentViewId = newPane.getId();
        String newSubId = this.myCurrentViewSubId = newPane.getSubId();
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.createToolbarActions();
        this.updateTitleActions();
        this.myAutoScrollToSourceHandler.install((JTree)((Object)newPane.myTree));
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)newPane.getComponentToFocus(), false);
        newPane.restoreExpandedPaths();
        if (selectedPsiElement != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)selectedPsiElement)) != null && ((ProjectViewSelectInTarget)newPane.createSelectInTarget()).isSubIdSelectable(newSubId, new SelectInContext(){

            @NotNull
            public Project getProject() {
                Project project = ProjectViewImpl.this.myProject;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$7", "getProject"));
                }
                return project;
            }

            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$7", "getVirtualFile"));
                }
                return virtualFile2;
            }

            public Object getSelectorInFile() {
                return null;
            }

            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        })) {
            newPane.select(selectedPsiElement, virtualFile, true);
        }
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)((Object)newPane.myTree));
    }

    private void updateTitleActions() {
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project");
        if (!(window instanceof ToolWindowEx)) {
            return;
        }
        ScrollFromSourceAction scrollAction = null;
        CollapseAllToolbarAction collapseAction = null;
        for (AnAction action : this.myActionGroup.getChildren(null)) {
            if (action instanceof ScrollFromSourceAction) {
                scrollAction = (ScrollFromSourceAction)action;
                this.myActionGroup.remove((AnAction)scrollAction);
            }
            if (!(action instanceof CollapseAllToolbarAction)) continue;
            collapseAction = (CollapseAllToolbarAction)action;
            collapseAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
            collapseAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
            this.myActionGroup.remove((AnAction)collapseAction);
        }
        ((ToolWindowEx)window).setTitleActions(new AnAction[]{scrollAction, collapseAction});
    }

    public synchronized void setupImpl(ToolWindow toolWindow) {
        this.setupImpl(toolWindow, true);
    }

    public synchronized void setupImpl(ToolWindow toolWindow, boolean loadPaneExtensions) {
        this.myActionGroup = new DefaultActionGroup();
        this.myAutoScrollFromSourceHandler.install();
        if (toolWindow != null) {
            this.myContentManager = toolWindow.getContentManager();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                toolWindow.setContentUiType(ToolWindowContentUiType.getInstance((String)"combo"), null);
                ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)this.myActionGroup);
                toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            }
        } else {
            ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
            this.myContentManager = contentFactory.createContentManager(false, this.myProject);
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectViewImpl.this.splitterProportions.restoreSplitterProportions((Component)ProjectViewImpl.this.myPanel);
            }
        });
        if (loadPaneExtensions) {
            this.ensurePanesLoaded();
        }
        this.isInitialized = true;
        this.doAddUninitializedPanes();
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    ProjectViewImpl.this.viewSelectionChanged();
                }
            }
        });
    }

    private void ensurePanesLoaded() {
        if (this.myExtensionsLoaded) {
            return;
        }
        this.myExtensionsLoaded = true;
        for (AbstractProjectViewPane pane : (AbstractProjectViewPane[])Extensions.getExtensions(AbstractProjectViewPane.EP_NAME, (AreaInstance)this.myProject)) {
            if (this.myUninitializedPaneState.containsKey(pane.getId())) {
                try {
                    pane.readExternal(this.myUninitializedPaneState.get(pane.getId()));
                }
                catch (InvalidDataException e) {
                    // empty catch block
                }
                this.myUninitializedPaneState.remove(pane.getId());
            }
            if (pane.isInitiallyVisible() && !this.myId2Pane.containsKey(pane.getId())) {
                this.addProjectPane(pane);
            }
            Disposer.register((Disposable)this, (Disposable)pane);
        }
    }

    private boolean viewSelectionChanged() {
        Content content = this.myContentManager.getSelectedContent();
        if (content == null) {
            return false;
        }
        String id = (String)content.getUserData(ID_KEY);
        String subId = (String)content.getUserData(SUB_ID_KEY);
        if (content.equals(Pair.create((Object)this.myCurrentViewId, (Object)this.myCurrentViewSubId))) {
            return false;
        }
        AbstractProjectViewPane newPane = this.getProjectViewPaneById(id);
        if (newPane == null) {
            return false;
        }
        newPane.setSubId(subId);
        this.showPane(newPane);
        if (this.isAutoscrollFromSource(id)) {
            this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
        return true;
    }

    private void createToolbarActions() {
        this.myActionGroup.removeAll();
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction((Map)this.myFlattenPackages, IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.flatten.packages", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON, false){

                @Override
                public void setSelected(AnActionEvent event, boolean flag) {
                    AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
                    SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
                    super.setSelected(event, flag);
                    selectionInfo.apply(viewPane);
                }
            }).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsHideEmptyMiddlePackages()) {
            this.myActionGroup.addAction((AnAction)new HideEmptyMiddlePackagesAction()).setAsSecondary(true);
        }
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            class FlattenPackagesDependableAction
            extends PaneOptionAction {
                FlattenPackagesDependableAction(Map<String, Boolean> optionsMap, String text, String description, Icon icon, boolean optionDefaultValue) {
                    super(optionsMap, text, description, icon, optionDefaultValue);
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    Presentation presentation = e.getPresentation();
                    presentation.setVisible(ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId));
                }
            }
            this.myActionGroup.addAction((AnAction)new FlattenPackagesDependableAction((Map)this.myAbbreviatePackageNames, IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), IdeBundle.message((String)"action.abbreviate.qualified.package.names", (Object[])new Object[0]), AllIcons.ObjectBrowser.AbbreviatePackageNames, false){
                {
                    super(x0, x1, x2, x3, x4);
                }

                @Override
                public boolean isSelected(AnActionEvent event) {
                    return super.isSelected(event) && ProjectViewImpl.this.isAbbreviatePackageNames(ProjectViewImpl.this.myCurrentViewId);
                }

                @Override
                public void update(AnActionEvent e) {
                    super.update(e);
                    if ("Scope".equals(ProjectViewImpl.this.myCurrentViewId)) {
                        e.getPresentation().setEnabled(false);
                    }
                }
            }).setAsSecondary(true);
        }
        if (!PlatformUtils.isCidr()) {
            this.myActionGroup.addAction((AnAction)new PaneOptionAction(this.myShowMembers, IdeBundle.message((String)"action.show.members", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.members", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowMembers, false)).setAsSecondary(true);
        }
        this.myActionGroup.addAction((AnAction)this.myAutoScrollToSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new SortByTypeAction()).setAsSecondary(true);
        this.myActionGroup.addAction((AnAction)new FoldersAlwaysOnTopAction()).setAsSecondary(true);
        if (!this.myAutoScrollFromSourceHandler.isAutoScrollEnabled()) {
            this.myActionGroup.addAction((AnAction)new ScrollFromSourceAction());
        }
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public void expandAll() {
            }

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                AbstractProjectViewPane pane = ProjectViewImpl.this.getCurrentProjectViewPane();
                DnDAwareTree tree = pane.myTree;
                if (tree != null) {
                    TreeUtil.collapseAll((JTree)((Object)tree), (int)0);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, this.getComponent());
        this.myActionGroup.add(collapseAllAction);
        this.getCurrentProjectViewPane().addToolbarActions(this.myActionGroup);
    }

    @Override
    public AbstractProjectViewPane getProjectViewPaneById(String id) {
        AbstractProjectViewPane pane;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.ensurePanesLoaded();
        }
        if ((pane = this.myId2Pane.get(id)) != null) {
            return pane;
        }
        for (AbstractProjectViewPane viewPane : this.myUninitializedPanes) {
            if (!viewPane.getId().equals(id)) continue;
            return viewPane;
        }
        return null;
    }

    @Override
    public AbstractProjectViewPane getCurrentProjectViewPane() {
        return this.getProjectViewPaneById(this.myCurrentViewId);
    }

    @Override
    public void refresh() {
        AbstractProjectViewPane currentProjectViewPane = this.getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            currentProjectViewPane.updateFromRoot(false);
        }
    }

    @Override
    public void select(Object element, VirtualFile file, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null) {
            viewPane.select(element, file, requestFocus);
        }
    }

    @Override
    public ActionCallback selectCB(Object element, VirtualFile file, boolean requestFocus) {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane != null && viewPane instanceof AbstractProjectViewPSIPane) {
            return ((AbstractProjectViewPSIPane)viewPane).selectCB(element, file, requestFocus);
        }
        this.select(element, file, requestFocus);
        return new ActionCallback.Done();
    }

    public void dispose() {
        this.myConnection.disconnect();
    }

    public JComponent getComponent() {
        return this.myDataProvider;
    }

    @Override
    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    @Override
    public PsiElement getParentOfCurrentSelection() {
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return null;
        }
        TreePath path = viewPane.getSelectedPath();
        if (path == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof ProjectViewNode) {
            ProjectViewNode descriptor = (ProjectViewNode)userObject;
            Object element = descriptor.getValue();
            if (element instanceof PsiElement) {
                PsiElement psiElement = (PsiElement)element;
                if (!psiElement.isValid()) {
                    return null;
                }
                return psiElement;
            }
            return null;
        }
        return null;
    }

    @Override
    public void changeView() {
        ArrayList<AbstractProjectViewPane> views = new ArrayList<AbstractProjectViewPane>(this.myId2Pane.values());
        views.remove(this.getCurrentProjectViewPane());
        Collections.sort(views, PANE_WEIGHT_COMPARATOR);
        JBList list = new JBList(ArrayUtil.toObjectArray(views));
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                AbstractProjectViewPane pane = (AbstractProjectViewPane)value;
                this.setText(pane.getTitle());
                return this;
            }
        });
        if (!views.isEmpty()) {
            list.setSelectedValue(views.get(0), true);
        }
        Runnable runnable = new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                if (this.val$list.getSelectedIndex() < 0) {
                    return;
                }
                AbstractProjectViewPane pane = (AbstractProjectViewPane)this.val$list.getSelectedValue();
                ProjectViewImpl.this.changeView(pane.getId());
            }
        };
        new PopupChooserBuilder((JList)list).setTitle(IdeBundle.message((String)"title.popup.views", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInCenterOf((Component)this.getComponent());
    }

    @Override
    public void changeView(@NotNull String viewId) {
        if (viewId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl", "changeView"));
        }
        this.changeView(viewId, null);
    }

    @Override
    public void changeView(@NotNull String viewId, @Nullable String subId) {
        if (viewId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl", "changeView"));
        }
        AbstractProjectViewPane pane = this.getProjectViewPaneById(viewId);
        LOG.assertTrue(pane != null, (Object)("Project view pane not found: " + viewId + "; subId:" + subId));
        if (!viewId.equals(this.getCurrentViewId()) || subId != null && !subId.equals(pane.getSubId())) {
            for (Content content : this.myContentManager.getContents()) {
                if (!viewId.equals(content.getUserData(ID_KEY)) || !StringUtil.equals((CharSequence)subId, (CharSequence)((CharSequence)content.getUserData(SUB_ID_KEY)))) continue;
                this.myContentManager.setSelectedContent(content);
                break;
            }
            this.viewSelectionChanged();
        }
    }

    @Nullable
    private Module moduleBySingleContentRoot(VirtualFile file) {
        Module module;
        if (ProjectRootsUtil.isModuleContentRoot(file, this.myProject) && (module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file)) != null && !module.isDisposed() && ModuleRootManager.getInstance((Module)module).getContentRoots().length == 1) {
            return module;
        }
        return null;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements;
        ArrayList<Object> result = new ArrayList<Object>();
        AbstractProjectViewPane viewPane = this.getCurrentProjectViewPane();
        if (viewPane == null) {
            return result;
        }
        for (Object element : elements = viewPane.getSelectedElements()) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public void selectPsiElement(PsiElement element, boolean requestFocus) {
        if (element == null) {
            return;
        }
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)element);
        this.select(element, virtualFile, requestFocus);
    }

    private static void readOption(Element node, Map<String, Boolean> options) {
        if (node == null) {
            return;
        }
        List attributes = node.getAttributes();
        for (Object attribute1 : attributes) {
            Attribute attribute = (Attribute)attribute1;
            options.put(attribute.getName(), Boolean.TRUE.toString().equals(attribute.getValue()) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static void writeOption(Element parentNode, Map<String, Boolean> optionsForPanes, String optionName) {
        Element e = new Element(optionName);
        for (Map.Entry<String, Boolean> entry : optionsForPanes.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            e.setAttribute(key, Boolean.toString(entry.getValue()));
        }
        parentNode.addContent(e);
    }

    public void loadState(Element parentNode) {
        Element panesElement;
        Element navigatorElement = parentNode.getChild(ELEMENT_NAVIGATOR);
        if (navigatorElement != null) {
            this.mySavedPaneId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_VIEW);
            this.mySavedPaneSubId = navigatorElement.getAttributeValue(ATTRIBUTE_CURRENT_SUBVIEW);
            if (this.mySavedPaneId == null) {
                this.mySavedPaneId = "ProjectPane";
                this.mySavedPaneSubId = null;
            }
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_FLATTEN_PACKAGES), this.myFlattenPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MEMBERS), this.myShowMembers);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_MODULES), this.myShowModules);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SHOW_LIBRARY_CONTENTS), this.myShowLibraryContents);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_HIDE_EMPTY_PACKAGES), this.myHideEmptyPackages);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_ABBREVIATE_PACKAGE_NAMES), this.myAbbreviatePackageNames);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_TO_SOURCE), this.myAutoscrollToSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_AUTOSCROLL_FROM_SOURCE), this.myAutoscrollFromSource);
            ProjectViewImpl.readOption(navigatorElement.getChild(ELEMENT_SORT_BY_TYPE), this.mySortByType);
            try {
                this.splitterProportions.readExternal(navigatorElement);
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        if ((panesElement = parentNode.getChild(ELEMENT_PANES)) != null) {
            this.readPaneState(panesElement);
        }
    }

    private void readPaneState(Element panesElement) {
        List paneElements = panesElement.getChildren(ELEMENT_PANE);
        for (Element paneElement : paneElements) {
            String paneId = paneElement.getAttributeValue(ATTRIBUTE_ID);
            AbstractProjectViewPane pane = this.myId2Pane.get(paneId);
            if (pane != null) {
                try {
                    pane.readExternal(paneElement);
                }
                catch (InvalidDataException e) {}
                continue;
            }
            this.myUninitializedPaneState.put(paneId, paneElement);
        }
    }

    public Element getState() {
        Element parentNode = new Element("projectView");
        Element navigatorElement = new Element(ELEMENT_NAVIGATOR);
        AbstractProjectViewPane currentPane = this.getCurrentProjectViewPane();
        if (currentPane != null) {
            navigatorElement.setAttribute(ATTRIBUTE_CURRENT_VIEW, currentPane.getId());
            String subId = currentPane.getSubId();
            if (subId != null) {
                navigatorElement.setAttribute(ATTRIBUTE_CURRENT_SUBVIEW, subId);
            }
        }
        ProjectViewImpl.writeOption(navigatorElement, this.myFlattenPackages, ELEMENT_FLATTEN_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowMembers, ELEMENT_SHOW_MEMBERS);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowModules, ELEMENT_SHOW_MODULES);
        ProjectViewImpl.writeOption(navigatorElement, this.myShowLibraryContents, ELEMENT_SHOW_LIBRARY_CONTENTS);
        ProjectViewImpl.writeOption(navigatorElement, this.myHideEmptyPackages, ELEMENT_HIDE_EMPTY_PACKAGES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAbbreviatePackageNames, ELEMENT_ABBREVIATE_PACKAGE_NAMES);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollToSource, ELEMENT_AUTOSCROLL_TO_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.myAutoscrollFromSource, ELEMENT_AUTOSCROLL_FROM_SOURCE);
        ProjectViewImpl.writeOption(navigatorElement, this.mySortByType, ELEMENT_SORT_BY_TYPE);
        this.splitterProportions.saveSplitterProportions((Component)this.myPanel);
        try {
            this.splitterProportions.writeExternal(navigatorElement);
        }
        catch (WriteExternalException e) {
            // empty catch block
        }
        parentNode.addContent(navigatorElement);
        Element panesElement = new Element(ELEMENT_PANES);
        this.writePaneState(panesElement);
        parentNode.addContent(panesElement);
        return parentNode;
    }

    private void writePaneState(Element panesElement) {
        for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
            Element paneElement = new Element(ELEMENT_PANE);
            paneElement.setAttribute(ATTRIBUTE_ID, pane.getId());
            try {
                pane.writeExternal(paneElement);
            }
            catch (WriteExternalException e) {
                continue;
            }
            panesElement.addContent(paneElement);
        }
        for (Element element : this.myUninitializedPaneState.values()) {
            panesElement.addContent(element.clone());
        }
    }

    @Override
    public boolean isAutoscrollToSource(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollToSource, paneId, UISettings.getInstance().DEFAULT_AUTOSCROLL_TO_SOURCE);
    }

    public void setAutoscrollToSource(boolean autoscrollMode, String paneId) {
        this.myAutoscrollToSource.put(paneId, autoscrollMode ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean isAutoscrollFromSource(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAutoscrollFromSource, paneId, false);
    }

    public void setAutoscrollFromSource(boolean autoscrollMode, String paneId) {
        this.setPaneOption(this.myAutoscrollFromSource, autoscrollMode, paneId, false);
    }

    @Override
    public boolean isFlattenPackages(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myFlattenPackages, paneId, false);
    }

    public void setFlattenPackages(boolean flattenPackages, String paneId) {
        this.setPaneOption(this.myFlattenPackages, flattenPackages, paneId, true);
    }

    public boolean isFoldersAlwaysOnTop() {
        return this.myFoldersAlwaysOnTop;
    }

    public void setFoldersAlwaysOnTop(boolean foldersAlwaysOnTop) {
        if (this.myFoldersAlwaysOnTop != foldersAlwaysOnTop) {
            this.myFoldersAlwaysOnTop = foldersAlwaysOnTop;
            for (AbstractProjectViewPane pane : this.myId2Pane.values()) {
                if (pane.getTree() == null) continue;
                pane.updateFromRoot(false);
            }
        }
    }

    @Override
    public boolean isShowMembers(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowMembers, paneId, false);
    }

    public void setShowMembers(boolean showMembers, String paneId) {
        this.setPaneOption(this.myShowMembers, showMembers, paneId, true);
    }

    @Override
    public boolean isHideEmptyMiddlePackages(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myHideEmptyPackages, paneId, true);
    }

    @Override
    public boolean isAbbreviatePackageNames(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myAbbreviatePackageNames, paneId, false);
    }

    @Override
    public boolean isShowLibraryContents(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowLibraryContents, paneId, true);
    }

    @Override
    public void setShowLibraryContents(boolean showLibraryContents, String paneId) {
        this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    public ActionCallback setShowLibraryContentsCB(boolean showLibraryContents, String paneId) {
        return this.setPaneOption(this.myShowLibraryContents, showLibraryContents, paneId, true);
    }

    @Override
    public boolean isShowModules(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.myShowModules, paneId, true);
    }

    @Override
    public void setShowModules(boolean showModules, String paneId) {
        this.setPaneOption(this.myShowModules, showModules, paneId, true);
    }

    @Override
    public void setHideEmptyPackages(boolean hideEmptyPackages, String paneId) {
        this.setPaneOption(this.myHideEmptyPackages, hideEmptyPackages, paneId, true);
    }

    @Override
    public void setAbbreviatePackageNames(boolean abbreviatePackageNames, String paneId) {
        this.setPaneOption(this.myAbbreviatePackageNames, abbreviatePackageNames, paneId, true);
    }

    private ActionCallback setPaneOption(Map<String, Boolean> optionsMap, boolean value, String paneId, boolean updatePane) {
        AbstractProjectViewPane pane;
        optionsMap.put(paneId, value ? Boolean.TRUE : Boolean.FALSE);
        if (updatePane && (pane = this.getProjectViewPaneById(paneId)) != null) {
            return pane.updateFromRoot(false);
        }
        return new ActionCallback.Done();
    }

    private static boolean getPaneOptionValue(Map<String, Boolean> optionsMap, String paneId, boolean defaultValue) {
        Boolean value = optionsMap.get(paneId);
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean isSortByType(String paneId) {
        return ProjectViewImpl.getPaneOptionValue(this.mySortByType, paneId, false);
    }

    @Override
    public void setSortByType(String paneId, boolean sortByType) {
        this.setPaneOption(this.mySortByType, sortByType, paneId, false);
        AbstractProjectViewPane pane = this.getProjectViewPaneById(paneId);
        pane.installComparator();
    }

    @Override
    public Collection<String> getPaneIds() {
        return this.myId2Pane.keySet();
    }

    @Override
    public Collection<SelectInTarget> getSelectInTargets() {
        this.ensurePanesLoaded();
        return this.mySelectInTargets.values();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl", "getReady"));
        }
        AbstractProjectViewPane pane = this.myId2Pane.get(this.myCurrentViewSubId);
        if (pane == null) {
            pane = this.myId2Pane.get(this.myCurrentViewId);
        }
        Object object = pane != null ? pane.getReady(requestor) : new ActionCallback.Done();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl", "getReady"));
        }
        return object;
    }

    private class ScrollFromSourceAction
    extends AnAction
    implements DumbAware {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", AllIcons.General.Locate);
            this.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        }

        public void actionPerformed(AnActionEvent e) {
            ProjectViewImpl.this.myAutoScrollFromSourceHandler.scrollFromSource();
        }
    }

    private class FoldersAlwaysOnTopAction
    extends ToggleAction {
        private FoldersAlwaysOnTopAction() {
            super("Folders Always on Top");
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isFoldersAlwaysOnTop();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setFoldersAlwaysOnTop(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setVisible(ProjectViewImpl.this.getCurrentProjectViewPane() != null);
        }
    }

    private class SortByTypeAction
    extends ToggleAction {
        private SortByTypeAction() {
            super(IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), AllIcons.ObjectBrowser.SortByType);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.this.isSortByType(ProjectViewImpl.this.getCurrentViewId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setSortByType(ProjectViewImpl.this.getCurrentViewId(), flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setVisible(ProjectViewImpl.this.getCurrentProjectViewPane() != null);
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private MyAutoScrollFromSourceHandler() {
            super(ProjectViewImpl.this.myProject, (JComponent)ProjectViewImpl.this.myViewContentPanel, (Disposable)ProjectViewImpl.this);
        }

        protected void selectElementFromEditor(@NotNull FileEditor fileEditor) {
            if (fileEditor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
            }
            if (this.myProject.isDisposed() || !ProjectViewImpl.this.myViewContentPanel.isShowing()) {
                return;
            }
            if (ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.getCurrentViewId())) {
                if (fileEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    this.selectElementAtCaretNotLosingFocus(editor);
                } else {
                    MySelectInContext selectInContext;
                    SelectInTarget target;
                    PsiFile psiFile;
                    VirtualFile file = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(fileEditor);
                    if (file != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null && (target = (SelectInTarget)ProjectViewImpl.this.mySelectInTargets.get(ProjectViewImpl.this.getCurrentViewId())) != null && target.canSelect((SelectInContext)(selectInContext = new MySelectInContext(psiFile, null){

                        @Override
                        public Object getSelectorInFile() {
                            return psiFile;
                        }
                    }))) {
                        target.selectIn((SelectInContext)selectInContext, false);
                    }
                }
            }
        }

        public void scrollFromSource() {
            PsiFile file;
            FileEditor[] editors;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
            if (selectedTextEditor != null) {
                this.selectElementAtCaret(selectedTextEditor);
                return;
            }
            for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                this.selectElementAtCaret(editor);
                return;
            }
            VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
            if (selectedFiles.length > 0 && (file = PsiManager.getInstance((Project)this.myProject).findFile(selectedFiles[0])) != null) {
                this.scrollFromFile(file, null);
            }
        }

        private void selectElementAtCaretNotLosingFocus(Editor editor) {
            if (IJSwingUtilities.hasFocus(ProjectViewImpl.this.getCurrentProjectViewPane().getComponentToFocus())) {
                return;
            }
            this.selectElementAtCaret(editor);
        }

        private void selectElementAtCaret(Editor editor) {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            this.scrollFromFile(file, editor);
        }

        private void scrollFromFile(PsiFile file, @Nullable Editor editor) {
            MySelectInContext selectInContext = new MySelectInContext(file, editor);
            SelectInTarget target = (SelectInTarget)ProjectViewImpl.this.mySelectInTargets.get(ProjectViewImpl.this.getCurrentViewId());
            if (target != null && target.canSelect((SelectInContext)selectInContext)) {
                target.selectIn((SelectInContext)selectInContext, false);
            }
        }

        protected boolean isAutoScrollEnabled() {
            return ProjectViewImpl.this.isAutoscrollFromSource(ProjectViewImpl.this.myCurrentViewId);
        }

        protected void setAutoScrollEnabled(boolean state) {
            Editor editor;
            ProjectViewImpl.this.setAutoscrollFromSource(state, ProjectViewImpl.this.myCurrentViewId);
            if (state && (editor = ProjectViewImpl.this.myFileEditorManager.getSelectedTextEditor()) != null) {
                this.selectElementAtCaretNotLosingFocus(editor);
            }
            ProjectViewImpl.this.createToolbarActions();
            ProjectViewImpl.this.updateTitleActions();
        }

        private class MySelectInContext
        implements SelectInContext {
            private final PsiFile myPsiFile;
            @Nullable
            private final Editor myEditor;

            private MySelectInContext(@Nullable PsiFile psiFile, Editor editor) {
                this.myPsiFile = psiFile;
                this.myEditor = editor;
            }

            @NotNull
            public Project getProject() {
                Project project = MyAutoScrollFromSourceHandler.this.myProject;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext", "getProject"));
                }
                return project;
            }

            private PsiFile getPsiFile() {
                return this.myPsiFile;
            }

            public FileEditorProvider getFileEditorProvider() {
                if (this.myPsiFile == null) {
                    return null;
                }
                return new FileEditorProvider(){

                    public FileEditor openFileEditor() {
                        return ProjectViewImpl.this.myFileEditorManager.openFile(MySelectInContext.this.myPsiFile.getContainingFile().getVirtualFile(), false)[0];
                    }
                };
            }

            private PsiElement getPsiElement() {
                PsiFile e = null;
                if (this.myEditor != null) {
                    int offset = this.myEditor.getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)MyAutoScrollFromSourceHandler.this.myProject).commitAllDocuments();
                    e = this.getPsiFile().findElementAt(offset);
                }
                if (e == null) {
                    e = this.getPsiFile();
                }
                return e;
            }

            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = this.getPsiFile().getVirtualFile();
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyAutoScrollFromSourceHandler$MySelectInContext", "getVirtualFile"));
                }
                return virtualFile;
            }

            public Object getSelectorInFile() {
                return this.getPsiElement();
            }
        }
    }

    private static class SelectionInfo {
        private final Object[] myElements;

        private SelectionInfo(Object[] elements) {
            this.myElements = elements;
        }

        public void apply(AbstractProjectViewPane viewPane) {
            if (viewPane == null) {
                return;
            }
            AbstractTreeBuilder treeBuilder = viewPane.getTreeBuilder();
            DnDAwareTree tree = viewPane.myTree;
            DefaultTreeModel treeModel = (DefaultTreeModel)((JTree)((Object)tree)).getModel();
            ArrayList<TreePath> paths = new ArrayList<TreePath>(this.myElements.length);
            for (Object element : this.myElements) {
                DefaultMutableTreeNode node = treeBuilder.getNodeForElement(element);
                if (node == null) {
                    treeBuilder.buildNodeForElement(element);
                    node = treeBuilder.getNodeForElement(element);
                }
                if (node == null) continue;
                paths.add(new TreePath(treeModel.getPathToRoot(node)));
            }
            if (!paths.isEmpty()) {
                ((JTree)((Object)tree)).setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
            }
        }

        public static SelectionInfo create(AbstractProjectViewPane viewPane) {
            TreePath[] selectionPaths;
            List selectedElements = Collections.emptyList();
            if (viewPane != null && (selectionPaths = viewPane.getSelectionPaths()) != null) {
                selectedElements = new ArrayList();
                for (TreePath path : selectionPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof NodeDescriptor)) continue;
                    selectedElements.add(((NodeDescriptor)userObject).getElement());
                }
            }
            return new SelectionInfo(selectedElements.toArray());
        }
    }

    private class HideEmptyMiddlePackagesAction
    extends PaneOptionAction {
        private HideEmptyMiddlePackagesAction() {
            super(ProjectViewImpl.this.myHideEmptyPackages, "", "", null, true);
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            SelectionInfo selectionInfo = SelectionInfo.create(viewPane);
            super.setSelected(event, flag);
            selectionInfo.apply(viewPane);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (ProjectViewImpl.this.isFlattenPackages(ProjectViewImpl.this.myCurrentViewId)) {
                presentation.setText(IdeBundle.message((String)"action.hide.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.hide.empty.middle.packages", (Object[])new Object[0]));
            } else {
                presentation.setText(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.show.compact.empty.middle.packages", (Object[])new Object[0]));
            }
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            FileEditor editor;
            boolean isDirectory;
            ProjectViewImpl.this.selectPsiElement(element, false);
            boolean requestFocus = true;
            if (element != null && !(isDirectory = element instanceof PsiDirectory) && (editor = EditorHelper.openInEditor(element, false)) != null) {
                ToolWindowManager.getInstance((Project)ProjectViewImpl.this.myProject).activateEditorComponent();
                requestFocus = false;
            }
            if (requestFocus) {
                ProjectViewImpl.this.selectPsiElement(element, true);
            }
        }

        public PsiDirectory[] getDirectories() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane != null) {
                return viewPane.getSelectedDirectories();
            }
            return PsiDirectory.EMPTY_ARRAY;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        private Object getSelectedNodeElement() {
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane == null) {
                return null;
            }
            DefaultMutableTreeNode node = currentProjectViewPane.getSelectedNode();
            if (node == null) {
                return null;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof AbstractTreeNode) {
                return ((AbstractTreeNode)userObject).getValue();
            }
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            return ((NodeDescriptor)userObject).getElement();
        }

        public Object getData(String dataId) {
            List selectedElements;
            Object selected;
            PsiElement[] elements;
            Object paneSpecificData;
            AbstractProjectViewPane currentProjectViewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (currentProjectViewPane != null && (paneSpecificData = currentProjectViewPane.getData(dataId)) != null) {
                return paneSpecificData;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 1 ? elements[0] : null;
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                if (currentProjectViewPane == null) {
                    return null;
                }
                elements = currentProjectViewPane.getSelectedPSIElements();
                return elements.length == 0 ? null : elements;
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                VirtualFile[] virtualFiles = (VirtualFile[])this.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName());
                if (virtualFiles == null || virtualFiles.length <= 1) {
                    return null;
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (VirtualFile virtualFile : virtualFiles) {
                    modules.add(ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)ProjectViewImpl.this.myProject));
                }
                return modules.size() == 1 ? (Module)modules.iterator().next() : null;
            }
            if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                return null;
            }
            if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCutProvider();
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
                return ProjectViewImpl.this.myCopyPasteDelegator.getPasteProvider();
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                return ProjectViewImpl.this.myIdeView;
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                Module[] modules = this.getSelectedModules();
                if (modules != null) {
                    return ProjectViewImpl.this.myDeleteModuleProvider;
                }
                final LibraryOrderEntry orderEntry = this.getSelectedLibrary();
                if (orderEntry != null) {
                    return new DeleteProvider(){

                        public void deleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel$1", "deleteElement"));
                            }
                            MyPanel.this.detachLibrary(orderEntry, ProjectViewImpl.this.myProject);
                        }

                        public boolean canDeleteElement(@NotNull DataContext dataContext) {
                            if (dataContext == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyPanel$1", "canDeleteElement"));
                            }
                            return true;
                        }
                    };
                }
                return ProjectViewImpl.this.myDeletePSIElementProvider;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "viewingStructure.projectViews";
            }
            if (DATA_KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                return selected instanceof Project ? selected : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                selected = this.getSelectedNodeElement();
                if (selected instanceof Module) {
                    return !((Module)selected).isDisposed() ? selected : null;
                }
                if (selected instanceof PsiDirectory) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)selected).getVirtualFile());
                }
                if (selected instanceof VirtualFile) {
                    return ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)selected);
                }
                return null;
            }
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
                return this.getSelectedModules();
            }
            if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(ModuleGroup.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[selectedElements.size()]);
            }
            if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(LibraryGroupElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[selectedElements.size()]);
            }
            if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
                selectedElements = ProjectViewImpl.this.getSelectedElements(NamedLibraryElement.class);
                return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[selectedElements.size()]);
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return ProjectViewImpl.this;
            }
            return null;
        }

        @Nullable
        private LibraryOrderEntry getSelectedLibrary() {
            DefaultMutableTreeNode node;
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            DefaultMutableTreeNode defaultMutableTreeNode = node = viewPane != null ? viewPane.getSelectedNode() : null;
            if (node == null) {
                return null;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) {
                return null;
            }
            Object userObject = parent.getUserObject();
            if (userObject instanceof LibraryGroupNode) {
                userObject = node.getUserObject();
                if (userObject instanceof NamedLibraryElementNode) {
                    NamedLibraryElement element = (NamedLibraryElement)((NamedLibraryElementNode)((Object)userObject)).getValue();
                    LibraryOrSdkOrderEntry orderEntry = element.getOrderEntry();
                    return orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
                }
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)((Object)userObject)).getValue();
                VirtualFile virtualFile = directory.getVirtualFile();
                Module module = (Module)((AbstractTreeNode)((DefaultMutableTreeNode)parent.getParent()).getUserObject()).getValue();
                if (module == null) {
                    return null;
                }
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
                OrderEntry entry = index.getOrderEntryForFile(virtualFile);
                if (entry instanceof LibraryOrderEntry) {
                    return (LibraryOrderEntry)entry;
                }
            }
            return null;
        }

        private void detachLibrary(final LibraryOrderEntry orderEntry, Project project) {
            String title;
            final Module module = orderEntry.getOwnerModule();
            String message = IdeBundle.message((String)"detach.library.from.module", (Object[])new Object[]{orderEntry.getPresentableName(), module.getName()});
            int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)(title = IdeBundle.message((String)"detach.library", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(module.getProject(), new Runnable(){

                @Override
                public void run() {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                            OrderEntry[] orderEntries = rootManager.getOrderEntries();
                            ModifiableRootModel model = rootManager.getModifiableModel();
                            OrderEntry[] modifiableEntries = model.getOrderEntries();
                            for (int i = 0; i < orderEntries.length; ++i) {
                                OrderEntry entry = orderEntries[i];
                                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != orderEntry.getLibrary()) continue;
                                model.removeOrderEntry(modifiableEntries[i]);
                            }
                            model.commit();
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            }, title, null);
        }

        @Nullable
        private Module[] getSelectedModules() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            if (viewPane == null) {
                return null;
            }
            Object[] elements = viewPane.getSelectedElements();
            ArrayList<Module> result = new ArrayList<Module>();
            for (Object element : elements) {
                Module module;
                if (element instanceof Module) {
                    module = (Module)element;
                    if (module.isDisposed()) continue;
                    result.add(module);
                    continue;
                }
                if (element instanceof ModuleGroup) {
                    Collection<Module> modules = ((ModuleGroup)element).modulesInGroup(ProjectViewImpl.this.myProject, true);
                    result.addAll(modules);
                    continue;
                }
                if (element instanceof PsiDirectory) {
                    module = ProjectViewImpl.this.moduleBySingleContentRoot(((PsiDirectory)element).getVirtualFile());
                    if (module == null) continue;
                    result.add(module);
                    continue;
                }
                if (!(element instanceof VirtualFile) || (module = ProjectViewImpl.this.moduleBySingleContentRoot((VirtualFile)element)) == null) continue;
                result.add(module);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new Module[result.size()]);
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider", "canDeleteElement"));
            }
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/ProjectViewImpl$MyDeletePSIElementProvider", "deleteElement"));
            }
            List<PsiElement> allElements = Arrays.asList(this.getElementsToDelete());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, ProjectViewImpl.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        private PsiElement[] getElementsToDelete() {
            AbstractProjectViewPane viewPane = ProjectViewImpl.this.getCurrentProjectViewPane();
            PsiElement[] elements = viewPane.getSelectedPSIElements();
            for (int idx = 0; idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                PsiElement element = elements[idx];
                if (!(element instanceof PsiDirectory)) continue;
                PsiDirectory directory = (PsiDirectory)element;
                ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(ProjectViewImpl.this.myProject);
                if (ProjectViewImpl.this.isHideEmptyMiddlePackages(viewPane.getId()) && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                    PsiElement[] children;
                    PsiDirectory parent;
                    while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && PsiDirectoryFactory.getInstance(ProjectViewImpl.this.myProject).getQualifiedName(parent, false).length() != 0 && ((children = parent.getChildren()).length == 0 || children.length == 1 && children[0] == directory)) {
                        directory = parent;
                    }
                    elements[idx] = directory;
                }
                if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)ProjectViewImpl.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            return elements;
        }
    }

    private class PaneOptionAction
    extends ToggleAction
    implements DumbAware {
        private final Map<String, Boolean> myOptionsMap;
        private final boolean myOptionDefaultValue;

        PaneOptionAction(Map<String, Boolean> optionsMap, String text, String description, Icon icon, boolean optionDefaultValue) {
            super(text, description, icon);
            this.myOptionsMap = optionsMap;
            this.myOptionDefaultValue = optionDefaultValue;
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectViewImpl.getPaneOptionValue(this.myOptionsMap, ProjectViewImpl.this.myCurrentViewId, this.myOptionDefaultValue);
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl.this.setPaneOption(this.myOptionsMap, flag, ProjectViewImpl.this.myCurrentViewId, true);
        }
    }

    private class ChangeViewAction
    extends AnAction {
        private final String myId;
        private final String mySubId;

        private ChangeViewAction(String id, String subId) {
            this.myId = id;
            this.mySubId = subId;
        }

        public void update(AnActionEvent e) {
            AbstractProjectViewPane pane = ProjectViewImpl.this.getProjectViewPaneById(this.myId);
            e.getPresentation().setText(pane.getTitle() + (this.mySubId != null ? " - " + pane.getPresentableSubIdName(this.mySubId) : ""));
        }

        public void actionPerformed(AnActionEvent e) {
            ProjectViewImpl.this.changeView(this.myId, this.mySubId);
        }
    }
}

