/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.PackagesPaneSelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewProjectNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "PackagesPane";
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();

    public PackageViewPane(Project project) {
        super(project);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"title.packages", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.PackagesTab;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/PackageViewPane", "getId"));
        }
        return ID;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    @Override
    protected PsiElement getPSIElement(@Nullable Object element) {
        if (element instanceof PackageElement) {
            PsiPackage aPackage = ((PackageElement)element).getPackage();
            return aPackage != null && aPackage.isValid() ? aPackage : null;
        }
        return super.getPSIElement(element);
    }

    @Override
    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getModule();
        }
        return super.getNodeModule(element);
    }

    @Override
    public Object getData(String dataId) {
        PackageElement packageElement;
        PackageElement selectedPackageElement;
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (selectedPackageElement = this.getSelectedPackageElement()) != null) {
            return this.myDeletePSIElementProvider;
        }
        if (PackageElement.DATA_KEY.is(dataId)) {
            packageElement = this.getSelectedPackageElement();
        }
        if (LangDataKeys.MODULE.is(dataId) && (packageElement = this.getSelectedPackageElement()) != null) {
            return packageElement.getModule();
        }
        return super.getData(dataId);
    }

    @Nullable
    private PackageElement getSelectedPackageElement() {
        Object o;
        PackageElement result = null;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (o = selectedNode.getUserObject()) instanceof AbstractTreeNode) {
            Object selected = ((AbstractTreeNode)o).getValue();
            result = selected instanceof PackageElement ? (PackageElement)selected : null;
        }
        return result;
    }

    @Override
    public PsiDirectory[] getSelectedDirectories() {
        PackageElement packageElement = this.getSelectedPackageElement();
        if (packageElement != null) {
            Module module = packageElement.getModule();
            PsiPackage aPackage = packageElement.getPackage();
            if (module != null && aPackage != null) {
                return aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
            }
        }
        return super.getSelectedDirectories();
    }

    @Override
    public void addToolbarActions(DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject){

            @Override
            protected String getId() {
                return PackageViewPane.this.getId();
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ShowLibraryContentsAction()).setAsSecondary(true);
    }

    @Override
    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new PackageViewTreeUpdater(treeBuilder);
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new PackagesPaneSelectInTarget(this.myProject);
    }

    @Override
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            @Override
            protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
                return new PackageViewProjectNode(project, settings);
            }
        };
    }

    @Override
    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public String toString() {
                return PackageViewPane.this.getTitle() + " " + super.toString();
            }

            @Override
            public DefaultMutableTreeNode getSelectedNode() {
                return PackageViewPane.this.getSelectedNode();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/PackageViewPane", "getComponentName"));
        }
        return ID;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/PackageViewPane$MyDeletePSIElementProvider", "canDeleteElement"));
            }
            for (PsiDirectory directory : PackageViewPane.this.getSelectedDirectories()) {
                if (directory.getManager().isInProject((PsiElement)directory)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/impl/PackageViewPane$MyDeletePSIElementProvider", "deleteElement"));
            }
            List<PsiDirectory> allElements = Arrays.asList(PackageViewPane.this.getSelectedDirectories());
            ArrayList<PsiDirectory> validElements = new ArrayList<PsiDirectory>();
            for (PsiDirectory psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, PackageViewPane.this.myProject);
            }
            finally {
                a.finish();
            }
        }
    }

    private final class PackageViewTreeUpdater
    extends AbstractTreeUpdater {
        private PackageViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(Object element) {
            if (element instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)element;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
                if (ProjectView.getInstance(PackageViewPane.this.myProject).isShowModules(PackageViewPane.this.getId())) {
                    Module[] modules = this.getModulesFor(dir);
                    boolean rv = false;
                    for (Module module : modules) {
                        rv |= this.addPackageElementToUpdate(aPackage, module);
                    }
                    return rv;
                }
                return this.addPackageElementToUpdate(aPackage, null);
            }
            return super.addSubtreeToUpdateByElement(element);
        }

        private boolean addPackageElementToUpdate(PsiPackage aPackage, Module module) {
            boolean addedOk;
            PsiPackage packageToUpdateFrom;
            ProjectTreeStructure packageTreeStructure = (ProjectTreeStructure)PackageViewPane.this.myTreeStructure;
            if (!packageTreeStructure.isFlattenPackages() && packageTreeStructure.isHideEmptyMiddlePackages()) {
                for (packageToUpdateFrom = aPackage; packageToUpdateFrom != null && packageToUpdateFrom.isValid() && PackageUtil.isPackageEmpty(packageToUpdateFrom, module, true, false); packageToUpdateFrom = packageToUpdateFrom.getParentPackage()) {
                }
            }
            while (!(addedOk = super.addSubtreeToUpdateByElement(this.getTreeElementToUpdateFrom(packageToUpdateFrom, module))) && packageToUpdateFrom != null) {
                packageToUpdateFrom = packageToUpdateFrom.getParentPackage();
            }
            return addedOk;
        }

        private Object getTreeElementToUpdateFrom(PsiPackage packageToUpdateFrom, Module module) {
            if (packageToUpdateFrom == null || !packageToUpdateFrom.isValid() || "".equals(packageToUpdateFrom.getQualifiedName())) {
                return module == null ? PackageViewPane.this.myTreeStructure.getRootElement() : module;
            }
            return new PackageElement(module, packageToUpdateFrom, false);
        }

        private Module[] getModulesFor(PsiDirectory dir) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)PackageViewPane.this.myProject).getFileIndex();
            VirtualFile vFile = dir.getVirtualFile();
            HashSet<Module> modules = new HashSet<Module>();
            Module module = fileIndex.getModuleForFile(vFile);
            if (module != null) {
                modules.add(module);
            }
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return Module.EMPTY_ARRAY;
                }
                for (OrderEntry entry : orderEntries) {
                    modules.add(entry.getOwnerModule());
                }
            }
            return modules.toArray(new Module[modules.size()]);
        }
    }

    private final class ShowLibraryContentsAction
    extends ToggleAction {
        private ShowLibraryContentsAction() {
            super(IdeBundle.message((String)"action.show.libraries.contents", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.library.contents", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowLibraryContents);
        }

        public boolean isSelected(AnActionEvent event) {
            return ProjectView.getInstance(PackageViewPane.this.myProject).isShowLibraryContents(PackageViewPane.this.getId());
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(PackageViewPane.this.myProject);
            projectView.setShowLibraryContents(flag, PackageViewPane.this.getId());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance(PackageViewPane.this.myProject);
            presentation.setVisible(projectView.getCurrentProjectViewPane() == PackageViewPane.this);
        }
    }
}

