/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class UnmarkGeneratedSourceRootAction
extends MarkRootActionBase {
    public UnmarkGeneratedSourceRootAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.setText("Unmark Generated Sources Root");
        presentation.setDescription("Mark directory as an ordinary source root");
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "isEnabled"));
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)root.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties == null || !properties.isForGeneratedSources()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void modifyRoots(VirtualFile vFile, ContentEntry entry) {
        entry.addSourceFolder(vFile, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
    }
}

