/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkSourceRootAction
extends MarkRootActionBase {
    private final JpsModuleSourceRootType<?> myRootType;

    public MarkSourceRootAction(@NotNull JpsModuleSourceRootType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "<init>"));
        }
        this.myRootType = type;
        Presentation presentation = this.getTemplatePresentation();
        ModuleSourceRootEditHandler<?> editHandler = ModuleSourceRootEditHandler.getEditHandler(type);
        presentation.setIcon(editHandler.getRootIcon());
        presentation.setText(editHandler.getRootTypeName() + " Root");
        presentation.setDescription(ProjectBundle.message((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getRootTypeName()}));
    }

    @Override
    protected void modifyRoots(VirtualFile vFile, ContentEntry entry) {
        entry.addSourceFolder(vFile, this.myRootType);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/actions/MarkSourceRootAction", "isEnabled"));
        }
        if (!ModuleType.get((Module)module).isSupportedRootType(this.myRootType) || selection.myHaveSelectedFilesUnderSourceRoots) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            if (this.myRootType.equals((Object)root.getRootType())) continue;
            return true;
        }
        return false;
    }
}

