/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module == null || vFiles == null) {
            return;
        }
        final ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (VirtualFile vFile : vFiles) {
            SourceFolder[] sourceFolders;
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, vFile);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
                if (!Comparing.equal((Object)sourceFolder.getFile(), (Object)vFile)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(vFile, entry);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                model.commit();
            }
        });
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/projectView/actions/MarkRootActionBase", "findContentEntry"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/projectView/actions/MarkRootActionBase", "findContentEntry"));
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        boolean enabled = module != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && this.isEnabled(selection, module);
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module == null || files == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (VirtualFile file : files) {
            SourceFolder folder;
            if (!file.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            if (!fileIndex.isInContent(file)) {
                return RootsSelection.EMPTY;
            }
            if (Comparing.equal((Object)fileIndex.getSourceRootForFile(file), (Object)file) && (folder = ProjectRootsUtil.findSourceFolder(module, file)) != null) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file);
            if (!fileIndex.isInSourceContent(file)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    protected static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection();
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        protected RootsSelection() {
        }
    }
}

