/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;

public abstract class PluginTableModel
extends AbstractTableModel
implements SortableColumnModel {
    protected static final String NAME = "Name";
    protected ColumnInfo[] columns;
    protected List<IdeaPluginDescriptor> view;
    private RowSorter.SortKey myDefaultSortKey;
    protected final List<IdeaPluginDescriptor> filtered = new ArrayList<IdeaPluginDescriptor>();
    private boolean mySortByStatus;
    private boolean mySortByRating;
    private boolean mySortByDownloads;
    private boolean mySortByUpdated;

    protected PluginTableModel() {
    }

    public PluginTableModel(ColumnInfo ... columns) {
        this.columns = columns;
    }

    public void setSortKey(RowSorter.SortKey sortKey) {
        this.myDefaultSortKey = sortKey;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.columns;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column].getName();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return this.view.get(row);
    }

    public Object getRowValue(int row) {
        return this.getObjectAt(row);
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.myDefaultSortKey;
    }

    @Override
    public int getRowCount() {
        return this.view.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].valueOf((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].isCellEditable((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns[columnIndex].setValue((Object)this.getObjectAt(rowIndex), aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public ArrayList<IdeaPluginDescriptorImpl> dependent(IdeaPluginDescriptorImpl plugin) {
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        block0: for (IdeaPluginDescriptor any : this.getAllPlugins()) {
            PluginId[] dep;
            if (!(any instanceof IdeaPluginDescriptorImpl)) continue;
            for (PluginId id : dep = any.getDependentPluginIds()) {
                if (id != plugin.getPluginId()) continue;
                list.add((IdeaPluginDescriptorImpl)any);
                continue block0;
            }
        }
        return list;
    }

    public abstract void updatePluginsList(List<IdeaPluginDescriptor> var1);

    public void filter(List<IdeaPluginDescriptor> filtered) {
        this.fireTableDataChanged();
    }

    protected void filter(String filter) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set search = optionsRegistrar.getProcessedWords(filter);
        ArrayList<IdeaPluginDescriptor> desc = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<IdeaPluginDescriptor> toProcess = this.toProcess();
        for (IdeaPluginDescriptor descriptor : this.filtered) {
            if (toProcess.contains(descriptor)) continue;
            toProcess.add(descriptor);
        }
        this.filtered.clear();
        for (IdeaPluginDescriptor descriptor : toProcess) {
            if (this.isPluginDescriptorAccepted(descriptor) && PluginManagerMain.isAccepted(filter, search, descriptor)) {
                desc.add(descriptor);
                continue;
            }
            this.filtered.add(descriptor);
        }
        this.filter(desc);
    }

    protected ArrayList<IdeaPluginDescriptor> toProcess() {
        return new ArrayList<IdeaPluginDescriptor>(this.view);
    }

    public abstract int getNameColumn();

    public abstract boolean isPluginDescriptorAccepted(IdeaPluginDescriptor var1);

    public void sort() {
        Collections.sort(this.view, this.columns[this.getNameColumn()].getComparator());
        this.fireTableDataChanged();
    }

    public boolean isSortByStatus() {
        return this.mySortByStatus;
    }

    public void setSortByStatus(boolean sortByStatus) {
        this.mySortByStatus = sortByStatus;
    }

    public boolean isSortByRating() {
        return this.mySortByRating;
    }

    public void setSortByRating(boolean sortByRating) {
        this.mySortByRating = sortByRating;
    }

    public boolean isSortByDownloads() {
        return this.mySortByDownloads;
    }

    public void setSortByDownloads(boolean sortByDownloads) {
        this.mySortByDownloads = sortByDownloads;
    }

    public boolean isSortByUpdated() {
        return this.mySortByUpdated;
    }

    public void setSortByUpdated(boolean sortByUpdated) {
        this.mySortByUpdated = sortByUpdated;
    }

    public List<IdeaPluginDescriptor> getAllPlugins() {
        ArrayList<IdeaPluginDescriptor> list = new ArrayList<IdeaPluginDescriptor>();
        list.addAll(this.view);
        list.addAll(this.filtered);
        return list;
    }
}

