/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.PluginDescriptorComparator;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    @NonNls
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    @NonNls
    public static final String CORE_PLUGIN_ID = "com.intellij";
    @NonNls
    public static final String META_INF = "META-INF";
    @NonNls
    public static final String PLUGIN_XML = "plugin.xml";
    public static final float PLUGINS_PROGRESS_MAX_VALUE = 0.3f;
    static final Map<PluginId, Integer> ourId2Index = new THashMap();
    @NonNls
    static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins = new HashMap<String, IdeaPluginDescriptorImpl>();
    static final PluginClassCache ourPluginClasses = new PluginClassCache();
    @NonNls
    static final String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
    static final String DISABLE = "disable";
    static final String ENABLE = "enable";
    static final String EDIT = "edit";
    @NonNls
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    static List<String> ourDisabledPlugins = null;
    static MultiMap<String, String> ourBrokenPluginVersions = null;
    static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    public static String BUILD_NUMBER;
    private static BuildNumber ourBuildNumber;

    public static synchronized IdeaPluginDescriptor[] getPlugins() {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(null);
        }
        return ourPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(String configPath, Collection<String> disabledPlugins) {
        File file = new File(configPath, DISABLED_PLUGINS_FILENAME);
        if (file.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                try {
                    String id;
                    while ((id = reader.readLine()) != null) {
                        disabledPlugins.add(id.trim());
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list = ourDisabledPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerCore", "getDisabledPlugins"));
        }
        return list;
    }

    public static boolean isBrokenPlugin(IdeaPluginDescriptor descriptor) {
        return PluginManagerCore.getBrokenPluginVersions().get((Object)descriptor.getPluginId().getIdString()).contains(descriptor.getVersion());
    }

    public static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse((String)s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = (String)tokens.get(0);
                        List versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues((Object)pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream((Closeable)br);
                }
            }
        }
        return ourBrokenPluginVersions;
    }

    static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePluginsList(Collection<String> ids, boolean append, File plugins) throws IOException {
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(plugins, append)));
        try {
            for (String id : ids) {
                printWriter.println(id);
            }
            printWriter.flush();
        }
        finally {
            printWriter.close();
        }
    }

    public static boolean disablePlugin(String id) {
        if (PluginManagerCore.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManagerCore.getDisabledPlugins().add(id);
        try {
            PluginManagerCore.saveDisabledPlugins(PluginManagerCore.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean enablePlugin(String id) {
        if (!PluginManagerCore.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManagerCore.getDisabledPlugins().remove(id);
        try {
            PluginManagerCore.saveDisabledPlugins(PluginManagerCore.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void saveDisabledPlugins(Collection<String> ids, boolean append) throws IOException {
        File plugins = new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, append, plugins);
        ourDisabledPlugins = null;
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static int getPluginLoadingOrder(PluginId id) {
        return ourId2Index.get(id);
    }

    public static boolean isModuleDependency(PluginId dependentPluginId) {
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    public static void checkDependants(IdeaPluginDescriptor pluginDescriptor, Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, Condition<PluginId> check) {
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check, new HashSet<PluginId>());
    }

    private static boolean checkDependants(IdeaPluginDescriptor pluginDescriptor, Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, Condition<PluginId> check, Set<PluginId> processed) {
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        HashSet<PluginId> optionalDependencies = new HashSet<PluginId>(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value((Object)dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = (IdeaPluginDescriptor)pluginId2Descriptor.fun((Object)dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(@NotNull String className, PluginId pluginId, boolean loaded) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore", "addPluginClass"));
        }
        ourPluginClasses.addPluginClass(className, pluginId, loaded);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore", "getPluginByClassName"));
        }
        return ourPluginClasses.getPluginByClassName(className);
    }

    public static void dumpPluginClassStatistics() {
        ourPluginClasses.dumpPluginClassStatistics();
    }

    static boolean isDependent(IdeaPluginDescriptor descriptor, PluginId on, Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (ArrayUtil.contains((Object)id, (Object[])descriptor.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    static boolean hasModuleDependencies(IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    static void configureExtensions() {
        Extensions.setLogProvider((LogProvider)new IdeaLogProvider());
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        Extensions.registerAreaClass((String)"IDEA_MODULE", (String)"IDEA_PROJECT");
    }

    static Method getAddUrlMethod(ClassLoader loader) throws NoSuchMethodException {
        if (loader instanceof URLClassLoader) {
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
            return addUrlMethod;
        }
        return loader.getClass().getDeclaredMethod("addURL", URL.class);
    }

    @Nullable
    static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (parentLoaders == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/plugins/PluginManagerCore", "createPluginClassLoader"));
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file.toURI().toURL());
                }
                return loader;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file = aClassPath.getCanonicalFile();
                urls.add(file.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    public static boolean isPluginClass(String className) {
        return ourPlugins != null && PluginManagerCore.getPluginByClassName(className) != null;
    }

    static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, (String)", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, (String)", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, (String)", "));
        }
    }

    static ClassLoader[] getParentLoaders(Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, PluginId[] pluginIds) {
        if (PluginManagerCore.isUnitTestMode()) {
            return new ClassLoader[0];
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            classLoaders.add(loader);
        }
        return classLoaders.toArray(new ClassLoader[classLoaders.size()]);
    }

    static int countPlugins(String pluginsPath) {
        String[] list;
        File configuredPluginsDir = new File(pluginsPath);
        if (configuredPluginsDir.exists() && (list = configuredPluginsDir.list()) != null) {
            return list.length;
        }
        return 0;
    }

    static Collection<URL> getClassLoaderUrls() {
        ClassLoader classLoader = PluginManagerCore.class.getClassLoader();
        Class<?> aClass = classLoader.getClass();
        try {
            List urls = (List)aClass.getMethod("getUrls", new Class[0]).invoke((Object)classLoader, new Object[0]);
            return urls;
        }
        catch (IllegalAccessException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (classLoader instanceof URLClassLoader) {
            return Arrays.asList(((URLClassLoader)classLoader).getURLs());
        }
        return Collections.emptyList();
    }

    static void prepareLoadingPluginsErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId((String)entry.getKey()), entry.getValue());
        }
    }

    static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap);
        DFSTBuilder builder = new DFSTBuilder(graph);
        final Comparator idComparator = builder.comparator();
        return new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return idComparator.compare(o1.getPluginId(), o2.getPluginId());
            }
        };
    }

    private static Graph<PluginId> createPluginIdGraph(final Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        Collections.sort(ids, new Comparator<PluginId>(){

            @Override
            public int compare(PluginId o1, PluginId o2) {
                return o2.getIdString().compareTo(o1.getIdString());
            }
        });
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<PluginId>(){

            public Collection<PluginId> getNodes() {
                return ids;
            }

            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    if (!idToDescriptorMap.containsKey(dependentPluginId)) continue;
                    plugins.add(dependentPluginId);
                }
                return plugins.iterator();
            }
        }));
    }

    static IdeaPluginDescriptorImpl[] findCorePlugin(IdeaPluginDescriptorImpl[] pluginDescriptors) {
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            if (!CORE_PLUGIN_ID.equals(descriptor.getPluginId().getIdString())) continue;
            return new IdeaPluginDescriptorImpl[]{descriptor};
        }
        return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromDir(File file, @NonNls String fileName) {
        IdeaPluginDescriptorImpl descriptor = null;
        File descriptorFile = new File(file, META_INF + File.separator + fileName);
        if (descriptorFile.exists()) {
            descriptor = new IdeaPluginDescriptorImpl(file);
            try {
                descriptor.readExternal(descriptorFile.toURI().toURL());
            }
            catch (Exception e) {
                System.err.println("Cannot load: " + descriptorFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromJar(File file, @NonNls String fileName) {
        try {
            URI fileURL = file.toURI();
            URL jarURL = new URL("jar:" + StringUtil.replace((String)fileURL.toASCIIString(), (String)"!", (String)"%21") + "!/META-INF/" + fileName);
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file);
            FileInputStream in = new FileInputStream(file);
            ZipInputStream zipStream = new ZipInputStream(in);
            try {
                ZipEntry entry = zipStream.getNextEntry();
                if (entry.getName().equals("META-INF/jb/$$size$$") && (entry = zipStream.getNextEntry()).getName().equals("META-INF/" + fileName)) {
                    byte[] content = FileUtil.loadBytes((InputStream)zipStream, (int)((int)entry.getSize()));
                    Document document = JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(content));
                    descriptor.readExternal(document, jarURL);
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
                    return ideaPluginDescriptorImpl;
                }
            }
            finally {
                zipStream.close();
                in.close();
            }
            descriptor.readExternal(jarURL);
            return descriptor;
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, (Throwable)e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage("Plugin file " + file.getName() + " contains invalid plugin descriptor file.");
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromJar(File file) {
        return PluginManagerCore.loadDescriptorFromJar(file, PLUGIN_XML);
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(final File file, @NonNls String fileName) {
        IdeaPluginDescriptorImpl descriptor = null;
        if (file.isDirectory()) {
            descriptor = PluginManagerCore.loadDescriptorFromDir(file, fileName);
            if (descriptor == null) {
                File libDir = new File(file, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o2.getName().startsWith(file.getName())) {
                            return Integer.MAX_VALUE;
                        }
                        if (o1.getName().startsWith(file.getName())) {
                            return -2147483647;
                        }
                        if (o2.getName().startsWith("resources")) {
                            return -2147483647;
                        }
                        if (o1.getName().startsWith("resources")) {
                            return Integer.MAX_VALUE;
                        }
                        return 0;
                    }
                });
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip((File)f)) {
                        descriptor = PluginManagerCore.loadDescriptorFromJar(f, fileName);
                        if (descriptor == null) continue;
                        descriptor.setPath(file);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, fileName)) == null) continue;
                    if (descriptor != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                    descriptor.setPath(file);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".jar") && file.exists()) {
            descriptor = PluginManagerCore.loadDescriptorFromJar(file, fileName);
        }
        if (descriptor != null && !descriptor.getOptionalConfigs().isEmpty()) {
            HashMap<PluginId, IdeaPluginDescriptorImpl> descriptors = new HashMap<PluginId, IdeaPluginDescriptorImpl>(descriptor.getOptionalConfigs().size());
            for (Map.Entry<PluginId, String> entry : descriptor.getOptionalConfigs().entrySet()) {
                String optionalDescriptorName = entry.getValue();
                assert (!Comparing.equal((String)fileName, (String)optionalDescriptorName)) : "recursive dependency: " + fileName;
                IdeaPluginDescriptorImpl optionalDescriptor = PluginManagerCore.loadDescriptor(file, optionalDescriptorName);
                if (optionalDescriptor == null && !FileUtil.isJarOrZip((File)file)) {
                    for (URL url : PluginManagerCore.getClassLoaderUrls()) {
                        if ("file".equals(url.getProtocol()) && (optionalDescriptor = PluginManagerCore.loadDescriptor(new File(PluginManagerCore.decodeUrl(url.getFile())), optionalDescriptorName)) != null) break;
                    }
                }
                if (optionalDescriptor != null) {
                    descriptors.put(entry.getKey(), optionalDescriptor);
                    continue;
                }
                PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
            }
            descriptor.setOptionalDescriptors(descriptors);
        }
        return descriptor;
    }

    public static void loadDescriptors(String pluginsPath, List<IdeaPluginDescriptorImpl> result, @Nullable StartupProgress progress, int pluginsCount) {
        File pluginsHome = new File(pluginsPath);
        File[] files = pluginsHome.listFiles();
        if (files != null) {
            int i = result.size();
            for (File file : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file, PLUGIN_XML);
                if (descriptor == null) continue;
                if (progress != null) {
                    progress.showProgress(descriptor.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                if ((oldIndex = result.indexOf(descriptor)) >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result.get(oldIndex);
                    if (StringUtil.compareVersionNumbers((String)oldDescriptor.getVersion(), (String)descriptor.getVersion()) >= 0) continue;
                    result.set(oldIndex, descriptor);
                    continue;
                }
                result.add(descriptor);
            }
        }
    }

    @Nullable
    static String filterBadPlugins(List<? extends IdeaPluginDescriptor> result, final Map<String, String> disabledPluginNames) {
        final HashMap<PluginId, IdeaPluginDescriptor> idToDescriptorMap = new HashMap<PluginId, IdeaPluginDescriptor>();
        final StringBuffer message = new StringBuffer();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
            }
            if (idToDescriptorMap.containsKey(id)) {
                message.append("<br>");
                message.append(IdeBundle.message((String)"message.duplicate.plugin.id", (Object[])new Object[0]));
                message.append(id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        final ArrayList<String> disabledPluginIds = new ArrayList<String>();
        final LinkedHashSet faultyDescriptors = new LinkedHashSet();
        final Iterator<? extends IdeaPluginDescriptor> it2 = result.iterator();
        while (it2.hasNext()) {
            final IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, new Function<PluginId, IdeaPluginDescriptor>(){

                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                }
            }, new Condition<PluginId>(){

                public boolean value(PluginId pluginId) {
                    if (!idToDescriptorMap.containsKey(pluginId)) {
                        pluginDescriptor.setEnabled(false);
                        if (!pluginId.getIdString().startsWith(PluginManagerCore.MODULE_DEPENDENCY_PREFIX)) {
                            String pluginName;
                            faultyDescriptors.add(pluginId.getIdString());
                            disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                            message.append("<br>");
                            String name = pluginDescriptor.getName();
                            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                            if (descriptor == null) {
                                pluginName = pluginId.getIdString();
                                if (disabledPluginNames.containsKey(pluginName)) {
                                    pluginName = (String)disabledPluginNames.get(pluginName);
                                }
                            } else {
                                pluginName = descriptor.getName();
                            }
                            message.append(PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString()) ? IdeBundle.message((String)"error.required.plugin.disabled", (Object[])new Object[]{name, pluginName}) : IdeBundle.message((String)"error.required.plugin.not.installed", (Object[])new Object[]{name, pluginName}));
                        }
                        it2.remove();
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            message.append("<br>");
            message.append("<br>").append("<a href=\"disable\">Disable ");
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)((String)disabledPluginIds.iterator().next()));
                message.append(idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                message.append("not loaded plugins");
            }
            message.append("</a>");
            boolean possibleToEnable = true;
            for (String descriptor : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                message.append("<br>").append("<a href=\"enable\">Enable ").append(faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins").append("</a>");
            }
            message.append("<br>").append("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            message.append("<br>");
            message.append(IdeBundle.message((String)"error.plugins.without.id.found", (Object[])new Object[0]));
        }
        if (message.length() > 0) {
            message.insert(0, IdeBundle.message((String)"error.problems.found.loading.plugins", (Object[])new Object[0]));
            return message.toString();
        }
        return null;
    }

    static void loadDescriptorsFromClassPath(@NotNull List<IdeaPluginDescriptorImpl> result, @Nullable StartupProgress progress) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore", "loadDescriptorsFromClassPath"));
        }
        Collection<URL> urls = PluginManagerCore.getClassLoaderUrls();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        int i = 0;
        for (URL url : urls) {
            ++i;
            if (!"file".equals(url.getProtocol())) continue;
            File file = new File(PluginManagerCore.decodeUrl(url.getFile()));
            IdeaPluginDescriptorImpl platformPluginDescriptor = null;
            if (platformPrefix != null && (platformPluginDescriptor = PluginManagerCore.loadDescriptor(file, platformPrefix + "Plugin.xml")) != null && !result.contains(platformPluginDescriptor)) {
                platformPluginDescriptor.setUseCoreClassLoader(true);
                result.add(platformPluginDescriptor);
            }
            IdeaPluginDescriptorImpl pluginDescriptor = PluginManagerCore.loadDescriptor(file, PLUGIN_XML);
            if (platformPrefix != null && pluginDescriptor != null && pluginDescriptor.getName().equals(SPECIAL_IDEA_PLUGIN) || pluginDescriptor == null || result.contains(pluginDescriptor)) continue;
            if (platformPluginDescriptor != null) {
                pluginDescriptor.setUseCoreClassLoader(true);
            }
            result.add(pluginDescriptor);
            if (progress == null) continue;
            progress.showProgress("Plugin loaded: " + pluginDescriptor.getName(), 0.3f * ((float)i / (float)urls.size()));
        }
    }

    private static String decodeUrl(String file) {
        String quotePluses = StringUtil.replace((String)file, (String)"+", (String)"%2B");
        return URLDecoder.decode(quotePluses);
    }

    static void loadDescriptorsFromProperty(List<IdeaPluginDescriptorImpl> result) {
        String pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH);
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), PLUGIN_XML);
            if (ideaPluginDescriptor == null) continue;
            result.add(ideaPluginDescriptor);
        }
    }

    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress) {
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(PathManager.getPluginsPath(), result, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result.size();
            PluginManagerCore.loadDescriptors(PathManager.getPreInstalledPluginsPath(), result, progress, pluginsCount);
            fromSources = size == result.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result);
        PluginManagerCore.loadDescriptorsFromClassPath(result, (StartupProgress)(fromSources ? progress : null));
        IdeaPluginDescriptor[] pluginDescriptors = result.toArray(new IdeaPluginDescriptorImpl[result.size()]);
        try {
            Arrays.sort(pluginDescriptors, new PluginDescriptorComparator(pluginDescriptors));
        }
        catch (Exception e) {
            PluginManagerCore.prepareLoadingPluginsErrorMessage(IdeBundle.message((String)"error.plugins.were.not.loaded", (Object[])new Object[]{e.getMessage()}));
            PluginManagerCore.getLogger().info((Throwable)e);
            return PluginManagerCore.findCorePlugin((IdeaPluginDescriptorImpl[])pluginDescriptors);
        }
        return pluginDescriptors;
    }

    static void mergeOptionalConfigs(Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        HashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsWithModules = new HashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors);
        PluginManagerCore.addModulesAsDependents(descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, IdeaPluginDescriptorImpl> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                descriptor.mergeOptionalConfig(entry.getValue());
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor) {
        if (parentLoader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/PluginManagerCore", "initClassLoader"));
        }
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        if (ourBuildNumber == null && (ourBuildNumber = BuildNumber.fromString((String)System.getProperty("idea.plugins.compatible.build"))) == null) {
            BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString((String)BUILD_NUMBER);
            if (ourBuildNumber == null) {
                ourBuildNumber = BuildNumber.fallback();
            }
        }
        return ourBuildNumber;
    }

    static boolean shouldSkipPlugin(IdeaPluginDescriptor descriptor, IdeaPluginDescriptor[] loaded) {
        boolean shouldLoad;
        boolean checkModuleDependencies;
        String idString = descriptor.getPluginId().getIdString();
        if (CORE_PLUGIN_ID.equals(idString)) {
            return false;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !descriptor.isEnabled()) {
                return true;
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return true;
            }
        }
        List pluginIds = pluginId == null ? null : StringUtil.split((String)pluginId, (String)",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            return true;
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            shouldLoad = loadPluginCategory.equals(descriptor.getCategory());
        } else {
            if (pluginIds != null) {
                shouldLoad = pluginIds.contains(idString);
                if (!shouldLoad) {
                    HashMap<PluginId, IdeaPluginDescriptor> map = new HashMap<PluginId, IdeaPluginDescriptor>();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents(map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId((String)id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor.getPluginId(), map, checkModuleDependencies)) continue;
                        shouldLoad = true;
                        break;
                    }
                }
            } else {
                boolean bl2 = shouldLoad = !PluginManagerCore.getDisabledPlugins().contains(idString);
            }
            if (shouldLoad && descriptor instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor)) {
                return true;
            }
        }
        return !shouldLoad;
    }

    public static boolean isIncompatible(IdeaPluginDescriptor descriptor) {
        try {
            BuildNumber untilBuild;
            BuildNumber sinceBuild;
            BuildNumber buildNumber = PluginManagerCore.getBuildNumber();
            if (!StringUtil.isEmpty((String)descriptor.getSinceBuild()) && (sinceBuild = BuildNumber.fromString((String)descriptor.getSinceBuild(), (String)descriptor.getName())).compareTo(buildNumber) > 0) {
                return true;
            }
            if (!StringUtil.isEmpty((String)descriptor.getUntilBuild()) && !buildNumber.isSnapshot() && (untilBuild = BuildNumber.fromString((String)descriptor.getUntilBuild(), (String)descriptor.getName())).compareTo(buildNumber) < 0) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static boolean shouldSkipPlugin(IdeaPluginDescriptor descriptor) {
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result = PluginManagerCore.shouldSkipPlugin(descriptor, ourPlugins) || PluginManagerCore.isBrokenPlugin(descriptor);
            descriptorImpl.setSkipped(result);
            return result;
        }
        return PluginManagerCore.shouldSkipPlugin(descriptor, ourPlugins) || PluginManagerCore.isBrokenPlugin(descriptor);
    }

    /*
     * WARNING - void declaration
     */
    static void initializePlugins(@Nullable StartupProgress progress) {
        void var10_17;
        PluginManagerCore.configureExtensions();
        IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress);
        Class callerClass = ReflectionUtil.findCallerClass((int)1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result = new ArrayList<IdeaPluginDescriptorImpl>();
        HashMap<String, String> disabledPluginNames = new HashMap<String, String>();
        ArrayList<String> brokenPluginsList = new ArrayList<String>();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : pluginDescriptors) {
            boolean skipped = PluginManagerCore.shouldSkipPlugin(ideaPluginDescriptorImpl, pluginDescriptors);
            if (!skipped && PluginManagerCore.isBrokenPlugin(ideaPluginDescriptorImpl)) {
                brokenPluginsList.add(ideaPluginDescriptorImpl.getName());
                skipped = true;
            }
            if (!skipped) {
                List<String> modules = ideaPluginDescriptorImpl.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module)) continue;
                        ourModulesToContainingPlugins.put(module, ideaPluginDescriptorImpl);
                    }
                }
                result.add(ideaPluginDescriptorImpl);
                continue;
            }
            ideaPluginDescriptorImpl.setEnabled(false);
            disabledPluginNames.put(ideaPluginDescriptorImpl.getPluginId().getIdString(), ideaPluginDescriptorImpl.getName());
            PluginManagerCore.initClassLoader(parentLoader, ideaPluginDescriptorImpl);
        }
        String errorMessage = PluginManagerCore.filterBadPlugins(result, disabledPluginNames);
        if (!brokenPluginsList.isEmpty()) {
            errorMessage = "Following plugins are incompatible with current IDE build: " + StringUtil.join(brokenPluginsList, (String)", ") + "<br>\n" + StringUtil.notNullize((String)errorMessage);
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errorMessage);
        HashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result) {
            idToDescriptorMap.put(ideaPluginDescriptorImpl.getPluginId(), ideaPluginDescriptorImpl);
        }
        IdeaPluginDescriptor corePluginDescriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(PluginId.getId((String)CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor : result) {
            if (descriptor == corePluginDescriptor) continue;
            descriptor.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
        Collections.sort(result, PluginManagerCore.getPluginDescriptorComparator(idToDescriptorMap));
        boolean bl = false;
        while (var10_17 < result.size()) {
            ourId2Index.put(((IdeaPluginDescriptorImpl)result.get((int)var10_17)).getPluginId(), (int)var10_17);
            ++var10_17;
        }
        boolean bl2 = false;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result) {
            void var10_19;
            if (pluginDescriptor.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders(idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)(++var10_19) / (float)result.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension((Object)new AreaListener(){

            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore$7", "areaCreated"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/PluginManagerCore$7", "areaCreated"));
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea((AreaInstance)areaInstance), result);
            }

            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/PluginManagerCore$7", "areaDisposing"));
                }
                if (areaInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/PluginManagerCore$7", "areaDisposing"));
                }
            }
        });
        ourPlugins = pluginDescriptors;
    }

    private static void registerExtensionPointsAndExtensions(ExtensionsArea area, List<IdeaPluginDescriptorImpl> loadedPlugins) {
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        HashSet epNames = ContainerUtil.newHashSet();
        for (ExtensionPoint point : area.getExtensionPoints()) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }

    public static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    static {
        myPluginError = null;
        myPlugins2Disable = null;
        myPlugins2Enable = null;
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        public void error(String message, Throwable t) {
            PluginManagerCore.getLogger().error(message, t);
        }

        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }

        public void warn(String message, Throwable t) {
            PluginManagerCore.getLogger().info(message, t);
        }

        public void warn(Throwable t) {
            PluginManagerCore.getLogger().info(t);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }
}

