/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.AvailablePluginColumnInfo;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public class AvailablePluginsTableModel
extends PluginTableModel {
    public static final String ALL = "All";
    private String myCategory = "All";
    private TreeSet<String> myAvailableCategories = new TreeSet();
    protected static final String STATUS = "Status";
    public static final String JETBRAINS_REPO = "JetBrains";
    private String myRepository = "All";
    private String myVendor = null;

    public AvailablePluginsTableModel() {
        this.columns = new ColumnInfo[]{new AvailablePluginColumnInfo(this)};
        this.setSortKey(new RowSorter.SortKey(this.getNameColumn(), SortOrder.ASCENDING));
        this.view = new ArrayList();
    }

    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category, String filter) {
        this.myCategory = category;
        this.filter(filter);
    }

    public void setRepository(String repository, String filter) {
        this.myRepository = repository;
        this.filter(filter);
    }

    public void setVendor(String vendor) {
        this.myVendor = vendor;
        this.filter("");
    }

    @Override
    public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
        String vendor;
        String category = descriptor.getCategory();
        if (category != null && !ALL.equals(this.myCategory) && !category.equals(this.myCategory)) {
            return false;
        }
        if (!(this.myVendor == null || (vendor = descriptor.getVendor()) != null && StringUtil.containsIgnoreCase((String)vendor, (String)this.myVendor))) {
            return false;
        }
        String repositoryName = ((PluginNode)descriptor).getRepositoryName();
        if (repositoryName != null) {
            return ALL.equals(this.myRepository) || repositoryName.equals(this.myRepository);
        }
        return ALL.equals(this.myRepository) || JETBRAINS_REPO.equals(this.myRepository);
    }

    public TreeSet<String> getAvailableCategories() {
        return this.myAvailableCategories;
    }

    public String getRepository() {
        return this.myRepository;
    }

    private static void updateStatus(IdeaPluginDescriptor descr) {
        if (descr instanceof PluginNode) {
            PluginNode node = (PluginNode)descr;
            IdeaPluginDescriptor existing = PluginManager.getPlugin(descr.getPluginId());
            if (existing != null) {
                node.setStatus(1);
                node.setInstalledVersion(existing.getVersion());
            }
        }
    }

    @Override
    public void updatePluginsList(List<IdeaPluginDescriptor> list) {
        this.view.clear();
        this.myAvailableCategories.clear();
        this.filtered.clear();
        for (IdeaPluginDescriptor descr : list) {
            AvailablePluginsTableModel.updateStatus(descr);
            this.view.add(descr);
            String category = descr.getCategory();
            if (category != null) {
                this.myAvailableCategories.add(category);
                continue;
            }
            this.myAvailableCategories.add("N/A");
        }
        this.fireTableDataChanged();
    }

    @Override
    public void filter(List<IdeaPluginDescriptor> filtered) {
        this.view.clear();
        for (IdeaPluginDescriptor descriptor : filtered) {
            this.view.add(descriptor);
        }
        super.filter(filtered);
    }

    @Override
    public int getNameColumn() {
        return 0;
    }
}

