/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.ui;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.Nullable;

public class PasswordSafePromptDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)PasswordSafePromptDialog.class.getName());
    private JPasswordField myPasswordField;
    private JCheckBox myRememberPasswordCheckBox;
    private JPanel myRootPanel;
    private JLabel myMessageLabel;
    private JLabel myPromptLabel;

    private PasswordSafePromptDialog(Project project, PasswordSafeImpl passwordSafe, String title, String message) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.myMessageLabel.setText(message);
        switch (passwordSafe.getSettings().getProviderType()) {
            case MASTER_PASSWORD: {
                this.myRememberPasswordCheckBox.setEnabled(true);
                this.myRememberPasswordCheckBox.setSelected(true);
                this.myRememberPasswordCheckBox.setToolTipText("The password will be stored between application sessions.");
                break;
            }
            case MEMORY_ONLY: {
                this.myRememberPasswordCheckBox.setEnabled(true);
                this.myRememberPasswordCheckBox.setSelected(true);
                this.myRememberPasswordCheckBox.setToolTipText("The password will be stored only during this application session.");
                break;
            }
            case DO_NOT_STORE: {
                this.myRememberPasswordCheckBox.setEnabled(false);
                this.myRememberPasswordCheckBox.setSelected(false);
                this.myRememberPasswordCheckBox.setToolTipText("The password storing is disabled.");
                break;
            }
            default: {
                LOG.error("Unknown policy type: " + (Object)((Object)passwordSafe.getSettings().getProviderType()));
            }
        }
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPasswordField;
    }

    @Nullable
    public static String askPassword(Project project, @Nullable ModalityState modalityState, String title, String message, Class<?> requester, String key, boolean resetPassword, String error) {
        return PasswordSafePromptDialog.askPassword(project, modalityState, title, message, requester, key, resetPassword, error, null, null);
    }

    @Nullable
    public static String askPassword(String title, String message, Class<?> requester, String key, boolean resetPassword) {
        return PasswordSafePromptDialog.askPassword(null, null, title, message, requester, key, resetPassword, null);
    }

    @Nullable
    public static String askPassphrase(Project project, @Nullable ModalityState modalityState, String title, String message, Class<?> requester, String key, boolean resetPassword, String error) {
        return PasswordSafePromptDialog.askPassword(project, modalityState, title, message, requester, key, resetPassword, error, "Passphrase:", "Remember the passphrase");
    }

    @Nullable
    private static String askPassword(final Project project, @Nullable ModalityState modalityState, final String title, final String message, Class<?> requester, String key, boolean resetPassword, final String error, final String promptLabel, final String checkboxLabel) {
        Object pw;
        PasswordSafeImpl ps;
        block5: {
            ps = (PasswordSafeImpl)PasswordSafe.getInstance();
            try {
                if (resetPassword) {
                    ps.removePassword(project, requester, key);
                } else {
                    pw = ps.getPassword(project, requester, key);
                    if (pw != null) {
                        return pw;
                    }
                }
            }
            catch (PasswordSafeException ex) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Failed to retrieve or reset password", (Throwable)ex);
            }
        }
        pw = new AtomicReference<Object>(null);
        ApplicationManager.getApplication().invokeAndWait(new Runnable((AtomicReference)pw, requester, key){
            final /* synthetic */ AtomicReference val$pw;
            final /* synthetic */ Class val$requester;
            final /* synthetic */ String val$key;
            {
                this.val$pw = atomicReference;
                this.val$requester = clazz;
                this.val$key = string6;
            }

            @Override
            public void run() {
                block8: {
                    PasswordSafePromptDialog d = new PasswordSafePromptDialog(project, ps, title, message);
                    if (promptLabel != null) {
                        d.myPromptLabel.setText(promptLabel);
                    }
                    if (checkboxLabel != null) {
                        d.myRememberPasswordCheckBox.setText(checkboxLabel);
                    }
                    d.init();
                    d.setErrorText(error);
                    d.show();
                    if (d.isOK()) {
                        String p = new String(d.myPasswordField.getPassword());
                        this.val$pw.set(p);
                        try {
                            if (d.myRememberPasswordCheckBox.isSelected()) {
                                ps.storePassword(project, this.val$requester, this.val$key, p);
                            } else if (!ps.getSettings().getProviderType().equals((Object)PasswordSafeSettings.ProviderType.DO_NOT_STORE)) {
                                ps.getMemoryProvider().storePassword(project, this.val$requester, this.val$key, p);
                            }
                        }
                        catch (PasswordSafeException e) {
                            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Failed to store password");
                            if (!LOG.isDebugEnabled()) break block8;
                            LOG.debug("Failed to store password", (Throwable)e);
                        }
                    }
                }
            }
        }, modalityState == null ? ModalityState.defaultModalityState() : modalityState);
        return (String)((AtomicReference)pw).get();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessageLabel = jLabel2 = new JLabel();
        jLabel2.setText("Message");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myPromptLabel = jLabel = new JLabel();
        jLabel.setText("Password:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRememberPasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remember the password");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

