/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ChangeMasterKeyDialog;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ResetPasswordDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterPasswordDialog
extends DialogWrapper {
    private static final int NUMBER_OF_RETRIES = 3;
    private static final int RESET_USER_CODE = 2;
    private static final int CHANGE_USER_CODE = 3;
    private JPasswordField myMasterPasswordPasswordField;
    private JPanel myPanel;
    private JCheckBox myEncryptMasterPasswordWithCheckBox;

    protected MasterPasswordDialog(@Nullable Project project, MasterKeyPasswordSafe safe) {
        super(project, false);
        this.$$$setupUI$$$();
        this.setTitle("Master Password");
        if (!safe.isOsProtectedPasswordSupported()) {
            this.myEncryptMasterPasswordWithCheckBox.setVisible(false);
        }
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "C&hange Password", 3), new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "&Reset Password", 2), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMasterPasswordPasswordField;
    }

    public static void askPassword(@Nullable Project project, MasterKeyPasswordSafe safe) throws PasswordSafeException {
        if (safe.setMasterPassword("")) {
            return;
        }
        String error = null;
        block6: for (int count = 0; count < 3; ++count) {
            MasterPasswordDialog d = new MasterPasswordDialog(project, safe);
            if (error != null) {
                d.setErrorText(error);
            }
            d.show();
            switch (d.getExitCode()) {
                case 0: {
                    String pw = new String(d.myMasterPasswordPasswordField.getPassword());
                    boolean rc = d.myEncryptMasterPasswordWithCheckBox.isSelected() ? safe.changeMasterPassword(pw, pw, true) : safe.setMasterPassword(pw);
                    if (rc) {
                        return;
                    }
                    error = "Invalid master password, please retry or reset.";
                    continue block6;
                }
                case 1: {
                    throw new MasterPasswordUnavailableException("The master password request were cancelled.");
                }
                case 3: {
                    if (!ChangeMasterKeyDialog.changePassword(project, safe)) {
                        throw new MasterPasswordUnavailableException("The master password request were cancelled.");
                    }
                    return;
                }
                case 2: {
                    if (!ResetPasswordDialog.resetPassword(project, safe)) {
                        throw new MasterPasswordUnavailableException("The master password request were cancelled.");
                    }
                    return;
                }
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Please enter master password for the password database");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Master Password:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMasterPasswordPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEncryptMasterPasswordWithCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Encrypt master password with user credentials");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setToolTipText("The master password will be stored in password database  encrypted with user credentials using OS-specific mechanisms. If this checkbox is selected, the master password will not be asked from user, on new session.");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

