/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.providers.BasePasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterPasswordDialog;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordDatabase;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ResetPasswordDialog;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.windows.WindowsCryptUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class MasterKeyPasswordSafe
extends BasePasswordSafeProvider {
    private static final String TEST_PASSWORD_KEY = "TEST_PASSWORD:";
    private static final String TEST_PASSWORD_VALUE = "test password";
    final PasswordDatabase database;
    private final transient AtomicReference<byte[]> key = new AtomicReference();

    public MasterKeyPasswordSafe(PasswordDatabase database) {
        this.database = database;
    }

    protected boolean isTestMode() {
        return false;
    }

    void resetMasterPassword(String password, boolean encrypt) {
        this.key.set(EncryptionUtil.genPasswordKey(password));
        this.database.clear();
        try {
            this.storePassword(null, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(password), TEST_PASSWORD_VALUE);
            if (encrypt) {
                this.database.setPasswordInfo(MasterKeyPasswordSafe.encryptPassword(password));
            } else {
                this.database.setPasswordInfo(new byte[0]);
            }
        }
        catch (PasswordSafeException e) {
            throw new IllegalStateException("There should be no problem with password at this point", e);
        }
    }

    boolean setMasterPassword(String password) {
        String rc;
        byte[] savedKey = this.key.get();
        this.key.set(EncryptionUtil.genPasswordKey(password));
        try {
            rc = this.getPassword(null, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(password));
        }
        catch (PasswordSafeException e) {
            throw new IllegalStateException("There should be no problem with password at this point", e);
        }
        if (!TEST_PASSWORD_VALUE.equals(rc)) {
            this.key.set(savedKey);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeMasterPassword(String oldPassword, String newPassword, boolean encrypt) {
        if (!this.setMasterPassword(oldPassword)) {
            return false;
        }
        byte[] oldKey = this.key.get();
        byte[] newKey = EncryptionUtil.genPasswordKey(newPassword);
        ByteArrayWrapper testKey = new ByteArrayWrapper(EncryptionUtil.dbKey(oldKey, MasterKeyPasswordSafe.class, MasterKeyPasswordSafe.testKey(oldPassword)));
        HashMap<ByteArrayWrapper, byte[]> oldDb = new HashMap<ByteArrayWrapper, byte[]>();
        this.database.copyTo(oldDb);
        HashMap<ByteArrayWrapper, byte[]> newDb = new HashMap<ByteArrayWrapper, byte[]>();
        for (Map.Entry<ByteArrayWrapper, byte[]> e : oldDb.entrySet()) {
            if (testKey.equals(e.getKey())) continue;
            byte[] decryptedKey = EncryptionUtil.decryptKey(oldKey, e.getKey().unwrap());
            String decryptedText = EncryptionUtil.decryptText(oldKey, e.getValue());
            newDb.put(new ByteArrayWrapper(EncryptionUtil.encryptKey(newKey, decryptedKey)), EncryptionUtil.encryptText(newKey, decryptedText));
        }
        Object object = this.database.getDbLock();
        synchronized (object) {
            this.resetMasterPassword(newPassword, encrypt);
            this.database.putAll(newDb);
        }
        return true;
    }

    private static String testKey(String password) {
        return TEST_PASSWORD_KEY + password;
    }

    @Override
    protected byte[] key(final @Nullable Project project) throws PasswordSafeException {
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (!this.isTestMode() && application.isHeadlessEnvironment()) {
            throw new MasterPasswordUnavailableException("The provider is not available in headless environment");
        }
        if (this.key.get() == null) {
            if (this.isPasswordEncrypted()) {
                try {
                    String s = MasterKeyPasswordSafe.decryptPassword(this.database.getPasswordInfo());
                    this.setMasterPassword(s);
                }
                catch (PasswordSafeException e) {
                    // empty catch block
                }
            }
            if (this.key.get() == null) {
                final Ref ex = new Ref();
                if (application.holdsReadLock()) {
                    throw new IllegalStateException("Access from read action is not allowed, because it might lead to a deadlock.");
                }
                application.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (MasterKeyPasswordSafe.this.key.get() == null) {
                            try {
                                if (MasterKeyPasswordSafe.this.isTestMode()) {
                                    throw new MasterPasswordUnavailableException("Master password must be specified in test mode.");
                                }
                                if (MasterKeyPasswordSafe.this.database.isEmpty()) {
                                    if (!ResetPasswordDialog.newPassword(project, MasterKeyPasswordSafe.this)) {
                                        throw new MasterPasswordUnavailableException("Master password is required to store passwords in the database.");
                                    }
                                } else {
                                    MasterPasswordDialog.askPassword(project, MasterKeyPasswordSafe.this);
                                }
                            }
                            catch (PasswordSafeException e) {
                                ex.set((Object)e);
                            }
                            catch (Exception e) {
                                ex.set((Object)new MasterPasswordUnavailableException("The problem with retrieving the password", e));
                            }
                        }
                    }
                }, ModalityState.defaultModalityState());
                if (ex.get() != null) {
                    throw (PasswordSafeException)ex.get();
                }
            }
        }
        return this.key.get();
    }

    @Override
    public String getPassword(@Nullable Project project, Class requester, String key) throws PasswordSafeException {
        if (this.database.isEmpty()) {
            return null;
        }
        return super.getPassword(project, requester, key);
    }

    @Override
    public void removePassword(@Nullable Project project, Class requester, String key) throws PasswordSafeException {
        if (this.database.isEmpty()) {
            return;
        }
        super.removePassword(project, requester, key);
    }

    @Override
    protected byte[] getEncryptedPassword(byte[] key) {
        return this.database.get(key);
    }

    @Override
    protected void removeEncryptedPassword(byte[] key) {
        this.database.remove(key);
    }

    @Override
    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        this.database.put(key, encryptedPassword);
    }

    @Override
    public boolean isSupported() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Override
    public String getDescription() {
        return "This provider stores passwords in IDEA config and uses master password to encrypt other passwords. The passwords for the same resources are shared between different projects.";
    }

    @Override
    public String getName() {
        return "Master Key PasswordSafe";
    }

    public boolean isOsProtectedPasswordSupported() {
        return SystemInfo.isWindows;
    }

    private static byte[] encryptPassword(String pw) throws MasterPasswordUnavailableException {
        assert (SystemInfo.isWindows);
        return WindowsCryptUtils.protect(EncryptionUtil.getUTF8Bytes(pw));
    }

    private static String decryptPassword(byte[] pw) throws MasterPasswordUnavailableException {
        assert (SystemInfo.isWindows);
        try {
            return new String(WindowsCryptUtils.unprotect(pw), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not available", e);
        }
    }

    public boolean isPasswordEncrypted() {
        byte[] i = this.database.getPasswordInfo();
        return i != null && i.length > 0;
    }

    public boolean isEmpty() {
        return this.database.isEmpty();
    }
}

