/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBListWithHintProvider;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NavBarPopup
extends LightweightHint
implements Disposable {
    private static final String JBLIST_KEY = "OriginalList";
    private static final String NAV_BAR_POPUP = "NAV_BAR_POPUP";
    private final NavBarPanel myPanel;
    private final int myIndex;
    private static final String DISPOSED_OBJECTS = "DISPOSED_OBJECTS";

    public NavBarPopup(NavBarPanel panel, Object[] siblings, final int selectedIndex) {
        super(NavBarPopup.createPopupContent(panel, siblings));
        this.myPanel = panel;
        this.myIndex = selectedIndex;
        this.setFocusRequestor(this.getComponent());
        this.setForceShowAsPopup(true);
        ListenerUtil.addMouseListener(this.getComponent(), new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.getComponent() != NavBarPopup.this.getList()) {
                    return;
                }
                if (!e.isConsumed() && e.isPopupTrigger()) {
                    NavBarPopup.this.myPanel.getModel().setSelectedIndex(selectedIndex);
                    IdeFocusManager.getInstance((Project)NavBarPopup.this.myPanel.getProject()).requestFocus((Component)NavBarPopup.this.myPanel, true);
                    NavBarPopup.this.myPanel.rightClick(selectedIndex);
                    e.consume();
                } else {
                    Object value = NavBarPopup.this.getList().getSelectedValue();
                    if (value != null) {
                        NavBarPopup.this.myPanel.navigateInsideBar(value);
                    }
                }
            }
        });
    }

    @Override
    protected void onPopupCancel() {
        Object o;
        JComponent component = this.getComponent();
        if (component != null && (o = component.getClientProperty(JBLIST_KEY)) instanceof JBListWithHintProvider) {
            ((JBListWithHintProvider)o).hideHint();
        }
        for (Disposable disposable : (List)this.getList().getClientProperty((Object)DISPOSED_OBJECTS)) {
            Disposer.dispose((Disposable)disposable);
        }
        Disposer.dispose((Disposable)this);
    }

    public void show(NavBarItem item) {
        this.show(item, true);
    }

    private void show(final NavBarItem item, boolean checkRepaint) {
        RelativePoint point = new RelativePoint((Component)((Object)item), new Point(0, item.getHeight()));
        Point p = point.getPoint((Component)this.myPanel);
        if (p.x == 0 && p.y == 0 && checkRepaint) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavBarPopup.this.myPanel.getUpdateQueue().rebuildUi();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NavBarPopup.this.show(item, false);
                        }
                    });
                }
            });
        } else {
            int offset = NavBarUIManager.getUI().getPopupOffset(item);
            this.show(this.myPanel, p.x - offset, p.y, this.myPanel, new HintHint(this.myPanel, p));
            JBList list = this.getList();
            if (0 <= this.myIndex && this.myIndex < list.getItemsCount()) {
                ListScrollingUtil.selectItem((JList)list, (int)this.myIndex);
            }
        }
        if (this.myPanel.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent((Component)this.getList());
            window.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    Window w = e.getOppositeWindow();
                    if (w != null && DialogWrapper.findInstance((Component)w.getComponent(0)) != null) {
                        NavBarPopup.this.myPanel.hideHint();
                    }
                }
            });
        }
    }

    public void dispose() {
    }

    private static JComponent createPopupContent(final NavBarPanel panel, Object[] siblings) {
        NavbarPopupList list = new NavbarPopupList(panel, siblings);
        list.setDataProvider(new DataProvider(){

            public Object getData(@NonNls String dataId) {
                return panel.getData(dataId);
            }
        });
        final ArrayList disposables = new ArrayList();
        list.putClientProperty(DISPOSED_OBJECTS, disposables);
        list.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){

            @NotNull
            public JComponent fun(Object obj) {
                NavBarItem navBarItem = new NavBarItem(panel, obj, null);
                disposables.add(navBarItem);
                NavBarItem navBarItem2 = navBarItem;
                if (navBarItem2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPopup$5", "fun"));
                }
                return navBarItem2;
            }
        });
        list.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        NavBarPopup.installMoveAction((JBList)list, panel, -1, 37);
        NavBarPopup.installMoveAction((JBList)list, panel, 1, 39);
        NavBarPopup.installEnterAction((JBList)list, panel, 10);
        NavBarPopup.installEscapeAction((JBList)list, panel, 27);
        JComponent component = ListWithFilter.wrap((JList)((Object)list), (JScrollPane)((Object)new NavBarListWrapper((JList)((Object)list))), (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return panel.getPresentation().getPresentableText(o);
            }
        });
        component.putClientProperty(JBLIST_KEY, (Object)list);
        return component;
    }

    private static void installEnterAction(final JBList list, final NavBarPanel panel, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.navigateInsideBar(list.getSelectedValue());
            }
        };
        list.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    private static void installEscapeAction(JBList list, final NavBarPanel panel, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.cancelPopup();
            }
        };
        list.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    public Object getSelectedValue() {
        return this.getList().getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.getList().getSelectedValues();
    }

    public JBList getList() {
        return (JBList)this.getComponent().getClientProperty(JBLIST_KEY);
    }

    private static void installMoveAction(JBList list, final NavBarPanel panel, final int direction, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.cancelPopup();
                panel.shiftFocus(direction);
                panel.restorePopup();
            }
        };
        list.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    private static class NavbarPopupList
    extends JBListWithHintProvider
    implements Queryable {
        private final NavBarPanel myPanel;

        public NavbarPopupList(NavBarPanel panel, Object[] siblings) {
            super(siblings);
            this.myPanel = panel;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/navigationToolbar/NavBarPopup$NavbarPopupList", "putInfo"));
            }
            this.myPanel.putInfo(info);
        }

        protected PsiElement getPsiElementForHint(Object selectedValue) {
            return selectedValue instanceof PsiElement ? (PsiElement)selectedValue : null;
        }
    }
}

