/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.IdeView;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;

public final class NavBarIdeView
implements IdeView {
    private final NavBarPanel myPanel;

    public NavBarIdeView(NavBarPanel panel) {
        this.myPanel = panel;
    }

    public void selectElement(PsiElement element) {
        Navigatable navigatable;
        this.myPanel.getModel().updateModel(element);
        if (element instanceof Navigatable && (navigatable = (Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(true);
        }
        this.myPanel.hideHint();
    }

    public PsiDirectory[] getDirectories() {
        PsiFile file;
        PsiDirectory dir = this.myPanel.getSelectedElement(PsiDirectory.class);
        if (dir != null && dir.isValid()) {
            return new PsiDirectory[]{dir};
        }
        PsiElement element = this.myPanel.getSelectedElement(PsiElement.class);
        if (element != null && element.isValid() && (file = element.getContainingFile()) != null) {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory != null) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = psiDirectory;
            } else {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            }
            return psiDirectoryArray;
        }
        PsiDirectoryContainer directoryContainer = this.myPanel.getSelectedElement(PsiDirectoryContainer.class);
        if (directoryContainer != null) {
            return directoryContainer.getDirectories();
        }
        Module module = this.myPanel.getSelectedElement(Module.class);
        if (module != null && !module.isDisposed()) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            PsiManager psiManager = PsiManager.getInstance((Project)this.myPanel.getProject());
            for (VirtualFile virtualFile : sourceRoots) {
                PsiDirectory directory = psiManager.findDirectory(virtualFile);
                if (directory == null || !directory.isValid()) continue;
                dirs.add(directory);
            }
            return dirs.toArray(new PsiDirectory[dirs.size()]);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory(this);
    }
}

