/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;

public class ActivateNavigationBarAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project != null && UISettings.getInstance().SHOW_NAVIGATION_BAR) {
            IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(project);
            IdeRootPane ideRootPane = (IdeRootPane)frame.getRootPane();
            NavBarPanel navBarPanel = (NavBarPanel)ideRootPane.findByName("NavBar").getComponent();
            navBarPanel.rebuildAndSelectTail(true);
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        UISettings settings = UISettings.getInstance();
        boolean enabled = project != null && settings.SHOW_NAVIGATION_BAR && !settings.PRESENTATION_MODE;
        e.getPresentation().setEnabled(enabled);
    }
}

