/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "<init>"));
        }
        this.myProject = project;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(SelectInContext context) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        if (!virtualFile.isValid()) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        Object psiFile = document != null ? PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document) : (context.getSelectorInFile() instanceof PsiFile ? (PsiFile)context.getSelectorInFile() : (virtualFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile) : PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)));
        return psiFile != null && this.canSelect((PsiFileSystemItem)psiFile) || this.canWorkWithCustomObjects();
    }

    public final void selectIn(SelectInContext context, boolean requestFocus) {
        VirtualFile file = context.getVirtualFile();
        Object selector = context.getSelectorInFile();
        if (selector == null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Object object = selector = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        }
        if (selector instanceof PsiElement) {
            this.select(((PsiElement)selector).getOriginalElement(), requestFocus);
        } else {
            this.select(selector, file, requestFocus);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    protected abstract boolean canWorkWithCustomObjects();

    protected abstract void select(PsiElement var1, boolean var2);
}

