/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.ide.highlighter.custom.CustomFileHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeFoldingBuilder
extends CustomFoldingBuilder {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        FileType fileType = root.getContainingFile().getFileType();
        if (!(fileType instanceof CustomSyntaxTableFileType)) {
            return;
        }
        CustomFileHighlighter highlighter = new CustomFileHighlighter(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
        CustomFileTypeFoldingBuilder.buildBraceMatcherBasedFolding(descriptors, root, document, (SyntaxHighlighter)highlighter);
    }

    public static void buildBraceMatcherBasedFolding(List<FoldingDescriptor> descriptors, PsiElement root, Document document, SyntaxHighlighter highlighter) {
        LexerEditorHighlighter editorHighlighter = new LexerEditorHighlighter(highlighter, EditorColorsManager.getInstance().getGlobalScheme());
        editorHighlighter.setText(document.getText());
        FileType fileType = root.getContainingFile().getFileType();
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, root.getLanguage());
        TextRange totalRange = root.getTextRange();
        HighlighterIterator iterator = editorHighlighter.createIterator(totalRange.getStartOffset());
        LinkedList<Trinity> stack = new LinkedList<Trinity>();
        String editorText = document.getText();
        while (!iterator.atEnd() && iterator.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator, editorText, fileType) && braceMatcher.isStructuralBrace(iterator, editorText, fileType)) {
                stack.addLast(Trinity.create((Object)iterator.getStart(), (Object)iterator.getEnd(), (Object)iterator.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator, editorText, fileType) && braceMatcher.isStructuralBrace(iterator, editorText, fileType) && !stack.isEmpty()) {
                Trinity last = (Trinity)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last.third, iterator.getTokenType())) {
                    stack.removeLast();
                    TextRange range = new TextRange(((Integer)last.first).intValue(), iterator.getEnd());
                    if (StringUtil.countChars((CharSequence)document.getText(range), (char)'\n') >= 3) {
                        descriptors.add(new FoldingDescriptor(root, range));
                    }
                }
            }
            iterator.advance();
        }
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "getLanguagePlaceholderText"));
        }
        return "{...}";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        return false;
    }
}

