/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractCustomLexer
extends LexerBase {
    protected CharSequence myBuffer = ArrayUtil.EMPTY_CHAR_SEQUENCE;
    protected int myStartOffset = 0;
    protected int myEndOffset = 0;
    private final TokenParser[] myTokenParsers;
    protected TokenInfo myCurrentToken;
    protected int myPosition;

    public AbstractCustomLexer(List<TokenParser> tokenParsers) {
        this.myTokenParsers = tokenParsers.toArray(new TokenParser[tokenParsers.size()]);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/highlighter/custom/AbstractCustomLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPosition = this.myStartOffset;
        this.myCurrentToken = new TokenInfo();
        for (TokenParser tokenParser : this.myTokenParsers) {
            tokenParser.setBuffer(this.myBuffer, this.myStartOffset, this.myEndOffset);
        }
        this.advance();
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        return this.myCurrentToken.getType();
    }

    public int getTokenStart() {
        return this.myCurrentToken.getStart();
    }

    public int getTokenEnd() {
        return this.myCurrentToken.getEnd();
    }

    public void advance() {
        if (this.myPosition >= this.myEndOffset) {
            this.myCurrentToken.updateData(this.myPosition, this.myPosition, null);
            return;
        }
        boolean tokenFound = false;
        for (TokenParser tokenParser : this.myTokenParsers) {
            if (!tokenParser.hasToken(this.myPosition)) continue;
            tokenParser.getTokenInfo(this.myCurrentToken);
            if (this.myCurrentToken.getEnd() <= this.myCurrentToken.getStart()) {
                throw new AssertionError(tokenParser);
            }
            tokenFound = true;
            break;
        }
        if (!tokenFound) {
            this.handleTokenNotFound();
        }
        this.myPosition = this.myCurrentToken.getEnd();
    }

    protected void handleTokenNotFound() {
        this.myCurrentToken.updateData(this.myPosition, this.myPosition + 1, CustomHighlighterTokenType.CHARACTER);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/custom/AbstractCustomLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }
}

