/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;

public final class TypeHierarchyTreeStructure
extends SubtypesHierarchyTreeStructure {
    public TypeHierarchyTreeStructure(Project project, PsiClass aClass, String currentScopeType) {
        super(project, TypeHierarchyTreeStructure.buildHierarchyElement(project, aClass), currentScopeType);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private static HierarchyNodeDescriptor buildHierarchyElement(Project project, PsiClass aClass) {
        TypeHierarchyNodeDescriptor descriptor = null;
        PsiClass[] superClasses = TypeHierarchyTreeStructure.createSuperClasses(aClass);
        for (int i = superClasses.length - 1; i >= 0; --i) {
            PsiClass superClass = superClasses[i];
            TypeHierarchyNodeDescriptor newDescriptor = new TypeHierarchyNodeDescriptor(project, descriptor, (PsiElement)superClass, false);
            if (descriptor != null) {
                descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        TypeHierarchyNodeDescriptor newDescriptor = new TypeHierarchyNodeDescriptor(project, descriptor, (PsiElement)aClass, true);
        if (descriptor != null) {
            descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static PsiClass[] createSuperClasses(PsiClass aClass) {
        if (!aClass.isValid()) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (aClass.isInterface()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> superClasses = new ArrayList<PsiClass>();
        while (!"java.lang.Object".equals(aClass.getQualifiedName())) {
            PsiClass aClass1 = aClass;
            PsiClass[] superTypes = aClass1.getSupers();
            PsiClass superType = null;
            for (int i = 0; i < superTypes.length; ++i) {
                PsiClass type = superTypes[i];
                if (type.isInterface()) continue;
                superType = type;
                break;
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            aClass = superType;
        }
        return superClasses.toArray(new PsiClass[superClasses.size()]);
    }
}

