/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.DeletedTemplatesManager;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateManagerImpl
extends FileTemplateManager
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    private final RecentTemplatesManager myRecentList;
    @NonNls
    private static final String ELEMENT_DELETED_TEMPLATES = "deleted_templates";
    @NonNls
    private static final String ELEMENT_DELETED_INCLUDES = "deleted_includes";
    @NonNls
    private static final String ELEMENT_RECENT_TEMPLATES = "recent_templates";
    @NonNls
    private static final String ELEMENT_TEMPLATES = "templates";
    private final FileTypeManagerEx myTypeManager;
    private final ExportableFileTemplateSettings myTemplateSettings;
    private final FTManager myInternalTemplatesManager;
    private final FTManager myDefaultTemplatesManager;
    private final FTManager myPatternsManager;
    private final FTManager myCodeTemplatesManager;
    private final FTManager myJ2eeTemplatesManager;
    private final FTManager[] myAllManagers;
    private final URL myDefaultTemplateDescription;
    private final URL myDefaultIncludeDescription;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl() {
        return (FileTemplateManagerImpl)ServiceManager.getService(FileTemplateManager.class);
    }

    public FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, ProjectManager pm) {
        if (typeManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "<init>"));
        }
        this.myRecentList = new RecentTemplatesManager();
        this.myTypeManager = typeManager;
        this.myTemplateSettings = ExportableFileTemplateSettings.getInstance();
        assert (this.myTemplateSettings != null) : "Can not instantiate " + ExportableFileTemplateSettings.class.getName();
        this.myInternalTemplatesManager = this.myTemplateSettings.getInternalTemplatesManager();
        this.myDefaultTemplatesManager = this.myTemplateSettings.getDefaultTemplatesManager();
        this.myPatternsManager = this.myTemplateSettings.getPatternsManager();
        this.myCodeTemplatesManager = this.myTemplateSettings.getCodeTemplatesManager();
        this.myJ2eeTemplatesManager = this.myTemplateSettings.getJ2eeTemplatesManager();
        this.myAllManagers = this.myTemplateSettings.getAllManagers();
        this.myDefaultTemplateDescription = this.myTemplateSettings.getDefaultTemplateDescription();
        this.myDefaultIncludeDescription = this.myTemplateSettings.getDefaultIncludeDescription();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (String tname : Arrays.asList("Class", "AnnotationType", "Enum", "Interface")) {
                for (FileTemplateBase template : this.myInternalTemplatesManager.getAllTemplates(true)) {
                    if (!tname.equals(template.getName())) continue;
                    this.myInternalTemplatesManager.removeTemplate(template.getQualifiedName());
                    break;
                }
                FileTemplateBase template = this.myInternalTemplatesManager.addTemplate(tname, "java");
                template.setText(FileTemplateManagerImpl.normalizeText(this.getTestClassTemplateText(tname)));
            }
        }
    }

    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        Collection<FileTemplateBase> templates = this.myDefaultTemplatesManager.getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getTemplate(@NotNull String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplate"));
        }
        return this.myDefaultTemplatesManager.findTemplateByName(templateName);
    }

    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        FileTemplateBase fileTemplateBase = this.myDefaultTemplatesManager.addTemplate(name, extension);
        if (fileTemplateBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addTemplate"));
        }
        return fileTemplateBase;
    }

    @Override
    public void removeTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "removeTemplate"));
        }
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.myAllManagers) {
            manager.removeTemplate(qName);
        }
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate((Date)date));
        props.setProperty("TIME", DateFormatUtil.formatTime((Date)date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        Properties properties = props;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultProperties"));
        }
        return properties;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result = Integer.toString(val)).length() == 1) {
            String string = "0" + result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCalendarValue"));
            }
            return string;
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCalendarValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        Collection<String> collection = this.myRecentList.getRecentNames(25);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getRecentNames"));
        }
        return collection;
    }

    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "addRecentName"));
        }
        this.myRecentList.addName(name);
    }

    public void readExternal(Element element) throws InvalidDataException {
        boolean hasSettingsInOlderFormat;
        Element recentElement = element.getChild(ELEMENT_RECENT_TEMPLATES);
        if (recentElement != null) {
            this.myRecentList.readExternal(recentElement);
        }
        DeletedTemplatesManager deletedDefaults = new DeletedTemplatesManager();
        Element deletedTemplatesElement = element.getChild(ELEMENT_DELETED_TEMPLATES);
        if (deletedTemplatesElement != null) {
            deletedDefaults.readExternal(deletedTemplatesElement);
        }
        DeletedTemplatesManager deletedIncludes = new DeletedTemplatesManager();
        Element deletedIncludesElement = element.getChild(ELEMENT_DELETED_INCLUDES);
        if (deletedIncludesElement != null) {
            deletedIncludes.readExternal(deletedIncludesElement);
        }
        HashSet<String> templateNamesWithReformatOff = new HashSet<String>();
        Element templatesElement = element.getChild(ELEMENT_TEMPLATES);
        if (templatesElement != null) {
            List children = templatesElement.getChildren();
            for (Object child : children) {
                Element childElement = (Element)child;
                boolean reformat = Boolean.TRUE.toString().equals(childElement.getAttributeValue("reformat"));
                if (reformat) continue;
                String name = childElement.getAttributeValue("name");
                templateNamesWithReformatOff.add(name);
            }
        }
        if (!this.myTemplateSettings.isLoaded()) {
            this.myTemplateSettings.doLoad(element);
        }
        boolean hasDeletedDefaultsInOlderFormat = !deletedDefaults.DELETED_DEFAULT_TEMPLATES.isEmpty();
        boolean hasDeletedincludesinOlderFormat = !deletedIncludes.DELETED_DEFAULT_TEMPLATES.isEmpty();
        boolean hasTemplatesWithReformatAttibuteAltered = !templateNamesWithReformatOff.isEmpty();
        boolean bl = hasSettingsInOlderFormat = hasDeletedDefaultsInOlderFormat || hasDeletedincludesinOlderFormat || hasTemplatesWithReformatAttibuteAltered;
        if (hasSettingsInOlderFormat) {
            Collection<FileTemplateBase> allDefaults = this.myDefaultTemplatesManager.getAllTemplates(true);
            if (hasDeletedDefaultsInOlderFormat) {
                FileTemplateManagerImpl.applyDeletedState(deletedDefaults, allDefaults);
            }
            if (hasDeletedincludesinOlderFormat) {
                FileTemplateManagerImpl.applyDeletedState(deletedIncludes, this.myPatternsManager.getAllTemplates(true));
            }
            if (hasTemplatesWithReformatAttibuteAltered) {
                FileTemplateManagerImpl.applyReformatState(templateNamesWithReformatOff, allDefaults);
                FileTemplateManagerImpl.applyReformatState(templateNamesWithReformatOff, this.myInternalTemplatesManager.getAllTemplates(true));
            }
        }
    }

    private static void applyReformatState(@NotNull Set<String> templateNamesWithReformatOff, @NotNull Collection<FileTemplateBase> templates) {
        if (templateNamesWithReformatOff == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "applyReformatState"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "applyReformatState"));
        }
        for (FileTemplateBase template : templates) {
            if (!templateNamesWithReformatOff.contains(template.getName())) continue;
            template.setReformatCode(false);
        }
    }

    private static void applyDeletedState(@NotNull DeletedTemplatesManager deletedDefaults, @NotNull Collection<FileTemplateBase> templates) {
        if (deletedDefaults == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "applyDeletedState"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "applyDeletedState"));
        }
        for (FileTemplateBase template : templates) {
            if (!(template instanceof BundledFileTemplate) || !deletedDefaults.contains(template.getQualifiedName())) continue;
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (FTManager child : this.myAllManagers) {
            child.saveTemplates();
        }
        this.validateRecentNames();
        Element recentElement = new Element(ELEMENT_RECENT_TEMPLATES);
        element.addContent(recentElement);
        this.myRecentList.writeExternal(recentElement);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.myDefaultTemplatesManager.getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplateBase fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.myRecentList.validateNames(allNames);
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        InternalTemplateBean[] internalTemplateBeans = (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME);
        FileTemplate[] result = new FileTemplate[internalTemplateBeans.length];
        for (int i = 0; i < internalTemplateBeans.length; ++i) {
            result[i] = this.getInternalTemplate(internalTemplateBeans[i].name);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getInternalTemplates"));
        }
        return result;
    }

    @Override
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getInternalTemplate"));
        }
        LOG.assertTrue(this.myInternalTemplatesManager != null);
        FileTemplateBase template = this.myInternalTemplatesManager.findTemplateByName(templateName);
        if (template == null) {
            template = this.myDefaultTemplatesManager.findTemplateByName(templateName);
        }
        if (template == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            if (template != null) {
                template.setReformatCode(true);
            } else {
                String text = FileTemplateManagerImpl.normalizeText(this.getDefaultClassTemplateText(templateName));
                template = this.myInternalTemplatesManager.addTemplate(templateName, "java");
                template.setText(text);
            }
        }
        return template;
    }

    @NotNull
    private static String normalizeText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "normalizeText"));
        }
        text = StringUtil.convertLineSeparators((String)text);
        text = StringUtil.replace((String)text, (String)"$NAME$", (String)"${NAME}");
        text = StringUtil.replace((String)text, (String)"$PACKAGE_NAME$", (String)"${PACKAGE_NAME}");
        text = StringUtil.replace((String)text, (String)"$DATE$", (String)"${DATE}");
        text = StringUtil.replace((String)text, (String)"$TIME$", (String)"${TIME}");
        String string = text = StringUtil.replace((String)text, (String)"$USER$", (String)"${USER}");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "normalizeText"));
        }
        return string;
    }

    @NonNls
    @NotNull
    private String getTestClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTestClassTemplateText"));
        }
        String string = "package $PACKAGE_NAME$;\npublic " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTestClassTemplateText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
        }
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            String string = bean.subject;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
            }
            return string;
        }
        String string = templateName.toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "internalTemplateToSubject"));
        }
        return string;
    }

    @Override
    @NotNull
    public String localizeInternalTemplateName(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "localizeInternalTemplateName"));
        }
        String string = template.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "localizeInternalTemplateName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    private String getDefaultClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultClassTemplateText"));
        }
        String string = IdeBundle.message((String)"template.default.class.comment", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}) + "package $PACKAGE_NAME$;\n" + "public " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultClassTemplateText"));
        }
        return string;
    }

    @Override
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getCodeTemplate"));
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.myCodeTemplatesManager);
    }

    @Override
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getJ2eeTemplate"));
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.myJ2eeTemplatesManager);
    }

    @Nullable
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplateFromManager"));
        }
        if (ftManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getTemplateFromManager"));
        }
        FileTemplateBase template = ftManager.getTemplate(templateName);
        if (template != null) {
            return template;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            return template;
        }
        if (templateName.endsWith("ForTest") && ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String message = "Template not found: " + templateName;
        LOG.error(message);
        return null;
    }

    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
        }
        String templateQName = this.myTypeManager.getExtension(name).isEmpty() ? FileTemplateBase.getQualifiedName(name, "java") : name;
        for (FTManager manager : this.myAllManagers) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (!(template instanceof BundledFileTemplate)) continue;
            BundledFileTemplate copy = ((BundledFileTemplate)template).clone();
            copy.revertToDefaults();
            BundledFileTemplate bundledFileTemplate = copy;
            if (bundledFileTemplate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
            }
            return bundledFileTemplate;
        }
        String message = "Default template not found: " + name;
        LOG.error(message);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getDefaultTemplate"));
        }
        return null;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.myPatternsManager.getAllTemplates(false);
        FileTemplate[] fileTemplateArray = allTemplates.toArray(new FileTemplate[allTemplates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllPatterns"));
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getPattern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getPattern"));
        }
        return this.myPatternsManager.findTemplateByName(name);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.myCodeTemplatesManager.getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllCodeTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.myJ2eeTemplatesManager.getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "getAllJ2eeTemplates"));
        }
        return fileTemplateArray;
    }

    @Override
    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<FileTemplate> templates) {
        if (templatesCategory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setTemplates"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl", "setTemplates"));
        }
        for (FTManager manager : this.myAllManagers) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            break;
        }
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultTemplateDescription;
    }

    public URL getDefaultIncludeDescription() {
        return this.myDefaultIncludeDescription;
    }

    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    private static class RecentTemplatesManager
    implements JDOMExternalizable {
        public JDOMExternalizableStringList RECENT_TEMPLATES = new JDOMExternalizableStringList();

        private RecentTemplatesManager() {
        }

        public void addName(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$RecentTemplatesManager", "addName"));
            }
            this.RECENT_TEMPLATES.remove((Object)name);
            this.RECENT_TEMPLATES.add((Object)name);
        }

        @NotNull
        public Collection<String> getRecentNames(int max) {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(max, size);
            List list = this.RECENT_TEMPLATES.subList(size - resultSize, size);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$RecentTemplatesManager", "getRecentNames"));
            }
            return list;
        }

        public void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
    }
}

