/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTemplate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.DefaultTemplate");
    private final String myName;
    private final String myExtension;
    private final URL myTemplateURL;
    @Nullable
    private final URL myDescriptionURL;
    private final String myText;
    private final String myDescriptionText;

    public DefaultTemplate(@NotNull String name, @NotNull String extension, @NotNull URL templateURL, @Nullable URL descriptionURL) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/impl/DefaultTemplate", "<init>"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/impl/DefaultTemplate", "<init>"));
        }
        if (templateURL == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/fileTemplates/impl/DefaultTemplate", "<init>"));
        }
        this.myName = name;
        this.myExtension = extension;
        this.myTemplateURL = templateURL;
        this.myDescriptionURL = descriptionURL;
        this.myText = DefaultTemplate.loadText(templateURL);
        this.myDescriptionText = descriptionURL != null ? DefaultTemplate.loadText(descriptionURL) : "";
    }

    private static String loadText(URL url) {
        String text = "";
        try {
            text = StringUtil.convertLineSeparators((String)UrlUtil.loadText(url));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text;
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public String getExtension() {
        return this.myExtension;
    }

    public URL getTemplateURL() {
        return this.myTemplateURL;
    }

    @Nullable
    public URL getDescriptionURL() {
        return this.myDescriptionURL;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/DefaultTemplate", "getText"));
        }
        return string;
    }

    @NotNull
    public String getDescriptionText() {
        String string = this.myDescriptionText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/DefaultTemplate", "getDescriptionText"));
        }
        return string;
    }
}

