/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaTemplateUtil {
    @NonNls
    public static final String TEMPLATE_CATCH_BODY = "Catch Statement Body.java";
    @NonNls
    public static final String TEMPLATE_IMPLEMENTED_METHOD_BODY = "Implemented Method Body.java";
    @NonNls
    public static final String TEMPLATE_OVERRIDDEN_METHOD_BODY = "Overridden Method Body.java";
    @NonNls
    public static final String TEMPLATE_FROM_USAGE_METHOD_BODY = "New Method Body.java";
    @NonNls
    public static final String TEMPLATE_I18NIZED_EXPRESSION = "I18nized Expression.java";
    @NonNls
    public static final String TEMPLATE_I18NIZED_CONCATENATION = "I18nized Concatenation.java";
    @NonNls
    public static final String TEMPLATE_I18NIZED_JSP_EXPRESSION = "I18nized JSP Expression.jsp";
    @NonNls
    public static final String INTERNAL_CLASS_TEMPLATE_NAME = "Class";
    @NonNls
    public static final String INTERNAL_INTERFACE_TEMPLATE_NAME = "Interface";
    @NonNls
    public static final String INTERNAL_ANNOTATION_TYPE_TEMPLATE_NAME = "AnnotationType";
    @NonNls
    public static final String INTERNAL_ENUM_TEMPLATE_NAME = "Enum";

    private JavaTemplateUtil() {
    }

    public static void setClassAndMethodNameProperties(Properties properties, PsiClass aClass, PsiMethod method) {
        String className = aClass.getQualifiedName();
        if (className == null) {
            className = "";
        }
        properties.setProperty("CLASS_NAME", className);
        String classSimpleName = aClass.getName();
        if (classSimpleName == null) {
            classSimpleName = "";
        }
        properties.setProperty("SIMPLE_CLASS_NAME", classSimpleName);
        String methodName = method.getName();
        properties.setProperty("METHOD_NAME", methodName);
    }

    public static String getPackageName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "getPackageName"));
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        return aPackage != null ? aPackage.getQualifiedName() : "";
    }

    public static void setPackageNameAttribute(@NotNull Properties properties, @NotNull PsiDirectory directory) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setPackageNameAttribute"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/fileTemplates/JavaTemplateUtil", "setPackageNameAttribute"));
        }
        properties.setProperty("PACKAGE_NAME", JavaTemplateUtil.getPackageName(directory));
    }
}

