/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import javax.swing.Icon;

public abstract class FavoritesToolbarButtonAction
extends AnActionButton
implements Toggleable {
    private FavoritesViewTreeBuilder myBuilder;
    private FavoritesViewSettings mySettings;

    public FavoritesToolbarButtonAction(Project project, FavoritesViewTreeBuilder builder, String name, Icon icon) {
        super(name, icon);
        this.myBuilder = builder;
        this.mySettings = FavoritesManager.getInstance(project).getViewSettings();
        this.setContextComponent(this.myBuilder.getTree());
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesToolbarButtonAction.this.myBuilder = null;
                FavoritesToolbarButtonAction.this.mySettings = null;
            }
        });
    }

    public abstract boolean isOptionEnabled();

    public abstract void setOption(boolean var1);

    public FavoritesViewSettings getViewSettings() {
        return this.mySettings;
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    public void actionPerformed(AnActionEvent e) {
        this.setOption(!this.isOptionEnabled());
        this.myBuilder.updateFromRootCB();
    }

    public void updateButton(AnActionEvent e) {
        super.updateButton(e);
        e.getPresentation().putClientProperty("selected", (Object)this.isOptionEnabled());
    }
}

