/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class FileGroupingProjectNode
extends ProjectViewNodeWithChildrenList<File> {
    private VirtualFile myVirtualFile;

    public FileGroupingProjectNode(Project project, File file, ViewSettings viewSettings) {
        super(project, file, viewSettings);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myVirtualFile = lfs.findFileByIoFile(file);
        if (this.myVirtualFile == null) {
            this.myVirtualFile = lfs.refreshAndFindFileByIoFile(file);
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/FileGroupingProjectNode", "contains"));
        }
        return file.equals(this.myVirtualFile);
    }

    protected void update(PresentationData presentation) {
        if (this.myVirtualFile != null && this.myVirtualFile.isDirectory()) {
            presentation.setIcon(AllIcons.Nodes.TreeClosed);
        } else if (this.myVirtualFile != null) {
            presentation.setIcon(this.myVirtualFile.getFileType().getIcon());
        } else {
            presentation.setIcon(AllIcons.FileTypes.Unknown);
        }
        presentation.setPresentableText(((File)this.getValue()).getName());
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void navigate(boolean requestFocus) {
        if (this.myVirtualFile != null) {
            new OpenFileDescriptor(this.myProject, this.myVirtualFile).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myVirtualFile != null && this.myVirtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.myVirtualFile != null && this.myVirtualFile.isValid();
    }
}

