/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeUtil {
    @NotNull
    public static FavoritesTreeNodeDescriptor[] getSelectedNodeDescriptors(DnDAwareTree tree) {
        TreePath[] path = tree.getSelectionPaths();
        if (path == null) {
            if (FavoritesTreeNodeDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getSelectedNodeDescriptors"));
            }
            return FavoritesTreeNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<FavoritesTreeNodeDescriptor> result = new ArrayList<FavoritesTreeNodeDescriptor>();
        for (TreePath treePath : path) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor)) continue;
            FavoritesTreeNodeDescriptor treeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
            result.add(treeNodeDescriptor);
        }
        FavoritesTreeNodeDescriptor[] favoritesTreeNodeDescriptorArray = result.toArray(new FavoritesTreeNodeDescriptor[result.size()]);
        if (favoritesTreeNodeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getSelectedNodeDescriptors"));
        }
        return favoritesTreeNodeDescriptorArray;
    }

    public static List<AbstractTreeNode> getLogicalPathToSelected(Tree tree) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        TreePath selectionPath = tree.getSelectionPath();
        return FavoritesTreeUtil.getLogicalPathTo(result, selectionPath);
    }

    public static List<Integer> getLogicalIndexPathTo(TreePath selectionPath) {
        Object uo;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result.add(treeNode.getIndex());
            }
            Collections.reverse(result);
            return result;
        }
        return Collections.emptyList();
    }

    public static List<AbstractTreeNode> getLogicalPathTo(List<AbstractTreeNode> result, TreePath selectionPath) {
        Object uo;
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result.add(treeNode);
            }
            Collections.reverse(result);
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static FavoritesListNode extractParentList(FavoritesTreeNodeDescriptor descriptor) {
        AbstractTreeNode node;
        for (AbstractTreeNode current = node = descriptor.getElement(); current != null; current = current.getParent()) {
            if (!(current instanceof FavoritesListNode)) continue;
            return (FavoritesListNode)current;
        }
        return null;
    }

    static FavoritesListProvider getProvider(@NotNull FavoritesManager manager, @NotNull FavoritesTreeNodeDescriptor descriptor) {
        AbstractTreeNode treeNode;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getProvider"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getProvider"));
        }
        for (treeNode = descriptor.getElement(); treeNode != null && !(treeNode instanceof FavoritesListNode); treeNode = treeNode.getParent()) {
        }
        if (treeNode != null) {
            String name = (String)((FavoritesListNode)treeNode).getValue();
            return manager.getListProvider(name);
        }
        return null;
    }
}

