/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFavoritesListProvider<T>
implements FavoritesListProvider {
    public static final int BOOKMARKS_WEIGHT = 100;
    public static final int BREAKPOINTS_WEIGHT = 200;
    public static final int TASKS_WEIGHT = 300;
    protected final Project myProject;
    private final String myListName;
    protected final List<AbstractTreeNode<T>> myChildren;
    protected final FavoritesListNode myNode;

    protected AbstractFavoritesListProvider(@NotNull Project project, String listName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "<init>"));
        }
        this(project, listName, null);
    }

    protected AbstractFavoritesListProvider(@NotNull Project project, String listName, @Nullable String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "<init>"));
        }
        this.myChildren = new ArrayList<AbstractTreeNode<T>>();
        this.myProject = project;
        this.myListName = listName;
        this.myNode = new FavoritesListNode(project, listName, description){

            @Override
            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                List list = AbstractFavoritesListProvider.this.myChildren;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider$1", "getChildren"));
                }
                return list;
            }

            @Override
            public FavoritesListProvider getProvider() {
                return AbstractFavoritesListProvider.this;
            }
        };
    }

    @Override
    public String getListName(Project project) {
        return this.myListName;
    }

    @Override
    @Nullable
    public FavoritesListNode createFavoriteListNode(Project project) {
        return this.myNode;
    }

    @Override
    public int compare(FavoritesTreeNodeDescriptor o1, FavoritesTreeNodeDescriptor o2) {
        return o1.getIndex() - o2.getIndex();
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "getCustomName"));
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "willHandle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "willHandle"));
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "handle"));
        }
        if (selectedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "handle"));
        }
    }

    @Override
    public int compareTo(FavoritesListProvider o) {
        if (this.getWeight() > o.getWeight()) {
            return 1;
        }
        if (this.getWeight() < o.getWeight()) {
            return -1;
        }
        return 0;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/favoritesTreeView/AbstractFavoritesListProvider", "customizeRenderer"));
        }
    }
}

