/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebBrowserServiceImpl
extends WebBrowserService {
    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) throws WebBrowserUrlProvider.BrowserException {
        VirtualFile virtualFile;
        block10: {
            WebBrowserUrlProvider provider;
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
            }
            virtualFile = request.getVirtualFile();
            if (virtualFile instanceof HttpVirtualFile) {
                Set<Url> set = Collections.singleton(Urls.newFromVirtualFile(virtualFile));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
                }
                return set;
            }
            if (!(preferLocalUrl && HtmlUtil.isHtmlFile((PsiElement)request.getFile()) || (provider = WebBrowserServiceImpl.getProvider(request)) == null)) {
                Collection collection;
                if (request.getResult() != null) {
                    Collection collection2 = request.getResult();
                    if (collection2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
                    }
                    return collection2;
                }
                try {
                    Collection urls = provider.getUrls(request);
                    if (urls.isEmpty()) break block10;
                    collection = urls;
                }
                catch (WebBrowserUrlProvider.BrowserException e) {
                    if (HtmlUtil.isHtmlFile((PsiElement)request.getFile())) break block10;
                    throw e;
                }
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
                }
                return collection;
            }
        }
        Set<Url> set = virtualFile instanceof LightVirtualFile ? Collections.emptySet() : Collections.singleton(Urls.newFromVirtualFile(virtualFile));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlsToOpen"));
        }
        return set;
    }

    @Nullable
    public static WebBrowserUrlProvider getProvider(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getProvider"));
        }
        DumbService dumbService = DumbService.getInstance((Project)request.getProject());
        for (WebBrowserUrlProvider urlProvider : (WebBrowserUrlProvider[])WebBrowserUrlProvider.EP_NAME.getExtensions()) {
            if (dumbService.isDumb() && !DumbService.isDumbAware((Object)urlProvider) || !urlProvider.canHandleElement(request)) continue;
            return urlProvider;
        }
        return null;
    }

    @Nullable
    public static Url getUrlForContext(@NotNull PsiElement sourceElement) {
        Url url;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/impl/WebBrowserServiceImpl", "getUrlForContext"));
        }
        try {
            Collection urls = WebBrowserService.getInstance().getUrlsToOpen(sourceElement, false);
            url = (Url)ContainerUtil.getFirstItem((Collection)urls);
            if (url == null) {
                return null;
            }
        }
        catch (WebBrowserUrlProvider.BrowserException ignored) {
            return null;
        }
        VirtualFile virtualFile = sourceElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return !url.isInLocalFileSystem() || HtmlUtil.isHtmlFile(virtualFile) ? url : null;
    }
}

