/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", storages={@Storage(file="$APP_CONFIG$/web-browsers.xml")})
public class WebBrowserManager
implements PersistentStateComponent<Element>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(WebBrowserManager.class);
    private static final UUID DEFAULT_CHROME_ID = UUID.fromString("98CA6316-2F89-46D9-A9E5-FA9E2B0625B3");
    public static final UUID DEFAULT_FIREFOX_ID = UUID.fromString("A7BB68E0-33C0-4D6F-A81A-AAC1FDB870C8");
    private static final UUID DEFAULT_SAFARI_ID = UUID.fromString("E5120D43-2C3F-47EF-9F26-65E539E05186");
    private static final UUID DEFAULT_OPERA_ID = UUID.fromString("53E2F627-B1A7-4DFA-BFA7-5B83CC034776");
    private static final UUID DEFAULT_EXPLORER_ID = UUID.fromString("16BF23D4-93E0-4FFC-BFD6-CB13575177B0");
    private List<ConfigurableWebBrowser> browsers;
    private long modificationCount;
    DefaultBrowser defaultBrowser = DefaultBrowser.SYSTEM;

    public WebBrowserManager() {
        this.browsers = new ArrayList<ConfigurableWebBrowser>();
        this.browsers.add(new ConfigurableWebBrowser(DEFAULT_CHROME_ID, BrowserFamily.CHROME));
        this.browsers.add(new ConfigurableWebBrowser(DEFAULT_FIREFOX_ID, BrowserFamily.FIREFOX));
        this.browsers.add(new ConfigurableWebBrowser(DEFAULT_SAFARI_ID, BrowserFamily.SAFARI));
        this.browsers.add(new ConfigurableWebBrowser(DEFAULT_OPERA_ID, BrowserFamily.OPERA));
        this.browsers.add(new ConfigurableWebBrowser(DEFAULT_EXPLORER_ID, BrowserFamily.EXPLORER));
    }

    public static WebBrowserManager getInstance() {
        return (WebBrowserManager)ServiceManager.getService(WebBrowserManager.class);
    }

    boolean isPredefinedBrowser(@NotNull ConfigurableWebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "isPredefinedBrowser"));
        }
        UUID id = browser.getId();
        return id.equals(DEFAULT_CHROME_ID) || id.equals(DEFAULT_FIREFOX_ID) || id.equals(DEFAULT_SAFARI_ID) || id.equals(DEFAULT_OPERA_ID) || id.equals(DEFAULT_EXPLORER_ID);
    }

    @NotNull
    public DefaultBrowser getDefaultBrowserMode() {
        DefaultBrowser defaultBrowser = this.defaultBrowser;
        if (defaultBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getDefaultBrowserMode"));
        }
        return defaultBrowser;
    }

    public Element getState() {
        Element state = new Element("state");
        if (this.defaultBrowser != DefaultBrowser.SYSTEM) {
            state.setAttribute("default", this.defaultBrowser.name().toLowerCase());
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            BrowserSpecificSettings specificSettings;
            Element entry = new Element("browser");
            entry.setAttribute("id", browser.getId().toString());
            entry.setAttribute("name", browser.getName());
            entry.setAttribute("family", browser.getFamily().name());
            String path = browser.getPath();
            if (path != null && !path.equals(browser.getFamily().getExecutionPath())) {
                entry.setAttribute("path", path);
            }
            if (!browser.isActive()) {
                entry.setAttribute("active", "false");
            }
            if ((specificSettings = browser.getSpecificSettings()) != null) {
                Element settingsElement = new Element("settings");
                XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                if (!JDOMUtil.isEmpty((Element)settingsElement)) {
                    entry.addContent(settingsElement);
                }
            }
            state.addContent(entry);
        }
        return state;
    }

    @Nullable
    private static BrowserFamily readFamily(String value) {
        try {
            return BrowserFamily.valueOf((String)value);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            for (BrowserFamily family : BrowserFamily.values()) {
                if (!family.getName().equalsIgnoreCase(value)) continue;
                return family;
            }
            return null;
        }
    }

    @Nullable
    private static UUID readId(String value, @NotNull BrowserFamily family, @NotNull List<ConfigurableWebBrowser> existingBrowsers) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserManager", "readId"));
        }
        if (existingBrowsers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/WebBrowserManager", "readId"));
        }
        if (StringUtil.isEmpty((String)value)) {
            UUID id;
            switch (family) {
                case CHROME: {
                    id = DEFAULT_CHROME_ID;
                    break;
                }
                case EXPLORER: {
                    id = DEFAULT_EXPLORER_ID;
                    break;
                }
                case FIREFOX: {
                    id = DEFAULT_FIREFOX_ID;
                    break;
                }
                case OPERA: {
                    id = DEFAULT_OPERA_ID;
                    break;
                }
                case SAFARI: {
                    id = DEFAULT_SAFARI_ID;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (ConfigurableWebBrowser browser : existingBrowsers) {
                if (browser.getId() != id) continue;
                return null;
            }
            return id;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void loadState(Element element) {
        String defaultValue = element.getAttributeValue("default");
        if (!StringUtil.isEmpty((String)defaultValue)) {
            try {
                this.defaultBrowser = DefaultBrowser.valueOf(defaultValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList<ConfigurableWebBrowser> list = new ArrayList<ConfigurableWebBrowser>();
        for (Element child : element.getChildren("browser")) {
            UUID id;
            BrowserFamily family = WebBrowserManager.readFamily(child.getAttributeValue("family"));
            if (family == null || (id = WebBrowserManager.readId(child.getAttributeValue("id"), family, list)) == null) continue;
            Element settingsElement = child.getChild("settings");
            BrowserSpecificSettings specificSettings = family.createBrowserSpecificSettings();
            if (specificSettings != null && settingsElement != null) {
                try {
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String activeValue = child.getAttributeValue("active");
            String path = StringUtil.nullize((String)child.getAttributeValue("path"), (boolean)true);
            if (path == null) {
                path = family.getExecutionPath();
            }
            list.add(new ConfigurableWebBrowser(id, family, StringUtil.notNullize((String)child.getAttributeValue("name"), (String)family.getName()), path, activeValue == null || Boolean.parseBoolean(activeValue), specificSettings));
        }
        this.setList(list);
    }

    @NotNull
    public List<WebBrowser> getBrowsers() {
        List<WebBrowser> list = Collections.unmodifiableList(this.browsers);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getBrowsers"));
        }
        return list;
    }

    @NotNull
    List<ConfigurableWebBrowser> getList() {
        List<ConfigurableWebBrowser> list = this.browsers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getList"));
        }
        return list;
    }

    void setList(@NotNull List<ConfigurableWebBrowser> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "setList"));
        }
        this.browsers = value;
        ++this.modificationCount;
    }

    @NotNull
    public List<WebBrowser> getActiveBrowsers() {
        List<WebBrowser> list = this.getBrowsers((Condition<WebBrowser>)Conditions.alwaysTrue(), true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getActiveBrowsers"));
        }
        return list;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<WebBrowser> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "getBrowsers"));
        }
        List<WebBrowser> list = this.getBrowsers(condition, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getBrowsers"));
        }
        return list;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<WebBrowser> condition, boolean onlyActive) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "getBrowsers"));
        }
        SmartList result = new SmartList();
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (onlyActive && !browser.isActive() || !condition.value((Object)browser)) continue;
            result.add(browser);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getBrowsers"));
        }
        return smartList;
    }

    public void setBrowserSpecificSettings(@NotNull WebBrowser browser, @NotNull BrowserSpecificSettings specificSettings) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "setBrowserSpecificSettings"));
        }
        if (specificSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserManager", "setBrowserSpecificSettings"));
        }
        ((ConfigurableWebBrowser)browser).setSpecificSettings(specificSettings);
    }

    public void setBrowserPath(@NotNull WebBrowser browser, @Nullable String path, boolean isActive) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "setBrowserPath"));
        }
        ((ConfigurableWebBrowser)browser).setPath(path);
        ((ConfigurableWebBrowser)browser).setActive(isActive);
    }

    public WebBrowser addBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, BrowserSpecificSettings specificSettings) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "addBrowser"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserManager", "addBrowser"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/WebBrowserManager", "addBrowser"));
        }
        ConfigurableWebBrowser browser = new ConfigurableWebBrowser(id, family, name, path, active, specificSettings);
        this.browsers.add(browser);
        ++this.modificationCount;
        return browser;
    }

    @Nullable
    private static UUID parseUuid(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "parseUuid"));
        }
        if (id.indexOf(45) == -1) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public WebBrowser findBrowserById(@Nullable String idOrFamilyName) {
        if (StringUtil.isEmpty((String)idOrFamilyName)) {
            return null;
        }
        UUID id = WebBrowserManager.parseUuid(idOrFamilyName);
        if (id == null) {
            for (ConfigurableWebBrowser browser : this.browsers) {
                if (!browser.getFamily().name().equalsIgnoreCase(idOrFamilyName) && !browser.getFamily().getName().equalsIgnoreCase(idOrFamilyName)) continue;
                return browser;
            }
            return null;
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.getId().equals(id)) continue;
            return browser;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public WebBrowser getBrowser(@NotNull BrowserFamily family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "getBrowser"));
        }
        WebBrowser webBrowser = this.getFirstBrowser(family);
        if (webBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getBrowser"));
        }
        return webBrowser;
    }

    @NotNull
    public WebBrowser getFirstBrowser(@NotNull BrowserFamily family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "getFirstBrowser"));
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.isActive() || !family.equals((Object)browser.getFamily())) continue;
            ConfigurableWebBrowser configurableWebBrowser = browser;
            if (configurableWebBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getFirstBrowser"));
            }
            return configurableWebBrowser;
        }
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!family.equals((Object)browser.getFamily())) continue;
            ConfigurableWebBrowser configurableWebBrowser = browser;
            if (configurableWebBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserManager", "getFirstBrowser"));
            }
            return configurableWebBrowser;
        }
        throw new IllegalStateException("Must be at least one browser per family");
    }

    public boolean isActive(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserManager", "isActive"));
        }
        return !(browser instanceof ConfigurableWebBrowser) || ((ConfigurableWebBrowser)browser).isActive();
    }

    @Nullable
    public WebBrowser getDefaultBrowser() {
        for (ConfigurableWebBrowser browser : this.browsers) {
            if (!browser.isActive()) continue;
            return browser;
        }
        return null;
    }

    public long getModificationCount() {
        return this.modificationCount;
    }

    public static enum DefaultBrowser {
        SYSTEM,
        FIRST,
        ALTERNATIVE;

    }
}

