/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.UUID;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BrowserSettingsPanel {
    private static final FileChooserDescriptor APP_FILE_CHOOSER_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String> PATH_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>("Path"){

        public String valueOf(ConfigurableWebBrowser item) {
            return PathUtil.toSystemDependentName((String)item.getPath());
        }

        public void setValue(ConfigurableWebBrowser item, String value) {
            item.setPath(value);
        }

        @Nullable
        public TableCellEditor getEditor(ConfigurableWebBrowser item) {
            return new LocalPathCellEditor().fileChooserDescriptor(APP_FILE_CHOOSER_DESCRIPTOR).normalizePath(true);
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean>(){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(ConfigurableWebBrowser item) {
            return item.isActive();
        }

        public void setValue(ConfigurableWebBrowser item, Boolean value) {
            item.setActive(value);
        }
    }, new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>("Name"){

        public String valueOf(ConfigurableWebBrowser item) {
            return item.getName();
        }

        public void setValue(ConfigurableWebBrowser item, String value) {
            item.setName(value);
        }
    }, new ColumnInfo<ConfigurableWebBrowser, BrowserFamily>("Family"){

        public Class getColumnClass() {
            return BrowserFamily.class;
        }

        public BrowserFamily valueOf(ConfigurableWebBrowser item) {
            return item.getFamily();
        }

        public void setValue(ConfigurableWebBrowser item, BrowserFamily value) {
            item.setFamily(value);
            item.setSpecificSettings(value.createBrowserSpecificSettings());
        }

        @Nullable
        public TableCellRenderer getRenderer(ConfigurableWebBrowser item) {
            return IconTableCellRenderer.ICONABLE;
        }

        public boolean isCellEditable(ConfigurableWebBrowser item) {
            return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
        }
    }, PATH_COLUMN_INFO};
    private JPanel root;
    private TextFieldWithBrowseButton alternativeBrowserPathField;
    private JCheckBox confirmExtractFiles;
    private JButton clearExtractedFiles;
    private JPanel defaultBrowserPanel;
    private JComponent browsersTable;
    private ComboBox defaultBrowserComboBox;
    private TableModelEditor<ConfigurableWebBrowser> browsersEditor;
    private String customPathValue;

    public BrowserSettingsPanel() {
        this.$$$setupUI$$$();
        this.alternativeBrowserPathField.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, APP_FILE_CHOOSER_DESCRIPTOR);
        this.defaultBrowserPanel.setBorder(TitledSeparator.EMPTY_BORDER);
        this.defaultBrowserComboBox.setModel((ComboBoxModel)new EnumComboBoxModel(WebBrowserManager.DefaultBrowser.class));
        if (BrowserLauncherAppless.canStartDefaultBrowser()) {
            this.defaultBrowserComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean customPathEnabled;
                    boolean bl = customPathEnabled = e.getItem() == WebBrowserManager.DefaultBrowser.ALTERNATIVE;
                    if (e.getStateChange() == 2) {
                        if (customPathEnabled) {
                            BrowserSettingsPanel.this.customPathValue = BrowserSettingsPanel.this.alternativeBrowserPathField.getText();
                        }
                    } else if (e.getStateChange() == 1) {
                        BrowserSettingsPanel.this.alternativeBrowserPathField.setEnabled(customPathEnabled);
                        BrowserSettingsPanel.this.updateCustomPathTextFieldValue((WebBrowserManager.DefaultBrowser)((Object)e.getItem()));
                    }
                }
            });
            this.defaultBrowserComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<WebBrowserManager.DefaultBrowser>(){

                public void customize(JList list, WebBrowserManager.DefaultBrowser value, int index, boolean selected, boolean hasFocus) {
                    String name;
                    switch (value) {
                        case SYSTEM: {
                            name = "System default";
                            break;
                        }
                        case FIRST: {
                            name = "First listed";
                            break;
                        }
                        case ALTERNATIVE: {
                            name = "Custom path";
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    this.setText(name);
                }
            });
            if (UIUtil.isUnderAquaLookAndFeel()) {
                this.defaultBrowserComboBox.setBorder((Border)new EmptyBorder(3, 0, 0, 0));
            }
        } else {
            this.defaultBrowserComboBox.setVisible(false);
        }
        this.clearExtractedFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncherAppless.clearExtractedFiles();
            }
        });
    }

    private void updateCustomPathTextFieldValue(WebBrowserManager.DefaultBrowser browser) {
        if (browser == WebBrowserManager.DefaultBrowser.ALTERNATIVE) {
            this.alternativeBrowserPathField.setText(this.customPathValue);
        } else if (browser == WebBrowserManager.DefaultBrowser.FIRST) {
            this.setCustomPathToFirstListed();
        } else {
            this.alternativeBrowserPathField.setText("");
        }
    }

    private void createUIComponents() {
        TableModelEditor.DialogItemEditor<ConfigurableWebBrowser> itemEditor = new TableModelEditor.DialogItemEditor<ConfigurableWebBrowser>(){

            @Override
            @NotNull
            public Class<ConfigurableWebBrowser> getItemClass() {
                if (ConfigurableWebBrowser.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "getItemClass"));
                }
                return ConfigurableWebBrowser.class;
            }

            @Override
            public ConfigurableWebBrowser clone(@NotNull ConfigurableWebBrowser item, boolean forInPlaceEditing) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "clone"));
                }
                return new ConfigurableWebBrowser(forInPlaceEditing ? item.getId() : UUID.randomUUID(), item.getFamily(), item.getName(), item.getPath(), item.isActive(), forInPlaceEditing ? item.getSpecificSettings() : this.cloneSettings(item));
            }

            @Override
            public void edit(@NotNull ConfigurableWebBrowser browser, @NotNull Function<ConfigurableWebBrowser, ConfigurableWebBrowser> mutator) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "edit"));
                }
                if (mutator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "edit"));
                }
                BrowserSpecificSettings settings = this.cloneSettings(browser);
                if (settings != null && ShowSettingsUtil.getInstance().editConfigurable((Component)BrowserSettingsPanel.this.browsersTable, settings.createConfigurable())) {
                    ((ConfigurableWebBrowser)((Object)mutator.fun((Object)browser))).setSpecificSettings(settings);
                }
            }

            @Nullable
            private BrowserSpecificSettings cloneSettings(@NotNull ConfigurableWebBrowser browser) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "cloneSettings"));
                }
                BrowserSpecificSettings settings = browser.getSpecificSettings();
                if (settings == null) {
                    return null;
                }
                BrowserSpecificSettings newSettings = browser.getFamily().createBrowserSpecificSettings();
                assert (newSettings != null);
                TableModelEditor.cloneUsingXmlSerialization(settings, newSettings);
                return newSettings;
            }

            @Override
            public void applyEdited(@NotNull ConfigurableWebBrowser oldItem, @NotNull ConfigurableWebBrowser newItem) {
                if (oldItem == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "applyEdited"));
                }
                if (newItem == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "applyEdited"));
                }
                oldItem.setSpecificSettings(newItem.getSpecificSettings());
            }

            @Override
            public boolean isEditable(@NotNull ConfigurableWebBrowser browser) {
                if (browser == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "isEditable"));
                }
                return browser.getSpecificSettings() != null;
            }

            @Override
            public boolean isRemovable(@NotNull ConfigurableWebBrowser item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$8", "isRemovable"));
                }
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        };
        this.browsersEditor = new TableModelEditor<ConfigurableWebBrowser>(Collections.emptyList(), COLUMNS, itemEditor, "No web browsers configured").modelListener(new TableModelEditor.DataChangedListener<ConfigurableWebBrowser>(){

            @Override
            public void tableChanged(TableModelEvent event) {
                this.update(event.getFirstRow());
            }

            @Override
            public void dataChanged(@NotNull ColumnInfo<ConfigurableWebBrowser, ?> columnInfo, int rowIndex) {
                if (columnInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel$9", "dataChanged"));
                }
                if (columnInfo == PATH_COLUMN_INFO) {
                    this.update(rowIndex);
                }
            }

            private void update(int rowIndex) {
                if (rowIndex == 0 && BrowserSettingsPanel.this.getDefaultBrowser() == WebBrowserManager.DefaultBrowser.FIRST) {
                    BrowserSettingsPanel.this.setCustomPathToFirstListed();
                }
            }
        });
        this.browsersTable = this.browsersEditor.createComponent();
    }

    private void setCustomPathToFirstListed() {
        ListTableModel<ConfigurableWebBrowser> model = this.browsersEditor.getModel();
        this.alternativeBrowserPathField.setText(model.getRowCount() == 0 ? "" : ((ConfigurableWebBrowser)((Object)model.getRowValue(0))).getPath());
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.root;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserSettingsPanel", "getComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        WebBrowserManager.DefaultBrowser defaultBrowser = this.getDefaultBrowser();
        if (browserManager.getDefaultBrowserMode() != defaultBrowser || generalSettings.isConfirmExtractFiles() != this.confirmExtractFiles.isSelected()) {
            return true;
        }
        if (defaultBrowser == WebBrowserManager.DefaultBrowser.ALTERNATIVE && !Comparing.strEqual((String)generalSettings.getBrowserPath(), (String)this.alternativeBrowserPathField.getText())) {
            return true;
        }
        return this.browsersEditor.isModified(browserManager.getList());
    }

    public void apply() {
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setUseDefaultBrowser(this.getDefaultBrowser() == WebBrowserManager.DefaultBrowser.SYSTEM);
        if (this.alternativeBrowserPathField.isEnabled()) {
            settings.setBrowserPath(this.alternativeBrowserPathField.getText());
        }
        settings.setConfirmExtractFiles(this.confirmExtractFiles.isSelected());
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        browserManager.defaultBrowser = this.getDefaultBrowser();
        browserManager.setList(this.browsersEditor.apply());
    }

    private WebBrowserManager.DefaultBrowser getDefaultBrowser() {
        return (WebBrowserManager.DefaultBrowser)((Object)this.defaultBrowserComboBox.getSelectedItem());
    }

    public void reset() {
        GeneralSettings settings = GeneralSettings.getInstance();
        WebBrowserManager.DefaultBrowser defaultBrowser = WebBrowserManager.getInstance().getDefaultBrowserMode();
        this.defaultBrowserComboBox.setSelectedItem((Object)defaultBrowser);
        this.confirmExtractFiles.setSelected(settings.isConfirmExtractFiles());
        this.browsersEditor.reset(WebBrowserManager.getInstance().getList());
        this.customPathValue = settings.getBrowserPath();
        this.alternativeBrowserPathField.setEnabled(defaultBrowser == WebBrowserManager.DefaultBrowser.ALTERNATIVE);
        this.updateCustomPathTextFieldValue(defaultBrowser);
    }

    public void selectBrowser(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserSettingsPanel", "selectBrowser"));
        }
        if (browser instanceof ConfigurableWebBrowser) {
            this.browsersEditor.selectItem((ConfigurableWebBrowser)browser);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JCheckBox jCheckBox;
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.root = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.defaultBrowserPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.alternativeBrowserPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.defaultBrowserComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Default Browser:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.browsersTable;
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.confirmExtractFiles = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show confirmation before extracting files");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.clearExtractedFiles = jButton = new JButton();
        jButton.setText("Clear extracted files");
        jPanel2.add((Component)jButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

